/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mspdi;

import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedItem;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.common.AbstractTimephasedWorkNormaliser;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSPDITimephasedWorkNormaliser
extends AbstractTimephasedWorkNormaliser {
    @Override
    public void normalise(ProjectCalendar projectCalendar, LinkedList<TimephasedWork> linkedList) {
        this.splitDays(projectCalendar, linkedList);
        this.mergeSameDay(projectCalendar, linkedList);
        this.mergeSameWork(linkedList);
        this.validateSameDay(projectCalendar, linkedList);
        this.convertToHours(linkedList);
    }

    private void splitDays(ProjectCalendar projectCalendar, LinkedList<TimephasedWork> linkedList) {
        LinkedList<TimephasedWork> linkedList2 = new LinkedList<TimephasedWork>();
        Calendar calendar = Calendar.getInstance();
        block0: for (TimephasedWork timephasedWork : linkedList) {
            while (timephasedWork != null) {
                Date date = DateHelper.getDayStartDate(timephasedWork.getStart());
                Date date2 = DateHelper.getDayStartDate(timephasedWork.getFinish());
                if (timephasedWork.getFinish().getTime() == date2.getTime()) {
                    calendar.setTime(date2);
                    calendar.add(6, -1);
                    date2 = calendar.getTime();
                }
                if (date.getTime() == date2.getTime()) {
                    linkedList2.add(timephasedWork);
                    continue block0;
                }
                TimephasedWork[] timephasedWorkArray = this.splitFirstDay(projectCalendar, timephasedWork);
                if (timephasedWorkArray[0] != null) {
                    linkedList2.add(timephasedWorkArray[0]);
                }
                timephasedWork = timephasedWorkArray[1];
            }
        }
        linkedList.clear();
        linkedList.addAll(linkedList2);
    }

    private TimephasedWork[] splitFirstDay(ProjectCalendar projectCalendar, TimephasedWork timephasedWork) {
        TimephasedWork[] timephasedWorkArray = new TimephasedWork[2];
        Date date = timephasedWork.getStart();
        Date date2 = timephasedWork.getFinish();
        Duration duration = projectCalendar.getWork(date, date2, TimeUnit.MINUTES);
        Duration duration2 = (Duration)timephasedWork.getTotalAmount();
        if (duration.getDuration() != 0.0) {
            Duration duration3;
            double d;
            Date date3;
            Object object;
            Date date4;
            if (projectCalendar.isWorkingDate(date)) {
                date4 = date;
                object = projectCalendar.getFinishTime(date4);
                date3 = DateHelper.setTime(date4, (Date)object);
                d = projectCalendar.getWork(date4, date3, TimeUnit.MINUTES).getDuration();
                d *= duration2.getDuration();
                d /= duration.getDuration();
                d = NumberHelper.truncate(d, 2.0);
                duration3 = Duration.getInstance(d, TimeUnit.MINUTES);
                TimephasedWork timephasedWork2 = new TimephasedWork();
                timephasedWork2.setStart(date4);
                timephasedWork2.setFinish(date3);
                timephasedWork2.setTotalAmount(duration3);
                timephasedWorkArray[0] = timephasedWork2;
            } else {
                date3 = date;
                d = 0.0;
            }
            date4 = projectCalendar.getNextWorkStart(date3);
            date3 = date2;
            if (date4.getTime() > date3.getTime()) {
                object = null;
            } else {
                d = duration2.getDuration() - d;
                duration3 = Duration.getInstance(d, TimeUnit.MINUTES);
                object = new TimephasedWork();
                ((TimephasedItem)object).setStart(date4);
                ((TimephasedItem)object).setFinish(date3);
                ((TimephasedItem)object).setTotalAmount(duration3);
            }
            timephasedWorkArray[1] = object;
        }
        return timephasedWorkArray;
    }

    /*
     * WARNING - void declaration
     */
    private void mergeSameDay(ProjectCalendar projectCalendar, LinkedList<TimephasedWork> linkedList) {
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        TimephasedItem timephasedItem = null;
        for (TimephasedWork timephasedWork : linkedList) {
            void timephasedItem2;
            Comparable<Date> comparable;
            Comparable<Date> comparable2;
            if (timephasedItem == null) {
                timephasedWork.setAmountPerDay(timephasedWork.getTotalAmount());
                linkedList2.add(timephasedWork);
            } else {
                comparable2 = timephasedItem.getStart();
                comparable = DateHelper.getDayStartDate((Date)comparable2);
                Date date = timephasedWork.getStart();
                Date date2 = DateHelper.getDayStartDate(date);
                if (((Date)comparable).getTime() == date2.getTime()) {
                    Duration duration = (Duration)timephasedItem.getTotalAmount();
                    Duration duration2 = (Duration)timephasedWork.getTotalAmount();
                    if (duration.getDuration() != 0.0 && duration2.getDuration() == 0.0) continue;
                    linkedList2.removeLast();
                    if (duration.getDuration() != 0.0 && duration2.getDuration() != 0.0) {
                        double d = ((Duration)timephasedItem.getTotalAmount()).getDuration();
                        Duration duration3 = Duration.getInstance(d += ((Duration)timephasedWork.getTotalAmount()).getDuration(), TimeUnit.MINUTES);
                        TimephasedWork timephasedWork2 = new TimephasedWork();
                        timephasedWork2.setStart(timephasedItem.getStart());
                        timephasedWork2.setFinish(timephasedWork.getFinish());
                        timephasedWork2.setTotalAmount(duration3);
                        TimephasedWork timephasedWork3 = timephasedWork2;
                    } else if (duration2.getDuration() == 0.0) {
                        TimephasedItem timephasedItem3 = timephasedItem;
                    }
                }
                timephasedItem2.setAmountPerDay(timephasedItem2.getTotalAmount());
                linkedList2.add(timephasedItem2);
            }
            comparable2 = projectCalendar.getWork(timephasedItem2.getStart(), timephasedItem2.getFinish(), TimeUnit.MINUTES);
            comparable = (Duration)timephasedItem2.getTotalAmount();
            if (((Duration)comparable2).getDuration() == 0.0 && ((Duration)comparable).getDuration() == 0.0) {
                linkedList2.removeLast();
                continue;
            }
            timephasedItem = timephasedItem2;
        }
        linkedList.clear();
        linkedList.addAll(linkedList2);
    }

    private void validateSameDay(ProjectCalendar projectCalendar, LinkedList<TimephasedWork> linkedList) {
        for (TimephasedWork timephasedWork : linkedList) {
            Date date = timephasedWork.getStart();
            Date date2 = projectCalendar.getStartTime(date);
            Date date3 = DateHelper.getCanonicalTime(date);
            Date date4 = timephasedWork.getFinish();
            Date date5 = projectCalendar.getFinishTime(date4);
            Date date6 = DateHelper.getCanonicalTime(date4);
            double d = ((Duration)timephasedWork.getTotalAmount()).getDuration();
            if (date3 != null && date2 != null && (d == 0.0 && date3.getTime() != date2.getTime() || date3.getTime() < date2.getTime())) {
                date = DateHelper.setTime(date, date2);
                timephasedWork.setStart(date);
            }
            if (date6 == null || date5 == null || (d != 0.0 || date6.getTime() == date5.getTime()) && date6.getTime() <= date5.getTime()) continue;
            date4 = DateHelper.setTime(date4, date5);
            timephasedWork.setFinish(date4);
        }
    }
}

