/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import com.rc.retroweaver.runtime.ClassLiteral;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.actions.OfflineActionTarget;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.autoedit.IIndentPrefs;
import org.python.pydev.editor.autoedit.PyAutoIndentStrategy;

public class PyBackspace
extends PyAction {
    private IIndentPrefs prefs;
    private int dontEraseMoreThan = -1;

    public void setIndentPrefs(IIndentPrefs prefs) {
        this.prefs = prefs;
    }

    public IIndentPrefs getIndentPrefs() {
        if (this.prefs == null) {
            this.prefs = this.getPyEdit().getIndentPrefs();
        }
        return this.prefs;
    }

    public void perform(PySelection ps) {
        try {
            IRegion lastCharRegion;
            ITextSelection textSelection = ps.getTextSelection();
            if (textSelection.getLength() != 0) {
                this.eraseSelection(ps);
                return;
            }
            int lastCharPosition = this.getLastCharPosition(ps.getDoc(), ps.getLineOffset());
            int cursorOffset = textSelection.getOffset();
            if (cursorOffset == (lastCharRegion = ps.getDoc().getLineInformationOfOffset(lastCharPosition + 1)).getOffset()) {
                if (cursorOffset != 0) {
                    this.eraseLineDelimiter(ps);
                }
            } else if (cursorOffset <= lastCharPosition) {
                this.eraseToPreviousIndentation(ps, false, lastCharRegion);
            } else if (lastCharRegion.getOffset() == lastCharPosition + 1) {
                this.eraseToPreviousIndentation(ps, true, lastCharRegion);
            } else if (cursorOffset - lastCharPosition == 1) {
                this.eraseSingleChar(ps);
            } else if (cursorOffset - lastCharPosition > 1) {
                this.eraseUntilLastChar(ps, lastCharPosition);
            }
        }
        catch (Exception e) {
            PyBackspace.beep(e);
        }
    }

    public void run(IAction action) {
        OfflineActionTarget adapter = (OfflineActionTarget)this.getPyEdit().getAdapter(ClassLiteral.getClass((String)"org/python/pydev/editor/actions/OfflineActionTarget"));
        if (adapter != null && adapter.isInstalled()) {
            adapter.removeLastCharSearchAndUpdateStatus();
            return;
        }
        PySelection ps = new PySelection(this.getTextEditor());
        this.perform(ps);
    }

    private void eraseToPreviousIndentation(PySelection ps, boolean hasOnlyWhitespaces, IRegion lastCharRegion) throws BadLocationException {
        String lineContentsToCursor = ps.getLineContentsToCursor();
        if (hasOnlyWhitespaces) {
            this.eraseToIndentation(ps, lineContentsToCursor);
        } else if (PySelection.containsOnlyWhitespaces((String)lineContentsToCursor)) {
            this.eraseToIndentation(ps, lineContentsToCursor);
        } else {
            this.eraseSingleChar(ps);
        }
    }

    private void eraseSingleChar(PySelection ps) throws BadLocationException {
        ITextSelection textSelection = ps.getTextSelection();
        this.makeDelete(ps.getDoc(), textSelection.getOffset() - 1, 1);
    }

    private void eraseLineDelimiter(PySelection ps) throws BadLocationException {
        ITextSelection textSelection = ps.getTextSelection();
        int length = PyBackspace.getDelimiter(ps.getDoc()).length();
        int offset = textSelection.getOffset() - length;
        this.makeDelete(ps.getDoc(), offset, length);
    }

    private void eraseSelection(PySelection ps) throws BadLocationException {
        ITextSelection textSelection = ps.getTextSelection();
        this.makeDelete(ps.getDoc(), textSelection.getOffset(), textSelection.getLength());
    }

    private void eraseUntilLastChar(PySelection ps, int lastCharPosition) throws BadLocationException {
        ITextSelection textSelection = ps.getTextSelection();
        int cursorOffset = textSelection.getOffset();
        int offset = lastCharPosition + 1;
        int length = cursorOffset - lastCharPosition - 1;
        this.makeDelete(ps.getDoc(), offset, length);
    }

    private void eraseToIndentation(PySelection ps, String lineContentsToCursor) throws BadLocationException {
        int replaceLength;
        int replaceOffset;
        char c;
        int cursorOffset = ps.getAbsoluteCursorOffset();
        int cursorLine = ps.getCursorLine();
        int lineContentsToCursorLen = lineContentsToCursor.length();
        if (lineContentsToCursorLen > 0 && (c = lineContentsToCursor.charAt(lineContentsToCursorLen - 1)) == '\t') {
            this.eraseSingleChar(ps);
            return;
        }
        String indentationString = this.getIndentPrefs().getIndentationString();
        int indentationLength = indentationString.length();
        int modLen = lineContentsToCursorLen % indentationLength;
        if (modLen == 0) {
            replaceOffset = cursorOffset - indentationLength;
            replaceLength = indentationLength;
        } else {
            replaceOffset = cursorOffset - modLen;
            replaceLength = modLen;
        }
        IDocument doc = ps.getDoc();
        if (cursorLine > 0) {
            int newReplaceOffset;
            int initialLineOffset;
            IRegion prevLineInfo = doc.getLineInformation(cursorLine - 1);
            int prevLineEndOffset = prevLineInfo.getOffset() + prevLineInfo.getLength();
            Tuple<Integer, Boolean> tup = PyAutoIndentStrategy.determineSmartIndent(prevLineEndOffset, ps, this.prefs);
            Integer previousContextSmartIndent = (Integer)tup.o1;
            if (previousContextSmartIndent > 0 && lineContentsToCursorLen > previousContextSmartIndent && replaceOffset < (initialLineOffset = cursorOffset - lineContentsToCursorLen) + previousContextSmartIndent && (newReplaceOffset = initialLineOffset + previousContextSmartIndent + 1) != cursorOffset) {
                replaceOffset = newReplaceOffset;
                replaceLength = cursorOffset - replaceOffset;
            }
        }
        if (replaceLength > 1) {
            String strToReplace = doc.get(replaceOffset, replaceLength);
            char prev = '\u0000';
            int i = strToReplace.length() - 1;
            while (i >= 0) {
                char c2 = strToReplace.charAt(i);
                if (prev != '\u0000' && c2 != prev) {
                    replaceOffset += i + 1;
                    replaceLength -= i + 1;
                    break;
                }
                prev = c2;
                --i;
            }
        }
        this.makeDelete(doc, replaceOffset, replaceLength);
    }

    private void makeDelete(IDocument doc, int replaceOffset, int replaceLength) throws BadLocationException {
        if (replaceOffset < this.dontEraseMoreThan) {
            int delta = this.dontEraseMoreThan - replaceOffset;
            replaceOffset = this.dontEraseMoreThan;
            if ((replaceLength -= delta) <= 0) {
                return;
            }
        }
        doc.replace(replaceOffset, replaceLength, "");
    }

    public void setDontEraseMoreThan(int offset) {
        this.dontEraseMoreThan = offset;
    }
}

