/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.async;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import oracle.xml.async.DOMBuilderConstants;
import oracle.xml.async.DOMBuilderErrorEvent;
import oracle.xml.async.DOMBuilderErrorListener;
import oracle.xml.async.DOMBuilderEvent;
import oracle.xml.async.DOMBuilderListener;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.NodeFactory;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMBuilder
implements Serializable,
DOMBuilderConstants,
Runnable {
    protected Reader reader;
    protected String rootName;
    protected String inString;
    protected InputStream inStream;
    protected URL url;
    protected InputSource inSource;
    protected int methodToCall = 0;
    protected XMLDocument result;
    private int id;
    private Vector DOMEventListenerVect = new Vector();
    private Vector ErrorEventListenerVect = new Vector();
    private boolean workingFlag;
    DOMParser parser;
    Thread thrd;

    public DOMBuilder() {
        this.id = 0;
        this.parser = new DOMParser();
        this.parser.setPreserveWhitespace(false);
        this.thrd = new Thread(this);
        this.workingFlag = false;
    }

    public DOMBuilder(int n) {
        this.id = n;
        this.parser = new DOMParser();
        this.parser.setPreserveWhitespace(false);
        this.thrd = new Thread(this);
        this.workingFlag = false;
    }

    public int getId() {
        return this.id;
    }

    public void run() {
        this.workingFlag = true;
        this.fireDOMBuilderEvent(0);
        try {
            switch (this.methodToCall) {
                case 1: {
                    this.parser.parseDTD(this.reader, this.rootName);
                    break;
                }
                case 2: {
                    this.parser.parseDTD(this.inStream, this.rootName);
                    break;
                }
                case 3: {
                    this.parser.parseDTD(this.url, this.rootName);
                    break;
                }
                case 4: {
                    this.parser.parseDTD(this.inString, this.rootName);
                    break;
                }
                case 5: {
                    this.parser.parseDTD(this.inSource, this.rootName);
                    break;
                }
                case 6: {
                    this.parser.parse(this.reader);
                    break;
                }
                case 7: {
                    this.parser.parse(this.inStream);
                    break;
                }
                case 8: {
                    this.parser.parse(this.url);
                    break;
                }
                case 9: {
                    this.parser.parse(this.inString);
                    break;
                }
                case 10: {
                    this.parser.parse(this.inSource);
                }
            }
        }
        catch (Exception exception) {
            this.fireDOMBuilderErrorEvent(new DOMBuilderErrorEvent(this, exception));
            this.fireDOMBuilderEvent(2);
        }
        this.workingFlag = false;
        this.fireDOMBuilderEvent(1);
    }

    public void addDOMBuilderListener(DOMBuilderListener dOMBuilderListener) {
        this.DOMEventListenerVect.addElement(dOMBuilderListener);
    }

    public void addDOMBuilderErrorListener(DOMBuilderErrorListener dOMBuilderErrorListener) {
        this.ErrorEventListenerVect.addElement(dOMBuilderErrorListener);
    }

    public synchronized void removeDOMBuilderListener(DOMBuilderListener dOMBuilderListener) {
        this.DOMEventListenerVect.removeElement(dOMBuilderListener);
    }

    public synchronized void removeDOMBuilderErrorListener(DOMBuilderErrorListener dOMBuilderErrorListener) {
        this.ErrorEventListenerVect.removeElement(dOMBuilderErrorListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void fireDOMBuilderEvent(int n) {
        Vector vector;
        Serializable serializable = this;
        synchronized (serializable) {
            vector = (Vector)this.DOMEventListenerVect.clone();
        }
        serializable = new DOMBuilderEvent(this, this.id);
        for (int i = 0; i < vector.size(); ++i) {
            DOMBuilderListener dOMBuilderListener = (DOMBuilderListener)vector.elementAt(i);
            if (n == 0) {
                dOMBuilderListener.domBuilderStarted((DOMBuilderEvent)serializable);
                continue;
            }
            if (n == 1) {
                dOMBuilderListener.domBuilderOver((DOMBuilderEvent)serializable);
                continue;
            }
            if (n != 2) continue;
            dOMBuilderListener.domBuilderError((DOMBuilderEvent)serializable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void fireDOMBuilderErrorEvent(DOMBuilderErrorEvent dOMBuilderErrorEvent) {
        Vector vector;
        DOMBuilder dOMBuilder = this;
        synchronized (dOMBuilder) {
            vector = (Vector)this.ErrorEventListenerVect.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            DOMBuilderErrorListener dOMBuilderErrorListener = (DOMBuilderErrorListener)vector.elementAt(i);
            dOMBuilderErrorListener.domBuilderErrorCalled(dOMBuilderErrorEvent);
        }
    }

    public synchronized Document getResult() {
        while (this.workingFlag) {
        }
        this.result = this.parser.getDocument();
        return this.result;
    }

    public synchronized DTD getDoctype() {
        while (this.workingFlag) {
        }
        return this.parser.getDoctype();
    }

    public void setDebugMode(boolean bl) {
        while (this.workingFlag) {
        }
        this.parser.setDebugMode(bl);
    }

    public synchronized void showWarnings(boolean bl) {
        while (this.workingFlag) {
        }
        this.parser.showWarnings(bl);
    }

    public final synchronized void setErrorStream(PrintWriter printWriter) throws IOException {
        while (this.workingFlag) {
        }
        this.parser.setErrorStream(printWriter);
    }

    public final synchronized void setErrorStream(OutputStream outputStream) throws IOException {
        while (this.workingFlag) {
        }
        this.parser.setErrorStream(outputStream);
    }

    public final synchronized void setErrorStream(OutputStream outputStream, String string) throws IOException {
        while (this.workingFlag) {
        }
        this.parser.setErrorStream(outputStream, string);
    }

    public synchronized XMLDocument getDocument() {
        while (this.workingFlag) {
        }
        return this.parser.getDocument();
    }

    public synchronized void setNodeFactory(NodeFactory nodeFactory) throws XMLParseException {
        while (this.workingFlag) {
        }
        this.parser.setNodeFactory(nodeFactory);
    }

    public synchronized void setDoctype(DTD dTD) {
        while (this.workingFlag) {
        }
        this.parser.setDoctype(dTD);
    }

    public synchronized void setValidationMode(boolean bl) {
        while (this.workingFlag) {
        }
        if (bl) {
            this.parser.setValidationMode(2);
        } else {
            this.parser.setValidationMode(0);
        }
    }

    public synchronized void setBaseURL(URL uRL) {
        while (this.workingFlag) {
        }
        this.parser.setBaseURL(uRL);
    }

    public synchronized void setPreserveWhitespace(boolean bl) {
        while (this.workingFlag) {
        }
        this.parser.setPreserveWhitespace(bl);
    }

    public synchronized boolean getValidationMode() {
        while (this.workingFlag) {
        }
        return this.parser.getValidationMode();
    }

    public synchronized String getReleaseVersion() {
        while (this.workingFlag) {
        }
        DOMBuilder dOMBuilder = this;
        String string = dOMBuilder.parser.getReleaseVersion();
        return string;
    }

    public final synchronized void parse(InputSource inputSource) throws XMLParseException, SAXException, IOException {
        while (this.workingFlag) {
        }
        this.inSource = inputSource;
        this.methodToCall = 10;
        this.thrd.start();
    }

    public final synchronized void parse(String string) throws XMLParseException, SAXException, IOException {
        while (this.workingFlag) {
        }
        this.inString = string;
        this.methodToCall = 9;
        this.thrd.start();
    }

    public final synchronized void parse(URL uRL) throws XMLParseException, SAXException, IOException {
        while (this.workingFlag) {
        }
        this.url = uRL;
        this.methodToCall = 8;
        this.thrd.start();
    }

    public final synchronized void parse(InputStream inputStream) throws XMLParseException, SAXException, IOException {
        while (this.workingFlag) {
        }
        this.inStream = inputStream;
        this.methodToCall = 7;
        this.thrd.start();
    }

    public final synchronized void parse(Reader reader) throws XMLParseException, SAXException, IOException {
        while (this.workingFlag) {
        }
        this.reader = reader;
        this.methodToCall = 6;
        this.thrd.start();
    }

    public final synchronized void parseDTD(InputSource inputSource, String string) throws XMLParseException, SAXException, IOException {
        while (this.workingFlag) {
        }
        this.inSource = inputSource;
        this.rootName = string;
        this.methodToCall = 5;
        this.thrd.start();
    }

    public final synchronized void parseDTD(String string, String string2) throws XMLParseException, SAXException, IOException {
        while (this.workingFlag) {
        }
        this.inString = string;
        this.rootName = string2;
        this.methodToCall = 4;
        this.thrd.start();
    }

    public final synchronized void parseDTD(URL uRL, String string) throws XMLParseException, SAXException, IOException {
        while (this.workingFlag) {
        }
        this.url = uRL;
        this.rootName = string;
        this.methodToCall = 3;
        this.thrd.start();
    }

    public final synchronized void parseDTD(InputStream inputStream, String string) throws XMLParseException, SAXException, IOException {
        while (this.workingFlag) {
        }
        this.inStream = inputStream;
        this.rootName = string;
        this.methodToCall = 2;
        this.thrd.start();
    }

    public final synchronized void parseDTD(Reader reader, String string) throws XMLParseException, SAXException, IOException {
        while (this.workingFlag) {
        }
        this.reader = reader;
        this.rootName = string;
        this.methodToCall = 1;
        this.thrd.start();
    }
}

