/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Catalog;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.NameTree;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.util.Library;

public class Destination {
    private static final Logger logger = Logger.getLogger(Destination.class.toString());
    private Library library;
    private Object object;
    private Reference ref;
    private float left = Float.NaN;
    private float top = Float.NaN;
    private float zoom = Float.NaN;
    private boolean inited = false;

    public Destination(Library library, Object object) {
        this.library = library;
        this.object = object;
    }

    void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        if (this.object instanceof Vector) {
            this.parse((Vector)this.object);
        } else if (this.object instanceof Name || this.object instanceof StringObject) {
            String string;
            if (this.object instanceof StringObject) {
                StringObject stringObject = (StringObject)this.object;
                stringObject.getDecryptedLiteralString(this.library.securityManager);
                string = stringObject.getDecryptedLiteralString(this.library.securityManager);
            } else {
                string = this.object.toString();
            }
            boolean bl = false;
            Catalog catalog = this.library.getCatalog();
            if (catalog != null) {
                Object object;
                Object object2;
                NameTree nameTree = catalog.getNameTree();
                if (nameTree != null && (object2 = nameTree.searchName(string)) != null) {
                    Object v;
                    if (object2 instanceof Vector) {
                        this.parse((Vector)object2);
                        bl = true;
                    } else if (object2 instanceof Hashtable && (v = ((Hashtable)(object = (Hashtable)object2)).get("D")) instanceof Vector) {
                        this.parse((Vector)v);
                        bl = true;
                    }
                }
                if (!bl && (object2 = catalog.getDestinations()) != null) {
                    object = ((Dictionary)object2).getObject(string);
                    if (object instanceof Hashtable) {
                        this.parse((Vector)((Hashtable)object).get("D"));
                    } else if (logger.isLoggable(Level.FINE)) {
                        logger.warning("Destination type missed=" + object);
                    }
                }
            }
        }
    }

    private void parse(Vector vector) {
        if (vector.elementAt(0) instanceof Reference) {
            this.ref = (Reference)vector.elementAt(0);
        }
        if (vector.elementAt(1).equals("XYZ")) {
            if (!vector.elementAt(2).equals("null")) {
                this.left = ((Number)vector.elementAt(2)).floatValue();
            }
            if (!vector.elementAt(3).equals("null")) {
                this.top = ((Number)vector.elementAt(3)).floatValue();
            }
            if (!vector.elementAt(4).equals("null") && !vector.elementAt(4).equals("0")) {
                this.zoom = ((Number)vector.elementAt(4)).floatValue();
            }
        } else if (vector.elementAt(1).equals("Fit")) {
            // empty if block
        }
    }

    public Reference getPageReference() {
        if (!this.inited) {
            this.init();
        }
        return this.ref;
    }

    public float getLeft() {
        if (!this.inited) {
            this.init();
        }
        return this.left;
    }

    public float getTop() {
        if (!this.inited) {
            this.init();
        }
        return this.top;
    }

    public float getZoom() {
        if (!this.inited) {
            this.init();
        }
        return this.zoom;
    }

    public String toString() {
        return "Destination  ref: " + this.getPageReference() + " ,  top: " + this.getTop() + " ,  left: " + this.getLeft() + " ,  zoom: " + this.getZoom();
    }
}

