/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.functions;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.functions.Function;

public class Function_0
extends Function {
    private static final Logger logger = Logger.getLogger(Function_0.class.toString());
    private int[] size;
    private int bitspersample;
    private int order;
    private float[] encode;
    private float[] decode;
    private byte[] bytes;

    Function_0(Dictionary dictionary) {
        super(dictionary);
        int n;
        Vector vector = (Vector)dictionary.getObject("Size");
        this.size = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            this.size[i] = (int)((Number)vector.elementAt(i)).floatValue();
        }
        this.bitspersample = dictionary.getInt("BitsPerSample");
        Vector vector2 = (Vector)dictionary.getObject("Encode");
        this.encode = new float[this.size.length * 2];
        if (vector2 != null) {
            for (n = 0; n < this.size.length * 2; ++n) {
                this.encode[n] = ((Number)vector2.elementAt(n)).floatValue();
            }
        } else {
            for (n = 0; n < this.size.length; ++n) {
                this.encode[2 * n] = 0.0f;
                this.encode[2 * n + 1] = this.size[n] - 1;
            }
        }
        Vector vector3 = (Vector)dictionary.getObject("Decode");
        this.decode = new float[this.range.length];
        if (vector3 != null) {
            for (int i = 0; i < this.range.length; ++i) {
                this.decode[i] = ((Number)vector3.elementAt(i)).floatValue();
            }
        } else {
            System.arraycopy(this.range, 0, this.decode, 0, this.range.length);
        }
        Stream stream = (Stream)dictionary;
        this.bytes = stream.getBytes();
    }

    public float[] calculate(float[] fArray) {
        int n = this.range.length / 2;
        float[] fArray2 = new float[n];
        try {
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = Math.min(Math.max(fArray[i], this.domain[2 * i]), this.domain[2 * i + 1]);
                float f = this.interpolate(fArray[i], this.domain[2 * i], this.domain[2 * i + 1], this.encode[2 * i], this.encode[2 * i + 1]);
                f = Math.min(Math.max(f, 0.0f), (float)(this.size[i] - 1));
                int n2 = (int)Math.floor(f);
                int n3 = (int)Math.ceil(f);
                for (int j = 0; j < n; ++j) {
                    int n4 = this.bytes[n2 * n + j] & 0xFF;
                    int n5 = this.bytes[n3 * n + j] & 0xFF;
                    float f2 = ((float)n4 + (float)n5) / 2.0f;
                    f2 = this.interpolate(f2, 0.0f, (float)Math.pow(2.0, this.bitspersample) - 1.0f, this.decode[2 * j], this.decode[2 * j + 1]);
                    f2 = Math.min(Math.max(f2, this.range[2 * j]), this.range[2 * j + 1]);
                    int n6 = i * n + j;
                    if (n6 >= fArray2.length) continue;
                    fArray2[n6] = f2;
                }
            }
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Error calculating fucntion 0 values", exception);
        }
        return fArray2;
    }
}

