/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.util.Library;

public class Indexed
extends PColorSpace {
    PColorSpace colorSpace;
    int hival;
    byte[] colors = new byte[]{-1, -1, -1, 0, 0, 0};
    private boolean inited = false;
    private Color[] cols;

    Indexed(Library library, Hashtable hashtable, Vector vector) {
        super(library, hashtable);
        this.colorSpace = Indexed.getColorSpace(library, vector.elementAt(1));
        this.hival = ((Number)vector.elementAt(2)).intValue();
        if (vector.elementAt(3) instanceof StringObject) {
            StringObject stringObject = (StringObject)vector.elementAt(3);
            String string = stringObject.getDecryptedLiteralString(library.securityManager);
            byte[] byArray = new byte[this.colorSpace.getNumComponents() * (this.hival + 1)];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)string.charAt(i);
            }
            this.colors = byArray;
        } else if (vector.elementAt(3) instanceof Reference) {
            Stream stream = (Stream)library.getObject((Reference)vector.elementAt(3));
            this.colors = stream.getBytes();
        }
    }

    public int getNumComponents() {
        return 1;
    }

    public void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        int n = this.colorSpace.getNumComponents();
        int[] nArray = new int[n];
        float[] fArray = new float[n];
        this.cols = new Color[this.hival + 1];
        for (int i = 0; i <= this.hival; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[n - 1 - j] = 0xFF & this.colors[i * n + j];
            }
            this.colorSpace.normaliseComponentsToFloats(nArray, fArray, 255.0f);
            this.cols[i] = this.colorSpace.getColor(fArray);
        }
    }

    public Color getColor(float[] fArray) {
        this.init();
        int n = (int)(fArray[0] * (float)(this.cols.length - 1));
        return this.cols[n];
    }

    public Color[] accessColorTable() {
        return this.cols;
    }
}

