/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.util.Library;

public class Lab
extends PColorSpace {
    private float[] whitePoint = new float[]{0.95047f, 1.0f, 1.08883f};
    private float[] blackPoint = new float[]{0.0f, 0.0f, 0.0f};
    private float[] range = new float[]{-100.0f, 100.0f, -100.0f, 100.0f};
    private float lBase;
    private float lSpread;
    private float aBase;
    private float aSpread;
    private float bBase;
    private float bSpread;
    private float xBase;
    private float xSpread;
    private float yBase;
    private float ySpread;
    private float zBase;
    private float zSpread;

    Lab(Library library, Hashtable hashtable) {
        super(library, hashtable);
        Vector vector = (Vector)library.getObject(hashtable, "WhitePoint");
        if (vector != null) {
            this.whitePoint[0] = ((Number)vector.elementAt(0)).floatValue();
            this.whitePoint[1] = ((Number)vector.elementAt(1)).floatValue();
            this.whitePoint[2] = ((Number)vector.elementAt(2)).floatValue();
        }
        if ((vector = (Vector)library.getObject(hashtable, "Range")) != null) {
            this.range[0] = ((Number)vector.elementAt(0)).floatValue();
            this.range[1] = ((Number)vector.elementAt(1)).floatValue();
            this.range[2] = ((Number)vector.elementAt(2)).floatValue();
            this.range[3] = ((Number)vector.elementAt(3)).floatValue();
        }
        this.lBase = 0.0f;
        this.lSpread = 100.0f;
        this.aBase = this.range[0];
        this.aSpread = this.range[1] - this.aBase;
        this.bBase = this.range[2];
        this.bSpread = this.range[3] - this.bBase;
        this.xBase = this.blackPoint[0];
        this.xSpread = this.whitePoint[0] - this.xBase;
        this.yBase = this.blackPoint[1];
        this.ySpread = this.whitePoint[1] - this.yBase;
        this.zBase = this.blackPoint[2];
        this.zSpread = this.whitePoint[2] - this.zBase;
    }

    public int getNumComponents() {
        return 3;
    }

    private double g(double d) {
        d = d < (double)0.2069f ? 0.12842 * (d - 0.13793) : d * d * d;
        return d;
    }

    private double gg(double d) {
        d = d > 0.0031308 ? 1.055 * Math.pow(d, 0.4166666666666667) - 0.055 : (d *= 12.92);
        return d;
    }

    public void normaliseComponentsToFloats(int[] nArray, float[] fArray, float f) {
        super.normaliseComponentsToFloats(nArray, fArray, f);
        fArray[2] = this.lBase + this.lSpread * fArray[2];
        fArray[1] = this.aBase + this.aSpread * fArray[1];
        fArray[0] = this.bBase + this.bSpread * fArray[0];
    }

    public Color getColor(float[] fArray) {
        double d = fArray[0];
        double d2 = fArray[1];
        double d3 = fArray[2];
        double d4 = (d3 + 16.0) / 116.0;
        double d5 = d4 + d2 * 0.002;
        double d6 = d4 - d * 0.005;
        double d7 = this.g(d5);
        double d8 = this.g(d4);
        double d9 = this.g(d6);
        d7 = (double)this.xBase + d7 * (double)this.xSpread;
        d8 = (double)this.yBase + d8 * (double)this.ySpread;
        d9 = (double)this.zBase + d9 * (double)this.zSpread;
        d7 = Math.max(0.0, Math.min(1.0, d7));
        d8 = Math.max(0.0, Math.min(1.0, d8));
        d9 = Math.max(0.0, Math.min(1.0, d9));
        double d10 = d7 * 3.241 + d8 * -1.5374 + d9 * -0.4986;
        double d11 = d7 * -0.9692 + d8 * 1.876 + d9 * 0.0416;
        double d12 = d7 * 0.0556 + d8 * -0.204 + d9 * 1.057;
        d10 = this.gg(d10);
        d11 = this.gg(d11);
        d12 = this.gg(d12);
        int n = (int)(d10 * 255.0);
        int n2 = (int)(d11 * 255.0);
        int n3 = (int)(d12 * 255.0);
        n = Math.max(0, Math.min(255, n));
        n2 = Math.max(0, Math.min(255, n2));
        n3 = Math.max(0, Math.min(255, n3));
        return new Color(n, n2, n3);
    }
}

