/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.ctl;

import com.sun.jndi.ldap.BasicControl;
import com.sun.jndi.ldap.BerDecoder;
import com.sun.jndi.ldap.LdapCtx;
import java.io.IOException;
import javax.naming.NamingException;

public final class SortResponseControl
extends BasicControl {
    public static final String OID = "1.2.840.113556.1.4.474";
    private int resultCode = 0;
    private String badAttrId = null;

    public SortResponseControl(String string, boolean bl, byte[] byArray) throws IOException {
        super(string, bl, byArray);
        if (byArray != null && byArray.length > 0) {
            BerDecoder berDecoder = new BerDecoder(byArray, 0, byArray.length);
            berDecoder.parseSeq(null);
            this.resultCode = berDecoder.parseEnumeration();
            if (berDecoder.bytesLeft() > 0 && berDecoder.peekByte() == 128) {
                this.badAttrId = berDecoder.parseStringWithTag(128, true, null);
            }
        }
    }

    public String getAttributeID() {
        return this.badAttrId;
    }

    public NamingException getException() {
        return LdapCtx.mapErrorCode(this.resultCode, null);
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public boolean isSorted() {
        return this.resultCode == 0;
    }
}

