/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.security;

import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import oracle.security.jazn.realm.Realm;
import oracle.security.jazn.realm.RealmRole;
import oracle.security.jazn.realm.RealmUser;

public class OracleUser
implements Principal {
    private LoginContext context;
    private Subject subject;

    public OracleUser(LoginContext context) throws LoginException {
        this.context = context;
        context.logout();
        context.login();
        this.subject = context.getSubject();
    }

    public void logout() throws LoginException {
        this.context.logout();
    }

    private Principal userPrincipal() {
        Set possibleUsers = this.subject.getPrincipals(RealmUser.class);
        return (Principal)possibleUsers.iterator().next();
    }

    public boolean isMemberOf(List roleNames) {
        boolean result = false;
        Set possibleUsers = this.subject.getPrincipals(RealmRole.class);
        Iterator itr = possibleUsers.iterator();
        while (itr.hasNext()) {
            RealmRole role = (RealmRole)itr.next();
            Realm realm = role.getRealm();
            String realmFullName = realm.getFullName();
            String roleSimpleName = role.getName();
            if (realmFullName.length() > 0 && roleSimpleName.startsWith(realmFullName)) {
                roleSimpleName = roleSimpleName.substring(realmFullName.length() + 1);
            }
            if (!roleNames.contains(roleSimpleName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object == this) {
            result = true;
        } else if (object instanceof OracleUser) {
            OracleUser other = (OracleUser)object;
            result = this.subject.equals(other.subject);
        }
        return result;
    }

    public String getName() {
        return this.userPrincipal().getName();
    }

    public int hashCode() {
        return this.subject.hashCode();
    }

    public String toString() {
        return this.subject.toString();
    }
}

