/*
 * Decompiled with CFR 0.152.
 */
package org.openamf;

import java.util.List;
import org.openamf.AMFBody;
import org.openamf.config.ServiceConfig;
import org.openamf.config.ServiceMethodConfig;

public class ServiceRequest {
    private AMFBody requestBody;
    private ServiceConfig serviceConfig;
    private ServiceMethodConfig methodConfig;
    private String target;
    private String serviceName;
    private String serviceMethodName;
    private List parameters;

    public ServiceRequest(AMFBody requestBody) {
        this(requestBody, null);
    }

    public ServiceRequest(AMFBody requestBody, ServiceConfig serviceConfig) {
        this.requestBody = requestBody;
        this.serviceConfig = serviceConfig;
        this.target = requestBody.getTarget();
        this.serviceName = serviceConfig == null ? requestBody.getServiceName() : serviceConfig.getServiceLocation();
        this.serviceMethodName = requestBody.getServiceMethodName();
        Object value = requestBody.getValue();
        if (value != null && value instanceof List) {
            this.parameters = (List)value;
        }
    }

    public AMFBody getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(AMFBody body) {
        this.requestBody = body;
    }

    public ServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    public ServiceMethodConfig getServiceMethodConfig() {
        return this.methodConfig;
    }

    void setServiceMethodConfig(ServiceMethodConfig methodConfig) {
        this.methodConfig = methodConfig;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getServiceMethodName() {
        return this.serviceMethodName;
    }

    public void setServiceMethodName(String string) {
        this.serviceMethodName = string;
    }

    public List getParameters() {
        return this.parameters;
    }

    public void setParameters(List list) {
        this.parameters = list;
    }

    public void addParameter(Object stateBean) {
        this.parameters.add(stateBean);
    }

    public String toString() {
        return String.valueOf(this.requestBody);
    }
}

