/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.audio.vorbis;

public class OggReader {
    byte[] data;
    int offset;
    int bitPointer;
    private static long[] maskBits = new long[]{0L, 1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, -1L};

    public void setData(byte[] byArray, int n) {
        this.data = byArray;
        this.offset = n;
        this.bitPointer = 0;
    }

    public void skipBits(int n) {
        this.offset += (this.bitPointer + n) / 8;
        this.bitPointer = this.bitPointer + n & 7;
    }

    public long showBits(int n) {
        long l = maskBits[n];
        long l2 = (this.data[this.offset] & 0xFF) >> this.bitPointer;
        if ((n += this.bitPointer) > 8) {
            l2 |= (long)((this.data[this.offset + 1] & 0xFF) << 8 - this.bitPointer);
        }
        if (n > 16) {
            l2 |= (long)((this.data[this.offset + 2] & 0xFF) << 16 - this.bitPointer);
        }
        if (n > 24) {
            l2 |= (long)((this.data[this.offset + 3] & 0xFF) << 24 - this.bitPointer);
        }
        if (n > 32) {
            l2 |= (long)((this.data[this.offset + 4] & 0xFF) << 32 - this.bitPointer);
        }
        return l2 & l;
    }

    public long getBits(int n) {
        long l = maskBits[n];
        long l2 = (this.data[this.offset] & 0xFF) >> this.bitPointer;
        if ((n += this.bitPointer) > 8) {
            l2 |= (long)((this.data[this.offset + 1] & 0xFF) << 8 - this.bitPointer);
        }
        if (n > 16) {
            l2 |= (long)((this.data[this.offset + 2] & 0xFF) << 16 - this.bitPointer);
        }
        if (n > 24) {
            l2 |= (long)((this.data[this.offset + 3] & 0xFF) << 24 - this.bitPointer);
        }
        if (n > 32) {
            l2 |= (long)((this.data[this.offset + 4] & 0xFF) << 32 - this.bitPointer);
        }
        this.offset += n / 8;
        this.bitPointer = n & 7;
        return l2 & l;
    }
}

