/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.demux.avi;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;
import net.sourceforge.jffmpeg.GPLLicense;
import net.sourceforge.jffmpeg.demux.avi.AviDemux;
import net.sourceforge.jffmpeg.demux.avi.AviTrack;

class Video
extends AviTrack
implements GPLLicense {
    private int streamNumber;
    private String compressor;
    private int scale;
    private int rate;

    public Video(AviDemux aviDemux, int n, String string, int n2, int n3) {
        super(aviDemux);
        this.streamNumber = n;
        this.compressor = string;
        this.scale = n2;
        this.rate = n3;
    }

    public boolean isVideo() {
        return true;
    }

    public String toString() {
        return "Stream: " + this.streamNumber + " Compressor " + this.compressor + "  Scale " + this.scale + " Rate " + this.rate;
    }

    public int getWidth() {
        return AviDemux.str2ulong(this.bih, 8);
    }

    public int getHeight() {
        return AviDemux.str2ulong(this.bih, 12);
    }

    public String getVideoTag() {
        return new String(new char[]{(char)(this.streamNumber / 10 + 48), (char)(this.streamNumber % 10 + 48), 'd', 'b'});
    }

    public Format getFormat() {
        return new VideoFormat(this.compressor, new Dimension(this.getWidth(), this.getHeight()), 10000, new byte[0].getClass(), (float)this.rate / 100.0f);
    }

    public int getPaletteCount() {
        return AviDemux.str2ulong(this.bih, 32);
    }
}

