#-----------------------------------------------------------
# malware.pl
#
# This plugin is essentially a 'container' for a lot of other individual
#  plugins, running the queries against any hive.
#
# References:
#  <included inline>
#
# Change history:
#  20150828 - created
#
# copyright 2015 Quantum Analytics Research, LLC
# Author: H. Carvey, keydet89@yahoo.com
#-----------------------------------------------------------
package malware;
use strict;

my %config = (hive          => "All",
              hasShortDescr => 1,
              hasDescr      => 0,
              hasRefs       => 0,
              osmask        => 22,
              category      => "malware",
              version       => 20150828);

sub getConfig{return %config}
sub getShortDescr {
	return "Checks for malware-related keys/values";	
}
sub getDescr{}
sub getRefs {}
sub getHive {return $config{hive};}
sub getVersion {return $config{version};}

my $VERSION = getVersion();

sub pluginmain {
	my $class = shift;
	my $hive = shift;
	::logMsg("Launching malware v.".$VERSION);
	::rptMsg("malware v.".$VERSION); # banner
  ::rptMsg("(".getHive().") ".getShortDescr()."\n"); # banner
	my $reg = Parse::Win32Registry->new($hive);
	my $root_key = $reg->get_root_key;
	my $key_path;
	my $key;

# Security Hive
# This is the same code as the secrets.pl plugin - provides an indication
# regarding the use of GSecDump on systems; see "The Art of Memory Forensics",
# 

	eval {
		$key_path = "Policy\\Secrets";
		$key;
		if ($key = $root_key->get_subkey($key_path)) {
			::rptMsg($key_path);
			::rptMsg("LastWrite Time ".gmtime($key->get_timestamp())." (UTC)");
			::rptMsg("");
		}
	};


# System Hive
# First, need to get the value for the CurrentControlSet
	my $ccs;
	my $current;
	eval {
		if ($key = $root_key->get_subkey("Select")) {
			$current = $key->get_value("Current")->get_data();
			$ccs = "ControlSet00".$current;
		}
	};
	
# If we've got a populated $ccs value, other checks will now likely work	
# Look for known/observed PlugX services
	my @services = ("RasTLS","Macfee MC","usta","emproxy","mproxysvr3","gzQkNtWeabrwf","brwTRsulGqj","sock5proxy");
	eval {
		foreach my $svc (@services) {
			if ($key = $root_key->get_subkey($ccs."\\services\\".$svc)) {
				::rptMsg("Possible PlugX variant found in ".$svc." service");
				
				eval {
					::rptMsg("  ImagePath  : ".$key->get_value("ImagePath")->get_data());
				};
				
				eval {
					::rptMsg("  Description: ".$key->get_value("Description")->get_data());
				};
				
			}
		}
	}; 
	

# Software Hive

# Check for several PlugX variants
# http://www.symantec.com/security_response/earthlink_writeup.jsp?docid=2013-112101-0135-99
	eval {
		$key_path = "Classes\\FAST";
		if ($key = $root_key->get_subkey($key_path)) {
			::rptMsg("Possible PlugX variant (".$key_path.") found.");
			::rptMsg("  LastWrite time: ".gmtime($key->get_timestamp()));
		}
	};
	
	eval {
		$key_path = "Classes\\XXXX";
		if ($key = $root_key->get_subkey($key_path)) {
			::rptMsg("Possible PlugX variant (".$key_path.") found.");
			::rptMsg("  LastWrite time: ".gmtime($key->get_timestamp()));
		}
	};
	
	
	eval {
		$key_path = "BINARY";
		if ($key = $root_key->get_subkey($key_path)) {
			::rptMsg("Possible PlugX variant (".$key_path.") found.");
			::rptMsg("  LastWrite time: ".gmtime($key->get_timestamp()));
			if ($key->get_value("SXLOC\.ZAP")) {
				::rptMsg("Value SXLOC\.ZAP found.");
			}
		}
	};

# check Classes\Network\SharingHandler default value for modification
# in most cases, it's "ntshrui.dll"
# http://www.trendmicro.com/vinfo/us/threat-encyclopedia/malware/worm_cosmu.elg
	eval { 
		$key_path = "Classes\\Network\\SharingHandler";
		if ($key = $root_key->get_subkey($key_path)) {
			::rptMsg($key_path);
			::rptMsg("  LastWrite Time : ".gmtime($key->get_timestamp())." (UTC)");
			::rptMsg("  (Default) value: ".$key->get_value("")->get_data());
			::rptMsg("If the (Default) value is not ntshrui\.dll, there may be an infection.");
		}
	};
	
# Poison Ivy variant
# http://blog.jpcert.or.jp/2015/07/poisonivy-adapts-to-communicate-through-authentication-proxies.html
	eval {
		$key_path = "Classes\\BJ\\Static";
		if ($key = $root_key->get_subkey($key_path)) {
			::rptMsg($key_path);
			::rptMsg("LastWrite Time ".gmtime($key->get_timestamp())." (UTC)");
			if ($key->get_value("MessageFile")) {
				::rptMsg("MessageFile value found.");
			}
			::rptMsg("");
		}
	};
	
	
# NTUSER.DAT/USRCLASS.DAT		

# Possible PlugX
# http://www.symantec.com/security_response/earthlink_writeup.jsp?docid=2013-112101-0135-99
	eval {
		$key_path = "Software\\BINARY";
		if ($key = $root_key->get_subkey($key_path)) {
			::rptMsg("Possible PlugX variant (".$key_path.") found.");
			::rptMsg("  LastWrite time: ".gmtime($key->get_timestamp()));
			if ($key->get_value("SXLOC\.ZAP")) {
				::rptMsg("Value SXLOC\.ZAP found.");
			}
		}
	};
	
	
}
1;