/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.JReferenceType;
import ch.epfl.lamp.fjbg.JType;

public class JObjectType
extends JReferenceType {
    protected final String name;
    protected String signature = null;
    public static final JObjectType JAVA_LANG_OBJECT = new JObjectType("java.lang.Object");
    public static final JObjectType JAVA_LANG_STRING = new JObjectType("java.lang.String");
    public static final JObjectType CLONEABLE = new JObjectType("Cloneable");
    public static final JObjectType JAVA_IO_SERIALIZABLE = new JObjectType("java.io.Serializable");

    public JObjectType(String name) {
        this.name = name;
    }

    @Override
    public int getSize() {
        return 1;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getSignature() {
        if (this.signature == null) {
            this.signature = "L" + this.name.replace('.', '/') + ";";
        }
        return this.signature;
    }

    @Override
    public String getDescriptor() {
        return this.name.replace('.', '/');
    }

    @Override
    public int getTag() {
        return 14;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public boolean isObjectType() {
        return true;
    }

    @Override
    public boolean isCompatibleWith(JType other) {
        return other instanceof JObjectType || other == JType.REFERENCE;
    }

    public boolean equals(Object o) {
        if (o instanceof JObjectType) {
            return ((JObjectType)o).getSignature().equals(this.getSignature());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

