/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.dungeon;

import akka.actor.ActorCell;
import akka.actor.ActorPath$;
import akka.actor.ActorRef;
import akka.actor.ChildNameReserved$;
import akka.actor.ChildRestartStats;
import akka.actor.ChildRestartStats$;
import akka.actor.ChildStats;
import akka.actor.Deploy;
import akka.actor.InternalActorRef;
import akka.actor.InvalidActorNameException;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.Props;
import akka.actor.RepointableRef;
import akka.actor.dungeon.AbstractActorCell;
import akka.actor.dungeon.ChildrenContainer;
import akka.actor.dungeon.ChildrenContainer$EmptyChildrenContainer$;
import akka.actor.dungeon.ChildrenContainer$TerminatedChildrenContainer$;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.util.Helpers$;
import akka.util.Unsafe;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.control.NonFatal$;

public abstract class Children$class {
    public static ChildrenContainer childrenRefs(ActorCell $this) {
        return (ChildrenContainer)Unsafe.instance.getObjectVolatile($this, AbstractActorCell.childrenOffset);
    }

    public static final Iterable children(ActorCell $this) {
        return $this.childrenRefs().children();
    }

    public static final java.lang.Iterable getChildren(ActorCell $this) {
        return (java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter($this.children()).asJava();
    }

    public static final Option child(ActorCell $this, String name) {
        return Option$.MODULE$.apply((Object)$this.getChild(name));
    }

    public static final ActorRef getChild(ActorCell $this, String name) {
        ActorRef actorRef;
        ChildStats s;
        Some x2;
        Option<ChildStats> option = $this.childrenRefs().getByName(name);
        if (option instanceof Some && (x2 = (Some)option) != null && (s = (ChildStats)x2.x()) instanceof ChildRestartStats) {
            ChildRestartStats x3 = (ChildRestartStats)s;
            actorRef = x3.child();
        } else {
            actorRef = null;
        }
        return actorRef;
    }

    public static ActorRef actorOf(ActorCell $this, Props props) {
        return Children$class.makeChild($this, $this, props, $this.randomName(), false, false);
    }

    public static ActorRef actorOf(ActorCell $this, Props props, String name) {
        return Children$class.makeChild($this, $this, props, Children$class.checkName($this, name), false, false);
    }

    public static ActorRef attachChild(ActorCell $this, Props props, boolean systemService) {
        return Children$class.makeChild($this, $this, props, $this.randomName(), true, systemService);
    }

    public static ActorRef attachChild(ActorCell $this, Props props, String name, boolean systemService) {
        return Children$class.makeChild($this, $this, props, Children$class.checkName($this, name), true, systemService);
    }

    public static final String randomName(ActorCell $this) {
        return Helpers$.MODULE$.base64(Children$class.inc$1($this), Helpers$.MODULE$.base64$default$2());
    }

    public static final void stop(ActorCell $this, ActorRef actor) {
        Object object;
        if ($this.childrenRefs().getByRef(actor).isDefined()) {
            boolean bl;
            ActorRef actorRef = actor;
            if (actorRef instanceof RepointableRef) {
                ActorRef x2 = actorRef;
                bl = ((RepointableRef)((Object)x2)).isStarted();
            } else {
                bl = true;
            }
            object = bl ? BoxesRunTime.boxToBoolean((boolean)Children$class.shallDie$1($this, actor)) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        ((InternalActorRef)actor).stop();
    }

    private static final boolean swapChildrenRefs(ActorCell $this, ChildrenContainer oldChildren, ChildrenContainer newChildren) {
        return Unsafe.instance.compareAndSwapObject($this, AbstractActorCell.childrenOffset, oldChildren, newChildren);
    }

    public static final boolean reserveChild(ActorCell $this, String name) {
        while (true) {
            ChildrenContainer c;
            if (!Children$class.swapChildrenRefs($this, c = $this.childrenRefs(), c.reserve(name))) continue;
            return true;
        }
    }

    public static final boolean unreserveChild(ActorCell $this, String name) {
        while (true) {
            ChildrenContainer c;
            if (!Children$class.swapChildrenRefs($this, c = $this.childrenRefs(), c.unreserve(name))) continue;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Option initChild(ActorCell $this, ActorRef ref) {
        Option<ChildStats> option;
        while (true) {
            ChildrenContainer cc = $this.childrenRefs();
            boolean rc10 = false;
            Some x3 = null;
            option = cc.getByName(ref.path().name());
            if (option instanceof Some) {
                ChildStats p2;
                rc10 = true;
                x3 = (Some)option;
                if (x3 != null && (p2 = (ChildStats)x3.x()) instanceof ChildRestartStats) {
                    ChildRestartStats x6 = (ChildRestartStats)p2;
                    return x3;
                }
            }
            if (!rc10 || x3 == null) break;
            ChildStats p4 = (ChildStats)x3.x();
            ChildNameReserved$ childNameReserved$ = ChildNameReserved$.MODULE$;
            ChildStats childStats = p4;
            if (childNameReserved$ != null ? !childNameReserved$.equals(childStats) : childStats != null) break;
            ChildStats x7 = p4;
            ChildRestartStats crs = new ChildRestartStats(ref, ChildRestartStats$.MODULE$.apply$default$2(), ChildRestartStats$.MODULE$.apply$default$3());
            String name = ref.path().name();
            if (!Children$class.swapChildrenRefs($this, cc, cc.add(name, crs))) continue;
            return new Some((Object)crs);
        }
        None$ none$ = None$.MODULE$;
        Option<ChildStats> option2 = option;
        if (none$ == null) {
            if (option2 != null) {
                throw new MatchError(option);
            }
        } else if (!none$.equals(option2)) throw new MatchError(option);
        Option<ChildStats> x8 = option;
        return None$.MODULE$;
    }

    public static final boolean setChildrenTerminationReason(ActorCell $this, ChildrenContainer.SuspendReason reason) {
        boolean bl;
        block1: {
            ChildrenContainer childrenContainer;
            while ((childrenContainer = $this.childrenRefs()) instanceof ChildrenContainer.TerminatingChildrenContainer) {
                Set<ActorRef> x$3;
                ChildrenContainer.TerminatingChildrenContainer x2 = (ChildrenContainer.TerminatingChildrenContainer)childrenContainer;
                ChildrenContainer.SuspendReason x$1 = reason;
                TreeMap<String, ChildStats> x$2 = x2.copy$default$1();
                if (!Children$class.swapChildrenRefs($this, x2, x2.copy(x$2, x$3 = x2.copy$default$2(), x$1))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final void setTerminated(ActorCell $this) {
        Unsafe.instance.putObjectVolatile($this, AbstractActorCell.childrenOffset, ChildrenContainer$TerminatedChildrenContainer$.MODULE$);
    }

    public static boolean isNormal(ActorCell $this) {
        return $this.childrenRefs().isNormal();
    }

    public static boolean isTerminating(ActorCell $this) {
        return $this.childrenRefs().isTerminating();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChildrenContainer.SuspendReason waitingForChildrenOrNull(ActorCell $this) {
        ChildrenContainer childrenContainer = $this.childrenRefs();
        if (!(childrenContainer instanceof ChildrenContainer.TerminatingChildrenContainer)) return null;
        ChildrenContainer.TerminatingChildrenContainer x4 = (ChildrenContainer.TerminatingChildrenContainer)childrenContainer;
        if (x4 == null) return null;
        TreeMap<String, ChildStats> p2 = x4.c();
        Set<ActorRef> p3 = x4.toDie();
        ChildrenContainer.SuspendReason w = x4.reason();
        if (!(w instanceof ChildrenContainer.WaitingForChildren)) return null;
        ChildrenContainer.SuspendReason x5 = w;
        return x5;
    }

    public static void suspendChildren(ActorCell $this, Set exceptFor) {
        $this.childrenRefs().stats().foreach((Function1)new Serializable($this, exceptFor){
            public static final long serialVersionUID = 0L;
            private final Set exceptFor$1;

            /*
             * Enabled aggressive block sorting
             */
            public final void apply(ChildRestartStats x0$1) {
                ChildRestartStats childRestartStats = x0$1;
                if (childRestartStats != null) {
                    ActorRef child = childRestartStats.child();
                    int p2 = childRestartStats.maxNrOfRetriesCount();
                    long p3 = childRestartStats.restartTimeWindowStartNanos();
                    if (!this.exceptFor$1.contains((Object)child)) {
                        ((InternalActorRef)child).suspend();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            {
                this.exceptFor$1 = exceptFor$1;
            }
        });
    }

    public static Set suspendChildren$default$1(ActorCell $this) {
        return Predef$.MODULE$.Set().empty();
    }

    public static void resumeChildren(ActorCell $this, Throwable causedByFailure, ActorRef perp) {
        $this.childrenRefs().stats().foreach((Function1)new Serializable($this, causedByFailure, perp){
            public static final long serialVersionUID = 0L;
            private final Throwable causedByFailure$1;
            private final ActorRef perp$1;

            public final void apply(ChildRestartStats x0$2) {
                ChildRestartStats childRestartStats = x0$2;
                if (childRestartStats != null) {
                    ActorRef child = childRestartStats.child();
                    int p2 = childRestartStats.maxNrOfRetriesCount();
                    long p3 = childRestartStats.restartTimeWindowStartNanos();
                    if (child instanceof InternalActorRef) {
                        InternalActorRef x4 = (InternalActorRef)child;
                        ActorRef actorRef = this.perp$1;
                        InternalActorRef internalActorRef = x4;
                        x4.resume(!(actorRef != null ? !((Object)actorRef).equals(internalActorRef) : internalActorRef != null) ? this.causedByFailure$1 : null);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                throw new MatchError((Object)childRestartStats);
            }
            {
                this.causedByFailure$1 = causedByFailure$1;
                this.perp$1 = perp$1;
            }
        });
    }

    public static Option getChildByName(ActorCell $this, String name) {
        return $this.childrenRefs().getByName(name);
    }

    public static Option getChildByRef(ActorCell $this, ActorRef ref) {
        return $this.childrenRefs().getByRef(ref);
    }

    public static Iterable getAllChildStats(ActorCell $this) {
        return $this.childrenRefs().stats();
    }

    public static Option removeChildAndGetStateChange(ActorCell $this, ActorRef child) {
        None$ none$;
        ChildrenContainer.TerminatingChildrenContainer x4;
        ChildrenContainer childrenContainer = $this.childrenRefs();
        if (childrenContainer instanceof ChildrenContainer.TerminatingChildrenContainer && (x4 = (ChildrenContainer.TerminatingChildrenContainer)childrenContainer) != null) {
            None$ none$2;
            TreeMap<String, ChildStats> p2 = x4.c();
            Set<ActorRef> p3 = x4.toDie();
            ChildrenContainer.SuspendReason reason = x4.reason();
            ChildrenContainer childrenContainer2 = Children$class.removeChild$1($this, child);
            if (childrenContainer2 instanceof ChildrenContainer.TerminatingChildrenContainer) {
                ChildrenContainer.TerminatingChildrenContainer x2 = (ChildrenContainer.TerminatingChildrenContainer)childrenContainer2;
                none$2 = None$.MODULE$;
            } else {
                none$2 = new Some((Object)reason);
            }
            none$ = none$2;
        } else {
            Children$class.removeChild$1($this, child);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private static String checkName(ActorCell $this, String name) {
        String string = name;
        if (string == null) {
            String x3 = string;
            throw new InvalidActorNameException("actor name must not be null");
        }
        String string2 = string;
        if (!("" != null ? !"".equals(string2) : string2 != null)) {
            String x4 = string;
            throw new InvalidActorNameException("actor name must not be empty");
        }
        Option o11 = ActorPath$.MODULE$.ElementRegex().unapplySeq((Object)string);
        if (!o11.isEmpty() && o11.get() != null && ((LinearSeqOptimized)o11.get()).lengthCompare(0) == 0) {
            String string3 = name;
            return string3;
        }
        throw new InvalidActorNameException(new StringBuilder().append((Object)"illegal actor name '").append((Object)name).append((Object)"', must conform to ").append((Object)ActorPath$.MODULE$.ElementRegex()).toString());
    }

    private static ActorRef makeChild(ActorCell $this, ActorCell cell, Props props, String name, boolean async2, boolean systemService) {
        InternalActorRef actor;
        block6: {
            Object object;
            if (cell.system().settings().SerializeAllCreators() && !(props.creator() instanceof NoSerializationVerificationNeeded)) {
                Serialization ser = (Serialization)SerializationExtension$.MODULE$.apply(cell.system());
                object = ser.deserialize((byte[])ser.serialize(props.creator()).get(), props.creator().getClass()).get();
            } else {
                object = BoxedUnit.UNIT;
            }
            if (cell.childrenRefs().isTerminating()) {
                throw new IllegalStateException("cannot create children while terminating or terminated");
            }
            $this.reserveChild(name);
            try {
                actor = cell.provider().actorOf(cell.systemImpl(), props, cell.self(), cell.self().path().$div(name), systemService, (Option<Deploy>)None$.MODULE$, true, async2);
                if ($this.mailbox() == null) break block6;
            }
            catch (Throwable throwable) {
                Throwable x4 = throwable;
                Option o11 = NonFatal$.MODULE$.unapply(x4);
                if (o11.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)o11.get();
                $this.unreserveChild(name);
                throw e;
            }
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.mailbox().suspendCount()).foreach$mVc$sp((Function1)new Serializable($this, actor){
                public static final long serialVersionUID = 0L;
                private final InternalActorRef actor$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int v1) {
                    this.actor$1.suspend();
                }
                {
                    this.actor$1 = actor$1;
                }
            });
        }
        $this.initChild(actor);
        actor.start();
        return actor;
    }

    private static final long inc$1(ActorCell $this) {
        while (true) {
            long current;
            if (!Unsafe.instance.compareAndSwapLong($this, AbstractActorCell.nextNameOffset, current = Unsafe.instance.getLongVolatile($this, AbstractActorCell.nextNameOffset), current + 1L)) continue;
            return current;
        }
    }

    private static final boolean shallDie$1(ActorCell $this, ActorRef ref) {
        while (true) {
            ChildrenContainer c;
            if (!Children$class.swapChildrenRefs($this, c = $this.childrenRefs(), c.shallDie(ref))) continue;
            return true;
        }
    }

    private static final ChildrenContainer removeChild$1(ActorCell $this, ActorRef ref) {
        while (true) {
            ChildrenContainer n;
            ChildrenContainer c;
            if (!Children$class.swapChildrenRefs($this, c = $this.childrenRefs(), n = c.remove(ref))) continue;
            return n;
        }
    }

    public static void $init$(ActorCell $this) {
        $this.akka$actor$dungeon$Children$$_childrenRefsDoNotCallMeDirectly_$eq(ChildrenContainer$EmptyChildrenContainer$.MODULE$);
        $this.akka$actor$dungeon$Children$$_nextNameDoNotCallMeDirectly_$eq(0L);
    }
}

