/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.threadpool;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import scala.actors.threadpool.BlockingQueue;
import scala.actors.threadpool.TimeUnit;

public class LinkedBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -6903933977591709194L;
    private final int capacity;
    private final AtomicInteger count = new AtomicInteger(0);
    private transient Node<E> head;
    private transient Node<E> last;
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();
    private final ReentrantLock putLock = new ReentrantLock();
    private final Condition notFull = this.putLock.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotEmpty() {
        ReentrantLock reentrantLock = this.takeLock;
        reentrantLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotFull() {
        ReentrantLock reentrantLock = this.putLock;
        reentrantLock.lock();
        try {
            this.notFull.signal();
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private void enqueue(E e) {
        this.last.next = new Node<E>(e);
        this.last = this.last.next;
    }

    private E dequeue() {
        Node<E> node = this.head;
        Node node2 = node.next;
        node.next = node;
        this.head = node2;
        Object e = node2.item;
        node2.item = null;
        return e;
    }

    void fullyLock() {
        this.putLock.lock();
        this.takeLock.lock();
    }

    void fullyUnlock() {
        this.takeLock.unlock();
        this.putLock.unlock();
    }

    public LinkedBlockingQueue() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingQueue(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = n;
        this.head = new Node<Object>(null);
        this.last = this.head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedBlockingQueue(Collection<? extends E> collection) {
        this(Integer.MAX_VALUE);
        ReentrantLock reentrantLock = this.putLock;
        reentrantLock.lock();
        try {
            int n = 0;
            for (E e : collection) {
                if (e == null) {
                    throw new NullPointerException();
                }
                if (n == this.capacity) {
                    throw new IllegalStateException("Queue full");
                }
                super.enqueue(e);
                ++n;
            }
            this.count.set(n);
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public int size() {
        return this.count.get();
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        int n = -1;
        ReentrantLock reentrantLock = this.putLock;
        AtomicInteger atomicInteger = this.count;
        reentrantLock.lockInterruptibly();
        try {
            while (atomicInteger.get() == this.capacity) {
                this.notFull.await();
            }
            this.enqueue(e);
            n = atomicInteger.getAndIncrement();
            if (n + 1 < this.capacity) {
                this.notFull.signal();
            }
        }
        finally {
            reentrantLock.unlock();
        }
        if (n == 0) {
            this.signalNotEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        long l2 = timeUnit.toNanos(l);
        int n = -1;
        ReentrantLock reentrantLock = this.putLock;
        AtomicInteger atomicInteger = this.count;
        reentrantLock.lockInterruptibly();
        try {
            while (atomicInteger.get() == this.capacity) {
                if (l2 <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                l2 = this.notFull.awaitNanos(l2);
            }
            this.enqueue(e);
            n = atomicInteger.getAndIncrement();
            if (n + 1 < this.capacity) {
                this.notFull.signal();
            }
        }
        finally {
            reentrantLock.unlock();
        }
        if (n == 0) {
            this.signalNotEmpty();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        AtomicInteger atomicInteger = this.count;
        if (atomicInteger.get() == this.capacity) {
            return false;
        }
        int n = -1;
        ReentrantLock reentrantLock = this.putLock;
        reentrantLock.lock();
        try {
            if (atomicInteger.get() < this.capacity) {
                this.enqueue(e);
                n = atomicInteger.getAndIncrement();
                if (n + 1 < this.capacity) {
                    this.notFull.signal();
                }
            }
        }
        finally {
            reentrantLock.unlock();
        }
        if (n == 0) {
            this.signalNotEmpty();
        }
        return n >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        E e;
        int n = -1;
        AtomicInteger atomicInteger = this.count;
        ReentrantLock reentrantLock = this.takeLock;
        reentrantLock.lockInterruptibly();
        try {
            while (atomicInteger.get() == 0) {
                this.notEmpty.await();
            }
            e = this.dequeue();
            n = atomicInteger.getAndDecrement();
            if (n > 1) {
                this.notEmpty.signal();
            }
        }
        finally {
            reentrantLock.unlock();
        }
        if (n == this.capacity) {
            this.signalNotFull();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        E e = null;
        int n = -1;
        long l2 = timeUnit.toNanos(l);
        AtomicInteger atomicInteger = this.count;
        ReentrantLock reentrantLock = this.takeLock;
        reentrantLock.lockInterruptibly();
        try {
            while (atomicInteger.get() == 0) {
                if (l2 <= 0L) {
                    E e2 = null;
                    return e2;
                }
                l2 = this.notEmpty.awaitNanos(l2);
            }
            e = this.dequeue();
            n = atomicInteger.getAndDecrement();
            if (n > 1) {
                this.notEmpty.signal();
            }
        }
        finally {
            reentrantLock.unlock();
        }
        if (n == this.capacity) {
            this.signalNotFull();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        AtomicInteger atomicInteger = this.count;
        if (atomicInteger.get() == 0) {
            return null;
        }
        E e = null;
        int n = -1;
        ReentrantLock reentrantLock = this.takeLock;
        reentrantLock.lock();
        try {
            if (atomicInteger.get() > 0) {
                e = this.dequeue();
                n = atomicInteger.getAndDecrement();
                if (n > 1) {
                    this.notEmpty.signal();
                }
            }
        }
        finally {
            reentrantLock.unlock();
        }
        if (n == this.capacity) {
            this.signalNotFull();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        if (this.count.get() == 0) {
            return null;
        }
        ReentrantLock reentrantLock = this.takeLock;
        reentrantLock.lock();
        try {
            Node node = this.head.next;
            if (node == null) {
                E e = null;
                return e;
            }
            Object e = node.item;
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    void unlink(Node<E> node, Node<E> node2) {
        node.item = null;
        node2.next = node.next;
        if (this.last == node) {
            this.last = node2;
        }
        if (this.count.getAndDecrement() == this.capacity) {
            this.notFull.signal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        this.fullyLock();
        try {
            Node<E> node = this.head;
            Node node2 = node.next;
            while (node2 != null) {
                if (object.equals(node2.item)) {
                    this.unlink(node2, node);
                    boolean bl = true;
                    return bl;
                }
                node = node2;
                node2 = node2.next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.fullyUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.fullyLock();
        try {
            int n = this.count.get();
            Object[] objectArray = new Object[n];
            int n2 = 0;
            Object object = this.head.next;
            while (object != null) {
                objectArray[n2++] = object.item;
                object = object.next;
            }
            object = objectArray;
            return object;
        }
        finally {
            this.fullyUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] objectArray) {
        this.fullyLock();
        try {
            int n = this.count.get();
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            }
            int n2 = 0;
            Object object = this.head.next;
            while (object != null) {
                objectArray[n2++] = object.item;
                object = object.next;
            }
            if (objectArray.length > n2) {
                objectArray[n2] = null;
            }
            object = objectArray;
            return object;
        }
        finally {
            this.fullyUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        this.fullyLock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.fullyUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.fullyLock();
        try {
            Node node;
            Node<E> node2 = this.head;
            while ((node = node2.next) != null) {
                node2.next = node2;
                node.item = null;
                node2 = node;
            }
            this.head = this.last;
            if (this.count.getAndSet(0) == this.capacity) {
                this.notFull.signal();
            }
        }
        finally {
            this.fullyUnlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        ReentrantLock reentrantLock = this.takeLock;
        reentrantLock.lock();
        try {
            int n2;
            block11: {
                int n3;
                int n4 = Math.min(n, this.count.get());
                Node<E> node = this.head;
                try {
                    for (n3 = 0; n3 < n4; ++n3) {
                        Node node2 = node.next;
                        collection.add(node2.item);
                        node2.item = null;
                        node.next = node;
                        node = node2;
                    }
                    n2 = n4;
                    if (n3 <= 0) break block11;
                    this.head = node;
                    bl = this.count.getAndAdd(-n3) == this.capacity;
                }
                catch (Throwable throwable) {
                    if (n3 > 0) {
                        this.head = node;
                        bl = this.count.getAndAdd(-n3) == this.capacity;
                    }
                    throw throwable;
                }
            }
            return n2;
        }
        finally {
            reentrantLock.unlock();
            if (bl) {
                this.signalNotFull();
            }
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.fullyLock();
        try {
            objectOutputStream.defaultWriteObject();
            Node node = this.head.next;
            while (node != null) {
                objectOutputStream.writeObject(node.item);
                node = node.next;
            }
            objectOutputStream.writeObject(null);
        }
        finally {
            this.fullyUnlock();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.count.set(0);
        this.head = new Node<Object>(null);
        this.last = this.head;
        while ((object = objectInputStream.readObject()) != null) {
            this.add(object);
        }
    }

    private class Itr
    implements Iterator<E> {
        private Node<E> current;
        private Node<E> lastRet;
        private E currentElement;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Itr() {
            LinkedBlockingQueue.this.fullyLock();
            try {
                this.current = ((LinkedBlockingQueue)LinkedBlockingQueue.this).head.next;
                if (this.current != null) {
                    this.currentElement = this.current.item;
                }
            }
            finally {
                LinkedBlockingQueue.this.fullyUnlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        private Node<E> nextNode(Node<E> node) {
            Node node2;
            while ((node2 = node.next) != node) {
                if (node2 == null || node2.item != null) {
                    return node2;
                }
                node = node2;
            }
            return ((LinkedBlockingQueue)LinkedBlockingQueue.this).head.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            LinkedBlockingQueue.this.fullyLock();
            try {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                Object e = this.currentElement;
                this.lastRet = this.current;
                this.current = this.nextNode(this.current);
                this.currentElement = this.current == null ? null : this.current.item;
                Object e2 = e;
                return e2;
            }
            finally {
                LinkedBlockingQueue.this.fullyUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            LinkedBlockingQueue.this.fullyLock();
            try {
                Node node = this.lastRet;
                this.lastRet = null;
                Node node2 = LinkedBlockingQueue.this.head;
                Node node3 = node2.next;
                while (node3 != null) {
                    if (node3 == node) {
                        LinkedBlockingQueue.this.unlink(node3, node2);
                        break;
                    }
                    node2 = node3;
                    node3 = node3.next;
                }
            }
            finally {
                LinkedBlockingQueue.this.fullyUnlock();
            }
        }
    }

    static class Node<E> {
        E item;
        Node<E> next;

        Node(E e) {
            this.item = e;
        }
    }
}

