/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_font_extents_t;
import org.eclipse.swt.internal.cairo.cairo_text_extents_t;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkGCValues;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.internal.gtk.XRenderPictureAttributes;

public final class GC
extends Resource {
    public long handle;
    Drawable drawable;
    GCData data;
    static final int[] LINE_DOT = new int[]{1, 1};
    static final int[] LINE_DASH = new int[]{3, 1};
    static final int[] LINE_DASHDOT = new int[]{3, 1, 1, 1};
    static final int[] LINE_DASHDOTDOT = new int[]{3, 1, 1, 1, 1, 1};
    static final int[] LINE_DOT_ZERO = new int[]{3, 3};
    static final int[] LINE_DASH_ZERO = new int[]{18, 6};
    static final int[] LINE_DASHDOT_ZERO = new int[]{9, 6, 3, 6};
    static final int[] LINE_DASHDOTDOT_ZERO = new int[]{9, 3, 3, 3, 3, 3};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData data = new GCData();
        data.style = GC.checkStyle(style);
        long gdkGC = drawable.internal_new_GC(data);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = data.device = device;
        this.init(drawable, data, gdkGC);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    static void addCairoString(long cairo, String string, float x, float y, Font font) {
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        if (OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
            long layout = OS.pango_cairo_create_layout(cairo);
            if (layout == 0L) {
                SWT.error(2);
            }
            OS.pango_layout_set_text(layout, buffer, -1);
            OS.pango_layout_set_font_description(layout, font.handle);
            Cairo.cairo_move_to(cairo, x, y);
            OS.pango_cairo_layout_path(cairo, layout);
            OS.g_object_unref(layout);
        } else {
            GC.setCairoFont(cairo, font);
            cairo_font_extents_t extents = new cairo_font_extents_t();
            Cairo.cairo_font_extents(cairo, extents);
            double baseline = (double)y + extents.ascent;
            Cairo.cairo_move_to(cairo, x, baseline);
            Cairo.cairo_text_path(cairo, buffer);
        }
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    public static GC gtk_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        long gdkGC = drawable.internal_new_GC(data);
        gc.device = data.device;
        gc.init(drawable, data, gdkGC);
        return gc;
    }

    public void copyArea(Image image, int x, int y) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rect = image.getBounds();
        long gdkGC = OS.gdk_gc_new(image.pixmap);
        if (gdkGC == 0L) {
            SWT.error(2);
        }
        OS.gdk_gc_set_subwindow(gdkGC, 1L);
        OS.gdk_draw_drawable(image.pixmap, gdkGC, this.data.drawable, x, y, 0, 0, rect.width, rect.height);
        OS.g_object_unref(gdkGC);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY) {
        this.copyArea(srcX, srcY, width, height, destX, destY, true);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY, boolean paint) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - srcX;
        int deltaY = destY - srcY;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        long drawable = this.data.drawable;
        if (this.data.image == null && paint) {
            OS.gdk_gc_set_exposures(this.handle, true);
        }
        OS.gdk_draw_drawable(drawable, this.handle, drawable, srcX, srcY, destX, destY, width, height);
        if (this.data.image == null & paint) {
            OS.gdk_gc_set_exposures(this.handle, false);
            boolean disjoint = destX + width < srcX || srcX + width < destX || destY + height < srcY || srcY + height < destY;
            GdkRectangle rect = new GdkRectangle();
            if (disjoint) {
                rect.x = srcX;
                rect.y = srcY;
                rect.width = width;
                rect.height = height;
                OS.gdk_window_invalidate_rect(drawable, rect, false);
            } else {
                if (deltaX != 0) {
                    int newX = destX - deltaX;
                    if (deltaX < 0) {
                        newX = destX + width;
                    }
                    rect.x = newX;
                    rect.y = srcY;
                    rect.width = Math.abs(deltaX);
                    rect.height = height;
                    OS.gdk_window_invalidate_rect(drawable, rect, false);
                }
                if (deltaY != 0) {
                    int newY = destY - deltaY;
                    if (deltaY < 0) {
                        newY = destY + height;
                    }
                    rect.x = srcX;
                    rect.y = newY;
                    rect.width = width;
                    rect.height = Math.abs(deltaY);
                    OS.gdk_window_invalidate_rect(drawable, rect, false);
                }
            }
        }
    }

    void createLayout() {
        long font;
        long context = OS.gdk_pango_context_get();
        if (context == 0L) {
            SWT.error(2);
        }
        this.data.context = context;
        long layout = OS.pango_layout_new(context);
        if (layout == 0L) {
            SWT.error(2);
        }
        this.data.layout = layout;
        OS.pango_context_set_language(context, OS.gtk_get_default_language());
        OS.pango_context_set_base_dir(context, 0);
        OS.gdk_pango_context_set_colormap(context, OS.gdk_colormap_get_system());
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.pango_layout_set_auto_dir(layout, false);
        }
        if ((font = this.data.font) != 0L) {
            OS.pango_layout_set_font_description(layout, font);
        }
    }

    void disposeLayout() {
        this.data.string = null;
        if (this.data.context != 0L) {
            OS.g_object_unref(this.data.context);
        }
        if (this.data.layout != 0L) {
            OS.g_object_unref(this.data.layout);
        }
        this.data.context = 0L;
        this.data.layout = 0L;
    }

    public void dispose() {
        Image image;
        if (this.handle == 0L) {
            return;
        }
        if (this.data.device.isDisposed()) {
            return;
        }
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            Cairo.cairo_destroy(cairo);
        }
        this.data.cairo = 0L;
        long clipRgn = this.data.clipRgn;
        if (clipRgn != 0L) {
            OS.gdk_region_destroy(clipRgn);
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
            if (image.transparentPixel != -1) {
                image.createMask();
            }
        }
        this.disposeLayout();
        Device device = this.data.device;
        this.drawable.internal_dispose_GC(this.handle, this.data);
        this.data.clipRgn = 0L;
        this.data.drawable = 0L;
        this.drawable = null;
        this.handle = 0L;
        this.data.image = null;
        this.data.string = null;
        if (device.tracking) {
            device.dispose_Object(this);
        }
        this.data.device = null;
        this.data = null;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            float offset;
            float f = offset = this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
            if (width == height) {
                if (arcAngle >= 0) {
                    Cairo.cairo_arc_negative(cairo, (float)x + offset + (float)width / 2.0f, (float)y + offset + (float)height / 2.0f, (float)width / 2.0f, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(cairo, (float)x + offset + (float)width / 2.0f, (float)y + offset + (float)height / 2.0f, (float)width / 2.0f, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                }
            } else {
                Cairo.cairo_save(cairo);
                Cairo.cairo_translate(cairo, (float)x + offset + (float)width / 2.0f, (float)y + offset + (float)height / 2.0f);
                Cairo.cairo_scale(cairo, (float)width / 2.0f, (float)height / 2.0f);
                if (arcAngle >= 0) {
                    Cairo.cairo_arc_negative(cairo, 0.0, 0.0, 1.0, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(cairo, 0.0, 0.0, 1.0, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                }
                Cairo.cairo_restore(cairo);
            }
            Cairo.cairo_stroke(cairo);
            return;
        }
        OS.gdk_draw_arc(this.data.drawable, this.handle, 0, x, y, width, height, startAngle * 64, arcAngle * 64);
    }

    public void drawFocus(int x, int y, int width, int height) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        long style = OS.gtk_widget_get_style(this.data.device.shellHandle);
        OS.gtk_paint_focus(style, this.data.drawable, 0, null, this.data.device.shellHandle, new byte[1], x, y, width, height);
    }

    public void drawImage(Image image, int x, int y) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        int[] width = new int[1];
        int[] height = new int[1];
        OS.gdk_drawable_get_size(srcImage.pixmap, width, height);
        int imgWidth = width[0];
        int imgHeight = height[0];
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            boolean bl = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
        }
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            if (this.data.alpha != 0) {
                srcImage.createSurface();
                Cairo.cairo_save(cairo);
                Cairo.cairo_rectangle(cairo, (double)destX + 0.5, (double)destY + 0.5, destWidth, destHeight);
                Cairo.cairo_clip(cairo);
                Cairo.cairo_translate(cairo, (double)(destX - srcX) + 0.5, (double)(destY - srcY) + 0.5);
                if (srcWidth != destWidth || srcHeight != destHeight) {
                    Cairo.cairo_scale(cairo, (float)destWidth / (float)srcWidth, (float)destHeight / (float)srcHeight);
                }
                int filter = 1;
                switch (this.data.interpolation) {
                    case -1: {
                        filter = 1;
                        break;
                    }
                    case 0: {
                        filter = 3;
                        break;
                    }
                    case 1: {
                        filter = 0;
                        break;
                    }
                    case 2: {
                        filter = 2;
                    }
                }
                long pattern = Cairo.cairo_pattern_create_for_surface(srcImage.surface);
                if (pattern == 0L) {
                    SWT.error(2);
                }
                Cairo.cairo_pattern_set_filter(pattern, filter);
                Cairo.cairo_pattern_set_extend(pattern, 2);
                Cairo.cairo_set_source(cairo, pattern);
                if (this.data.alpha != 255) {
                    Cairo.cairo_paint_with_alpha(cairo, (float)this.data.alpha / 255.0f);
                } else {
                    Cairo.cairo_paint(cairo);
                }
                Cairo.cairo_restore(cairo);
                Cairo.cairo_pattern_destroy(pattern);
            }
            return;
        }
        if (srcImage.alpha != -1 || srcImage.alphaData != null) {
            this.drawImageAlpha(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
        } else if (srcImage.transparentPixel != -1 || srcImage.mask != 0L) {
            this.drawImageMask(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
        } else {
            this.drawImage(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
        }
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight) {
        if (srcWidth == destWidth && srcHeight == destHeight) {
            OS.gdk_draw_drawable(this.data.drawable, this.handle, srcImage.pixmap, srcX, srcY, destX, destY, destWidth, destHeight);
        } else {
            if (this.device.useXRender) {
                this.drawImageXRender(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight, 0L, -1);
                return;
            }
            long pixbuf = this.scale(srcImage.pixmap, srcX, srcY, srcWidth, srcHeight, destWidth, destHeight);
            if (pixbuf != 0L) {
                OS.gdk_pixbuf_render_to_drawable(pixbuf, this.data.drawable, this.handle, 0, 0, destX, destY, destWidth, destHeight, 1, 0, 0);
                OS.g_object_unref(pixbuf);
            }
        }
    }

    void drawImageAlpha(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight) {
        if (srcImage.alpha == 0) {
            return;
        }
        if (srcImage.alpha == 255) {
            this.drawImage(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
            return;
        }
        if (this.device.useXRender) {
            this.drawImageXRender(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight, srcImage.mask, 2);
            return;
        }
        long pixbuf = OS.gdk_pixbuf_new(0, true, 8, srcWidth, srcHeight);
        if (pixbuf == 0L) {
            return;
        }
        long colormap = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(pixbuf, srcImage.pixmap, colormap, srcX, srcY, 0, 0, srcWidth, srcHeight);
        int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
        long pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
        byte[] line = new byte[stride];
        byte alpha = (byte)srcImage.alpha;
        byte[] alphaData = srcImage.alphaData;
        int y = 0;
        while (y < srcHeight) {
            int alphaIndex = (y + srcY) * imgWidth + srcX;
            OS.memmove(line, pixels + (long)(y * stride), (long)stride);
            int x = 3;
            while (x < stride) {
                line[x] = alphaData == null ? alpha : alphaData[alphaIndex++];
                x += 4;
            }
            OS.memmove(pixels + (long)(y * stride), line, (long)stride);
            ++y;
        }
        if (srcWidth != destWidth || srcHeight != destHeight) {
            long scaledPixbuf = OS.gdk_pixbuf_scale_simple(pixbuf, destWidth, destHeight, 2);
            OS.g_object_unref(pixbuf);
            if (scaledPixbuf == 0L) {
                return;
            }
            pixbuf = scaledPixbuf;
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 2, 0)) {
            OS.gdk_draw_pixbuf(this.data.drawable, this.handle, pixbuf, 0, 0, destX, destY, destWidth, destHeight, 1, 0, 0);
        } else {
            OS.gdk_pixbuf_render_to_drawable_alpha(pixbuf, this.data.drawable, 0, 0, destX, destY, destWidth, destHeight, 0, 128, 1, 0, 0);
        }
        OS.g_object_unref(pixbuf);
    }

    void drawImageMask(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight) {
        long drawable = this.data.drawable;
        long colorPixmap = srcImage.pixmap;
        if (srcImage.transparentPixel != -1) {
            srcImage.createMask();
        }
        long maskPixmap = srcImage.mask;
        if (this.device.useXRender) {
            this.drawImageXRender(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight, maskPixmap, 4);
        } else {
            int newHeight;
            int newWidth;
            int bytesPerLine;
            byte[] maskData;
            long mask;
            if (srcWidth != destWidth || srcHeight != destHeight) {
                long pixbuf = OS.gdk_pixbuf_new(0, true, 8, srcWidth, srcHeight);
                if (pixbuf != 0L) {
                    long colormap = OS.gdk_colormap_get_system();
                    OS.gdk_pixbuf_get_from_drawable(pixbuf, colorPixmap, colormap, srcX, srcY, 0, 0, srcWidth, srcHeight);
                    long maskPixbuf = OS.gdk_pixbuf_new(0, false, 8, srcWidth, srcHeight);
                    if (maskPixbuf != 0L) {
                        OS.gdk_pixbuf_get_from_drawable(maskPixbuf, maskPixmap, 0L, srcX, srcY, 0, 0, srcWidth, srcHeight);
                        int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
                        long pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
                        byte[] line = new byte[stride];
                        int maskStride = OS.gdk_pixbuf_get_rowstride(maskPixbuf);
                        long maskPixels = OS.gdk_pixbuf_get_pixels(maskPixbuf);
                        byte[] maskLine = new byte[maskStride];
                        int y = 0;
                        while (y < srcHeight) {
                            long offset = pixels + (long)(y * stride);
                            OS.memmove(line, offset, (long)stride);
                            long maskOffset = maskPixels + (long)(y * maskStride);
                            OS.memmove(maskLine, maskOffset, (long)maskStride);
                            int x = 0;
                            while (x < srcWidth) {
                                if (maskLine[x * 3] == 0) {
                                    line[x * 4 + 3] = 0;
                                }
                                ++x;
                            }
                            OS.memmove(offset, line, (long)stride);
                            ++y;
                        }
                        OS.g_object_unref(maskPixbuf);
                        long scaledPixbuf = OS.gdk_pixbuf_scale_simple(pixbuf, destWidth, destHeight, 2);
                        if (scaledPixbuf != 0L) {
                            long[] colorBuffer = new long[1];
                            long[] maskBuffer = new long[1];
                            OS.gdk_pixbuf_render_pixmap_and_mask(scaledPixbuf, colorBuffer, maskBuffer, 128);
                            colorPixmap = colorBuffer[0];
                            maskPixmap = maskBuffer[0];
                            OS.g_object_unref(scaledPixbuf);
                        }
                    }
                    OS.g_object_unref(pixbuf);
                }
                srcX = 0;
                srcY = 0;
                srcWidth = destWidth;
                srcHeight = destHeight;
            }
            if (this.data.clipRgn != 0L && (mask = OS.gdk_bitmap_create_from_data(0L, maskData = new byte[(bytesPerLine = ((newWidth = srcX + srcWidth) + 7) / 8) * (newHeight = srcY + srcHeight)], newWidth, newHeight)) != 0L) {
                long gc = OS.gdk_gc_new(mask);
                OS.gdk_region_offset(this.data.clipRgn, -destX + srcX, -destY + srcY);
                OS.gdk_gc_set_clip_region(gc, this.data.clipRgn);
                OS.gdk_region_offset(this.data.clipRgn, destX - srcX, destY - srcY);
                GdkColor color = new GdkColor();
                color.pixel = 1;
                OS.gdk_gc_set_foreground(gc, color);
                OS.gdk_draw_rectangle(mask, gc, 1, 0, 0, newWidth, newHeight);
                OS.gdk_gc_set_function(gc, 4L);
                OS.gdk_draw_drawable(mask, gc, maskPixmap, 0, 0, 0, 0, newWidth, newHeight);
                OS.g_object_unref(gc);
                if (maskPixmap != 0L && srcImage.mask != maskPixmap) {
                    OS.g_object_unref(maskPixmap);
                }
                maskPixmap = mask;
            }
            GdkGCValues values = new GdkGCValues();
            OS.gdk_gc_get_values(this.handle, values);
            OS.gdk_gc_set_clip_mask(this.handle, maskPixmap);
            OS.gdk_gc_set_clip_origin(this.handle, destX - srcX, destY - srcY);
            OS.gdk_draw_drawable(drawable, this.handle, colorPixmap, srcX, srcY, destX, destY, srcWidth, srcHeight);
            OS.gdk_gc_set_values(this.handle, values, 6272);
            if (this.data.clipRgn != 0L) {
                OS.gdk_gc_set_clip_region(this.handle, this.data.clipRgn);
            }
        }
        if (colorPixmap != 0L && srcImage.pixmap != colorPixmap) {
            OS.g_object_unref(colorPixmap);
        }
        if (maskPixmap != 0L && srcImage.mask != maskPixmap) {
            OS.g_object_unref(maskPixmap);
        }
        if (srcImage.transparentPixel != -1 && srcImage.memGC != null) {
            srcImage.destroyMask();
        }
    }

    void drawImageXRender(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight, long maskPixmap, int maskType) {
        long srcPict;
        int translateX = 0;
        int translateY = 0;
        long drawable = this.data.drawable;
        if (this.data.image == null) {
            int[] x = new int[1];
            int[] y = new int[1];
            long[] real_drawable = new long[1];
            OS.gdk_window_get_internal_paint_info(drawable, real_drawable, x, y);
            drawable = real_drawable[0];
            translateX = -x[0];
            translateY = -y[0];
        }
        long xDisplay = OS.GDK_DISPLAY();
        long maskPict = 0L;
        if (maskPixmap != 0L) {
            int attribCount = 0;
            XRenderPictureAttributes attrib = null;
            if (srcImage.alpha != -1) {
                attribCount = 1;
                attrib = new XRenderPictureAttributes();
                attrib.repeat = true;
            }
            if ((maskPict = OS.XRenderCreatePicture(xDisplay, OS.gdk_x11_drawable_get_xid(maskPixmap), OS.XRenderFindStandardFormat(xDisplay, maskType), attribCount, attrib)) == 0L) {
                SWT.error(2);
            }
        }
        long format = OS.XRenderFindVisualFormat(xDisplay, OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system()));
        long destPict = OS.XRenderCreatePicture(xDisplay, OS.gdk_x11_drawable_get_xid(drawable), format, 0L, null);
        if (destPict == 0L) {
            SWT.error(2);
        }
        if ((srcPict = OS.XRenderCreatePicture(xDisplay, OS.gdk_x11_drawable_get_xid(srcImage.pixmap), format, 0L, null)) == 0L) {
            SWT.error(2);
        }
        if (srcWidth != destWidth || srcHeight != destHeight) {
            int[] nArray = new int[9];
            nArray[0] = (int)((float)srcWidth / (float)destWidth * 65536.0f);
            nArray[4] = (int)((float)srcHeight / (float)destHeight * 65536.0f);
            nArray[8] = 65536;
            int[] transform = nArray;
            OS.XRenderSetPictureTransform(xDisplay, srcPict, transform);
            if (maskPict != 0L) {
                OS.XRenderSetPictureTransform(xDisplay, maskPict, transform);
            }
            srcX = (int)((float)srcX * ((float)destWidth / (float)srcWidth));
            srcY = (int)((float)srcY * ((float)destHeight / (float)srcHeight));
        }
        long clipping = this.data.clipRgn;
        if (this.data.damageRgn != 0L) {
            if (clipping == 0L) {
                clipping = this.data.damageRgn;
            } else {
                clipping = OS.gdk_region_new();
                OS.gdk_region_union(clipping, this.data.clipRgn);
                OS.gdk_region_intersect(clipping, this.data.damageRgn);
            }
        }
        if (clipping != 0L) {
            int[] nRects = new int[1];
            long[] rects = new long[1];
            OS.gdk_region_get_rectangles(clipping, rects, nRects);
            GdkRectangle rect = new GdkRectangle();
            short[] xRects = new short[nRects[0] * 4];
            int i = 0;
            int j = 0;
            while (i < nRects[0]) {
                OS.memmove(rect, rects[0] + (long)(i * GdkRectangle.sizeof), (long)GdkRectangle.sizeof);
                xRects[j] = (short)rect.x;
                xRects[j + 1] = (short)rect.y;
                xRects[j + 2] = (short)rect.width;
                xRects[j + 3] = (short)rect.height;
                ++i;
                j += 4;
            }
            OS.XRenderSetPictureClipRectangles(xDisplay, destPict, translateX, translateY, xRects, nRects[0]);
            if (clipping != this.data.clipRgn && clipping != this.data.damageRgn) {
                OS.gdk_region_destroy(clipping);
            }
            if (rects[0] != 0L) {
                OS.g_free(rects[0]);
            }
        }
        OS.XRenderComposite(xDisplay, maskPict != 0L ? 3 : 1, srcPict, maskPict, destPict, srcX, srcY, srcX, srcY, destX + translateX, destY + translateY, destWidth, destHeight);
        OS.XRenderFreePicture(xDisplay, destPict);
        OS.XRenderFreePicture(xDisplay, srcPict);
        if (maskPict != 0L) {
            OS.XRenderFreePicture(xDisplay, maskPict);
        }
    }

    long scale(long src, int srcX, int srcY, int srcWidth, int srcHeight, int destWidth, int destHeight) {
        long pixbuf = OS.gdk_pixbuf_new(0, false, 8, srcWidth, srcHeight);
        if (pixbuf == 0L) {
            return 0L;
        }
        long colormap = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(pixbuf, src, colormap, srcX, srcY, 0, 0, srcWidth, srcHeight);
        long scaledPixbuf = OS.gdk_pixbuf_scale_simple(pixbuf, destWidth, destHeight, 2);
        OS.g_object_unref(pixbuf);
        return scaledPixbuf;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        long cairo;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if ((cairo = this.data.cairo) != 0L) {
            float offset = this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
            Cairo.cairo_move_to(cairo, (float)x1 + offset, (float)y1 + offset);
            Cairo.cairo_line_to(cairo, (float)x2 + offset, (float)y2 + offset);
            Cairo.cairo_stroke(cairo);
            return;
        }
        OS.gdk_draw_line(this.data.drawable, this.handle, x1, y1, x2, y2);
    }

    public void drawOval(int x, int y, int width, int height) {
        long cairo;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if ((cairo = this.data.cairo) != 0L) {
            float offset;
            float f = offset = this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
            if (width == height) {
                Cairo.cairo_arc_negative(cairo, (float)x + offset + (float)width / 2.0f, (float)y + offset + (float)height / 2.0f, (float)width / 2.0f, 0.0, -2.0f * (float)Compatibility.PI);
            } else {
                Cairo.cairo_save(cairo);
                Cairo.cairo_translate(cairo, (float)x + offset + (float)width / 2.0f, (float)y + offset + (float)height / 2.0f);
                Cairo.cairo_scale(cairo, (float)width / 2.0f, (float)height / 2.0f);
                Cairo.cairo_arc_negative(cairo, 0.0, 0.0, 1.0, 0.0, -2.0f * (float)Compatibility.PI);
                Cairo.cairo_restore(cairo);
            }
            Cairo.cairo_stroke(cairo);
            return;
        }
        OS.gdk_draw_arc(this.data.drawable, this.handle, 0, x, y, width, height, 0, 23040);
    }

    public void drawPath(Path path) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0L) {
            SWT.error(5);
        }
        this.initCairo();
        long cairo = this.data.cairo;
        Cairo.cairo_save(cairo);
        float offset = this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
        Cairo.cairo_translate(cairo, offset, offset);
        long copy = Cairo.cairo_copy_path(path.handle);
        if (copy == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(cairo, copy);
        Cairo.cairo_path_destroy(copy);
        Cairo.cairo_stroke(cairo);
        Cairo.cairo_restore(cairo);
    }

    public void drawPoint(int x, int y) {
        long cairo;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if ((cairo = this.data.cairo) != 0L) {
            Cairo.cairo_rectangle(cairo, x, y, 1.0, 1.0);
            Cairo.cairo_fill(cairo);
            return;
        }
        OS.gdk_draw_point(this.data.drawable, this.handle, x, y);
    }

    public void drawPolygon(int[] pointArray) {
        long cairo;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if ((cairo = this.data.cairo) != 0L) {
            this.drawPolyline(cairo, pointArray, true);
            Cairo.cairo_stroke(cairo);
            return;
        }
        OS.gdk_draw_polygon(this.data.drawable, this.handle, 0, pointArray, pointArray.length / 2);
    }

    public void drawPolyline(int[] pointArray) {
        long cairo;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if ((cairo = this.data.cairo) != 0L) {
            this.drawPolyline(cairo, pointArray, false);
            Cairo.cairo_stroke(cairo);
            return;
        }
        OS.gdk_draw_lines(this.data.drawable, this.handle, pointArray, pointArray.length / 2);
    }

    void drawPolyline(long cairo, int[] pointArray, boolean close) {
        int count = pointArray.length / 2;
        if (count == 0) {
            return;
        }
        float offset = this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
        Cairo.cairo_move_to(cairo, (float)pointArray[0] + offset, (float)pointArray[1] + offset);
        int i = 1;
        int j = 2;
        while (i < count) {
            Cairo.cairo_line_to(cairo, (float)pointArray[j] + offset, (float)pointArray[j + 1] + offset);
            ++i;
            j += 2;
        }
        if (close) {
            Cairo.cairo_close_path(cairo);
        }
    }

    public void drawRectangle(int x, int y, int width, int height) {
        long cairo;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if ((cairo = this.data.cairo) != 0L) {
            float offset = this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
            Cairo.cairo_rectangle(cairo, (float)x + offset, (float)y + offset, width, height);
            Cairo.cairo_stroke(cairo);
            return;
        }
        OS.gdk_draw_rectangle(this.data.drawable, this.handle, 0, x, y, width, height);
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        long cairo;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        if ((cairo = this.data.cairo) != 0L) {
            float naw2 = (float)naw / 2.0f;
            float nah2 = (float)nah / 2.0f;
            float fw = (float)nw / naw2;
            float fh = (float)nh / nah2;
            Cairo.cairo_save(cairo);
            float offset = this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
            Cairo.cairo_translate(cairo, (float)nx + offset, (float)ny + offset);
            Cairo.cairo_scale(cairo, naw2, nah2);
            Cairo.cairo_move_to(cairo, fw - 1.0f, 0.0);
            Cairo.cairo_arc(cairo, fw - 1.0f, 1.0, 1.0, Compatibility.PI + Compatibility.PI / 2.0, Compatibility.PI * 2.0);
            Cairo.cairo_arc(cairo, fw - 1.0f, fh - 1.0f, 1.0, 0.0, Compatibility.PI / 2.0);
            Cairo.cairo_arc(cairo, 1.0, fh - 1.0f, 1.0, Compatibility.PI / 2.0, Compatibility.PI);
            Cairo.cairo_arc(cairo, 1.0, 1.0, 1.0, Compatibility.PI, 270.0 * Compatibility.PI / 180.0);
            Cairo.cairo_close_path(cairo);
            Cairo.cairo_restore(cairo);
            Cairo.cairo_stroke(cairo);
            return;
        }
        int naw2 = naw / 2;
        int nah2 = nah / 2;
        long drawable = this.data.drawable;
        if (nw > naw) {
            if (nh > nah) {
                OS.gdk_draw_arc(drawable, this.handle, 0, nx, ny, naw, nah, 5760, 5760);
                OS.gdk_draw_line(drawable, this.handle, nx + naw2, ny, nx + nw - naw2, ny);
                OS.gdk_draw_arc(drawable, this.handle, 0, nx + nw - naw, ny, naw, nah, 0, 5760);
                OS.gdk_draw_line(drawable, this.handle, nx + nw, ny + nah2, nx + nw, ny + nh - nah2);
                OS.gdk_draw_arc(drawable, this.handle, 0, nx + nw - naw, ny + nh - nah, naw, nah, 17280, 5760);
                OS.gdk_draw_line(drawable, this.handle, nx + naw2, ny + nh, nx + nw - naw2, ny + nh);
                OS.gdk_draw_arc(drawable, this.handle, 0, nx, ny + nh - nah, naw, nah, 11520, 5760);
                OS.gdk_draw_line(drawable, this.handle, nx, ny + nah2, nx, ny + nh - nah2);
            } else {
                OS.gdk_draw_arc(drawable, this.handle, 0, nx, ny, naw, nh, 5760, 11520);
                OS.gdk_draw_line(drawable, this.handle, nx + naw2, ny, nx + nw - naw2, ny);
                OS.gdk_draw_arc(drawable, this.handle, 0, nx + nw - naw, ny, naw, nh, 17280, 11520);
                OS.gdk_draw_line(drawable, this.handle, nx + naw2, ny + nh, nx + nw - naw2, ny + nh);
            }
        } else if (nh > nah) {
            OS.gdk_draw_arc(drawable, this.handle, 0, nx, ny, nw, nah, 0, 11520);
            OS.gdk_draw_line(drawable, this.handle, nx + nw, ny + nah2, nx + nw, ny + nh - nah2);
            OS.gdk_draw_arc(drawable, this.handle, 0, nx, ny + nh - nah, nw, nah, 11520, 11520);
            OS.gdk_draw_line(drawable, this.handle, nx, ny + nah2, nx, ny + nh - nah2);
        } else {
            OS.gdk_draw_arc(drawable, this.handle, 0, nx, ny, nw, nh, 0, 23040);
        }
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        this.drawText(string, x, y, isTransparent ? 1 : 0);
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        long cairo = this.data.cairo;
        if (cairo != 0L && OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            cairo_font_extents_t extents = new cairo_font_extents_t();
            Cairo.cairo_font_extents(cairo, extents);
            double baseline = (double)y + extents.ascent;
            Cairo.cairo_move_to(cairo, x, baseline);
            byte[] buffer = Converter.wcsToMbcs(null, string, true);
            Cairo.cairo_show_text(cairo, buffer);
            Cairo.cairo_new_path(cairo);
            return;
        }
        this.setString(string, flags);
        GdkColor background = null;
        GdkGCValues values = null;
        if ((flags & 1) == 0) {
            values = new GdkGCValues();
            OS.gdk_gc_get_values(this.handle, values);
            background = new GdkColor();
            background.pixel = values.background_pixel;
            long colormap = OS.gdk_colormap_get_system();
            OS.gdk_colormap_query_color(colormap, background.pixel, background);
        }
        if (cairo != 0L) {
            if ((flags & 1) == 0) {
                int[] width = new int[1];
                int[] height = new int[1];
                OS.pango_layout_get_size(this.data.layout, width, height);
                Cairo.cairo_rectangle(cairo, x, y, OS.PANGO_PIXELS(width[0]), OS.PANGO_PIXELS(height[0]));
                Cairo.cairo_save(cairo);
                if (this.data.backgroundPattern != null) {
                    Cairo.cairo_set_source(cairo, this.data.backgroundPattern.handle);
                } else {
                    Cairo.cairo_set_source_rgba(cairo, (float)(background.red & 0xFFFF) / 65535.0f, (float)(background.green & 0xFFFF) / 65535.0f, (float)(background.blue & 0xFFFF) / 65535.0f, (float)this.data.alpha / 255.0f);
                }
                Cairo.cairo_fill(cairo);
                Cairo.cairo_restore(cairo);
            }
            Cairo.cairo_move_to(cairo, x, y);
            OS.pango_cairo_show_layout(cairo, this.data.layout);
            return;
        }
        if (!this.data.xorMode) {
            OS.gdk_draw_layout_with_colors(this.data.drawable, this.handle, x, y, this.data.layout, null, background);
        } else {
            long gdkGC;
            long layout = this.data.layout;
            int[] w = new int[1];
            int[] h = new int[1];
            OS.pango_layout_get_size(layout, w, h);
            int width = OS.PANGO_PIXELS(w[0]);
            int height = OS.PANGO_PIXELS(h[0]);
            long pixmap = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), width, height, -1);
            if (pixmap == 0L) {
                SWT.error(2);
            }
            if ((gdkGC = OS.gdk_gc_new(pixmap)) == 0L) {
                SWT.error(2);
            }
            GdkColor foreground = new GdkColor();
            OS.gdk_gc_set_foreground(gdkGC, foreground);
            OS.gdk_draw_rectangle(pixmap, gdkGC, 1, 0, 0, width, height);
            if (values == null) {
                values = new GdkGCValues();
                OS.gdk_gc_get_values(this.handle, values);
            }
            foreground.pixel = values.foreground_pixel;
            OS.gdk_gc_set_foreground(gdkGC, foreground);
            OS.gdk_draw_layout_with_colors(pixmap, gdkGC, 0, 0, layout, null, background);
            OS.g_object_unref(gdkGC);
            OS.gdk_draw_drawable(this.data.drawable, this.handle, pixmap, 0, 0, x, y, width, height);
            OS.g_object_unref(pixmap);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            if (width == height) {
                if (arcAngle >= 0) {
                    Cairo.cairo_arc_negative(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f, (float)width / 2.0f, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f, (float)width / 2.0f, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                }
                Cairo.cairo_line_to(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
            } else {
                Cairo.cairo_save(cairo);
                Cairo.cairo_translate(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
                Cairo.cairo_scale(cairo, (float)width / 2.0f, (float)height / 2.0f);
                if (arcAngle >= 0) {
                    Cairo.cairo_arc_negative(cairo, 0.0, 0.0, 1.0, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(cairo, 0.0, 0.0, 1.0, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                }
                Cairo.cairo_line_to(cairo, 0.0, 0.0);
                Cairo.cairo_restore(cairo);
            }
            Cairo.cairo_save(cairo);
            if (this.data.backgroundPattern != null) {
                Cairo.cairo_set_source(cairo, this.data.backgroundPattern.handle);
            } else {
                OS.gdk_colormap_query_color(OS.gdk_colormap_get_system(), color.pixel, color);
                Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, (float)this.data.alpha / 255.0f);
            }
            Cairo.cairo_fill(cairo);
            Cairo.cairo_restore(cairo);
            return;
        }
        OS.gdk_gc_set_foreground(this.handle, color);
        OS.gdk_draw_arc(this.data.drawable, this.handle, 1, x, y, width, height, startAngle * 64, arcAngle * 64);
        color.pixel = values.foreground_pixel;
        OS.gdk_gc_set_foreground(this.handle, color);
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        RGB foregroundRGB;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        RGB backgroundRGB = this.getBackground().getRGB();
        RGB fromRGB = foregroundRGB = this.getForeground().getRGB();
        RGB toRGB = backgroundRGB;
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width = -width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height = -height;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            fromRGB = backgroundRGB;
            toRGB = foregroundRGB;
        }
        if (fromRGB.equals(toRGB)) {
            this.fillRectangle(x, y, width, height);
            return;
        }
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            long pattern = vertical ? Cairo.cairo_pattern_create_linear(0.0, 0.0, 0.0, 1.0) : Cairo.cairo_pattern_create_linear(0.0, 0.0, 1.0, 0.0);
            Cairo.cairo_pattern_add_color_stop_rgba(pattern, 0.0, (float)fromRGB.red / 255.0f, (float)fromRGB.green / 255.0f, (float)fromRGB.blue / 255.0f, (float)this.data.alpha / 255.0f);
            Cairo.cairo_pattern_add_color_stop_rgba(pattern, 1.0, (float)toRGB.red / 255.0f, (float)toRGB.green / 255.0f, (float)toRGB.blue / 255.0f, (float)this.data.alpha / 255.0f);
            Cairo.cairo_save(cairo);
            Cairo.cairo_translate(cairo, x, y);
            Cairo.cairo_scale(cairo, width, height);
            Cairo.cairo_rectangle(cairo, 0.0, 0.0, 1.0, 1.0);
            Cairo.cairo_set_source(cairo, pattern);
            Cairo.cairo_fill(cairo);
            Cairo.cairo_restore(cairo);
            Cairo.cairo_pattern_destroy(pattern);
            return;
        }
        ImageData.fillGradientRectangle(this, this.data.device, x, y, width, height, vertical, fromRGB, toRGB, 8, 8, 8);
    }

    public void fillOval(int x, int y, int width, int height) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            if (width == height) {
                Cairo.cairo_arc_negative(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f, (float)width / 2.0f, 0.0, 2.0f * (float)Compatibility.PI);
            } else {
                Cairo.cairo_save(cairo);
                Cairo.cairo_translate(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
                Cairo.cairo_scale(cairo, (float)width / 2.0f, (float)height / 2.0f);
                Cairo.cairo_arc_negative(cairo, 0.0, 0.0, 1.0, 0.0, 2.0f * (float)Compatibility.PI);
                Cairo.cairo_restore(cairo);
            }
            Cairo.cairo_save(cairo);
            if (this.data.backgroundPattern != null) {
                Cairo.cairo_set_source(cairo, this.data.backgroundPattern.handle);
            } else {
                OS.gdk_colormap_query_color(OS.gdk_colormap_get_system(), color.pixel, color);
                Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, (float)this.data.alpha / 255.0f);
            }
            Cairo.cairo_fill(cairo);
            Cairo.cairo_restore(cairo);
            return;
        }
        OS.gdk_gc_set_foreground(this.handle, color);
        OS.gdk_draw_arc(this.data.drawable, this.handle, 1, x, y, width, height, 0, 23040);
        color.pixel = values.foreground_pixel;
        OS.gdk_gc_set_foreground(this.handle, color);
    }

    public void fillPath(Path path) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0L) {
            SWT.error(5);
        }
        this.initCairo();
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        long cairo = this.data.cairo;
        long colormap = OS.gdk_colormap_get_system();
        OS.gdk_colormap_query_color(colormap, color.pixel, color);
        Cairo.cairo_save(cairo);
        if (this.data.backgroundPattern != null) {
            Cairo.cairo_set_source(cairo, this.data.backgroundPattern.handle);
        } else {
            Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, (float)this.data.alpha / 255.0f);
        }
        long copy = Cairo.cairo_copy_path(path.handle);
        if (copy == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(cairo, copy);
        Cairo.cairo_path_destroy(copy);
        Cairo.cairo_fill(cairo);
        Cairo.cairo_restore(cairo);
    }

    public void fillPolygon(int[] pointArray) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            long colormap = OS.gdk_colormap_get_system();
            OS.gdk_colormap_query_color(colormap, color.pixel, color);
            Cairo.cairo_save(cairo);
            if (this.data.backgroundPattern != null) {
                Cairo.cairo_set_source(cairo, this.data.backgroundPattern.handle);
            } else {
                Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, (float)this.data.alpha / 255.0f);
            }
            this.drawPolyline(cairo, pointArray, true);
            Cairo.cairo_fill(cairo);
            Cairo.cairo_restore(cairo);
            return;
        }
        OS.gdk_gc_set_foreground(this.handle, color);
        OS.gdk_draw_polygon(this.data.drawable, this.handle, 1, pointArray, pointArray.length / 2);
        color.pixel = values.foreground_pixel;
        OS.gdk_gc_set_foreground(this.handle, color);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            long colormap = OS.gdk_colormap_get_system();
            OS.gdk_colormap_query_color(colormap, color.pixel, color);
            Cairo.cairo_save(cairo);
            if (this.data.backgroundPattern != null) {
                Cairo.cairo_set_source(cairo, this.data.backgroundPattern.handle);
            } else {
                Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, (float)this.data.alpha / 255.0f);
            }
            Cairo.cairo_rectangle(cairo, x, y, width, height);
            Cairo.cairo_fill(cairo);
            Cairo.cairo_restore(cairo);
            return;
        }
        OS.gdk_gc_set_foreground(this.handle, color);
        OS.gdk_draw_rectangle(this.data.drawable, this.handle, 1, x, y, width, height);
        color.pixel = values.foreground_pixel;
        OS.gdk_gc_set_foreground(this.handle, color);
    }

    public void fillRectangle(Rectangle rect) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            float naw2 = (float)naw / 2.0f;
            float nah2 = (float)nah / 2.0f;
            float fw = (float)nw / naw2;
            float fh = (float)nh / nah2;
            long colormap = OS.gdk_colormap_get_system();
            OS.gdk_colormap_query_color(colormap, color.pixel, color);
            Cairo.cairo_save(cairo);
            Cairo.cairo_save(cairo);
            Cairo.cairo_translate(cairo, nx, ny);
            Cairo.cairo_scale(cairo, naw2, nah2);
            Cairo.cairo_move_to(cairo, fw - 1.0f, 0.0);
            Cairo.cairo_arc(cairo, fw - 1.0f, 1.0, 1.0, Compatibility.PI + Compatibility.PI / 2.0, Compatibility.PI * 2.0);
            Cairo.cairo_arc(cairo, fw - 1.0f, fh - 1.0f, 1.0, 0.0, Compatibility.PI / 2.0);
            Cairo.cairo_arc(cairo, 1.0, fh - 1.0f, 1.0, Compatibility.PI / 2.0, Compatibility.PI);
            Cairo.cairo_arc(cairo, 1.0, 1.0, 1.0, Compatibility.PI, 270.0 * Compatibility.PI / 180.0);
            Cairo.cairo_close_path(cairo);
            Cairo.cairo_restore(cairo);
            if (this.data.backgroundPattern != null) {
                Cairo.cairo_set_source(cairo, this.data.backgroundPattern.handle);
            } else {
                Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, (float)this.data.alpha / 255.0f);
            }
            Cairo.cairo_fill(cairo);
            Cairo.cairo_restore(cairo);
            return;
        }
        int naw2 = naw / 2;
        int nah2 = nah / 2;
        OS.gdk_gc_set_foreground(this.handle, color);
        long drawable = this.data.drawable;
        if (nw > naw) {
            if (nh > nah) {
                OS.gdk_draw_arc(drawable, this.handle, 1, nx, ny, naw, nah, 5760, 5760);
                OS.gdk_draw_rectangle(drawable, this.handle, 1, nx + naw2, ny, nw - naw2 * 2, nh);
                OS.gdk_draw_arc(drawable, this.handle, 1, nx + nw - naw, ny, naw, nah, 0, 5760);
                OS.gdk_draw_rectangle(drawable, this.handle, 1, nx, ny + nah2, naw2, nh - nah2 * 2);
                OS.gdk_draw_arc(drawable, this.handle, 1, nx + nw - naw, ny + nh - nah, naw, nah, 17280, 5760);
                OS.gdk_draw_rectangle(drawable, this.handle, 1, nx + nw - naw2, ny + nah2, naw2, nh - nah2 * 2);
                OS.gdk_draw_arc(drawable, this.handle, 1, nx, ny + nh - nah, naw, nah, 11520, 5760);
            } else {
                OS.gdk_draw_arc(drawable, this.handle, 1, nx, ny, naw, nh, 5760, 11520);
                OS.gdk_draw_rectangle(drawable, this.handle, 1, nx + naw2, ny, nw - naw2 * 2, nh);
                OS.gdk_draw_arc(drawable, this.handle, 1, nx + nw - naw, ny, naw, nh, 17280, 11520);
            }
        } else if (nh > nah) {
            OS.gdk_draw_arc(drawable, this.handle, 1, nx, ny, nw, nah, 0, 11520);
            OS.gdk_draw_rectangle(drawable, this.handle, 1, nx, ny + nah2, nw, nh - nah2 * 2);
            OS.gdk_draw_arc(drawable, this.handle, 1, nx, ny + nh - nah, nw, nah, 11520, 11520);
        } else {
            OS.gdk_draw_arc(drawable, this.handle, 1, nx, ny, nw, nh, 0, 23040);
        }
        color.pixel = values.foreground_pixel;
        OS.gdk_gc_set_foreground(this.handle, color);
    }

    int fixMnemonic(char[] buffer) {
        int i = 0;
        int j = 0;
        int mnemonic = -1;
        while (i < buffer.length) {
            if ((buffer[j++] = buffer[i++]) != '&' || i == buffer.length) continue;
            if (buffer[i] == '&') {
                ++i;
                continue;
            }
            if (mnemonic == -1) {
                mnemonic = j;
            }
            --j;
        }
        while (j < buffer.length) {
            buffer[j++] = '\u0000';
        }
        return mnemonic;
    }

    public int getAdvanceWidth(char ch) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public boolean getAdvanced() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.cairo != 0L;
    }

    public int getAlpha() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L) {
            return -1;
        }
        int antialias = Cairo.cairo_get_antialias(this.data.cairo);
        switch (antialias) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public Color getBackground() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        long colormap = OS.gdk_colormap_get_system();
        OS.gdk_colormap_query_color(colormap, color.pixel, color);
        return Color.gtk_new(this.data.device, color);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.backgroundPattern;
    }

    public int getCharWidth(char ch) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public Rectangle getClipping() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        int[] width = new int[1];
        int[] height = new int[1];
        OS.gdk_drawable_get_size(this.data.drawable, width, height);
        long clipRgn = this.data.clipRgn;
        if (clipRgn == 0L) {
            return new Rectangle(0, 0, width[0], height[0]);
        }
        long rgn = OS.gdk_region_new();
        GdkRectangle rect = new GdkRectangle();
        rect.width = width[0];
        rect.height = height[0];
        OS.gdk_region_union_with_rect(rgn, rect);
        OS.gdk_region_intersect(rgn, clipRgn);
        OS.gdk_region_get_clipbox(rgn, rect);
        OS.gdk_region_destroy(rgn);
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void getClipping(Region region) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        long hRegion = region.handle;
        OS.gdk_region_subtract(hRegion, hRegion);
        long clipRgn = this.data.clipRgn;
        if (clipRgn == 0L) {
            int[] width = new int[1];
            int[] height = new int[1];
            OS.gdk_drawable_get_size(this.data.drawable, width, height);
            GdkRectangle rect = new GdkRectangle();
            rect.y = 0;
            rect.x = 0;
            rect.width = width[0];
            rect.height = height[0];
            OS.gdk_region_union_with_rect(hRegion, rect);
        } else {
            OS.gdk_region_union(hRegion, clipRgn);
            long cairo = this.data.cairo;
            if (cairo != 0L) {
                double[] matrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                Cairo.cairo_get_matrix(cairo, matrix);
                if (!this.isIdentity(matrix)) {
                    return;
                }
            }
        }
        if (this.data.damageRgn != 0L) {
            OS.gdk_region_intersect(hRegion, this.data.damageRgn);
        }
    }

    public int getFillRule() {
        long cairo;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if ((cairo = this.data.cairo) == 0L) {
            return 1;
        }
        return Cairo.cairo_get_fill_rule(cairo) == 0 ? 2 : 1;
    }

    public Font getFont() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return Font.gtk_new(this.data.device, this.data.font);
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.context == 0L) {
            this.createLayout();
        }
        long context = this.data.context;
        long lang = OS.pango_context_get_language(context);
        long metrics = OS.pango_context_get_metrics(context, this.data.font, lang);
        FontMetrics fm = new FontMetrics();
        fm.ascent = OS.PANGO_PIXELS(OS.pango_font_metrics_get_ascent(metrics));
        fm.descent = OS.PANGO_PIXELS(OS.pango_font_metrics_get_descent(metrics));
        fm.averageCharWidth = OS.PANGO_PIXELS(OS.pango_font_metrics_get_approximate_char_width(metrics));
        fm.height = fm.ascent + fm.descent;
        OS.pango_font_metrics_unref(metrics);
        return fm;
    }

    public Color getForeground() {
        if (this.handle == 0L) {
            SWT.error(24);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        GdkColor color = new GdkColor();
        color.pixel = values.foreground_pixel;
        long colormap = OS.gdk_colormap_get_system();
        OS.gdk_colormap_query_color(colormap, color.pixel, color);
        return Color.gtk_new(this.data.device, color);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.interpolation;
    }

    public int getLineCap() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        int cap = 1;
        switch (values.cap_style) {
            case 2: {
                cap = 2;
                break;
            }
            case 1: {
                cap = 1;
                break;
            }
            case 3: {
                cap = 3;
            }
        }
        return cap;
    }

    public int[] getLineDash() {
        int[] dash_list;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if ((dash_list = this.data.dashes) == null) {
            return null;
        }
        int[] dashes = new int[dash_list.length];
        System.arraycopy(dash_list, 0, dashes, 0, dashes.length);
        return dashes;
    }

    public int getLineJoin() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        int join = 1;
        switch (values.join_style) {
            case 0: {
                join = 1;
                break;
            }
            case 1: {
                join = 2;
                break;
            }
            case 2: {
                join = 3;
            }
        }
        return join;
    }

    public int getLineStyle() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        return values.line_width;
    }

    public int getStyle() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public int getTextAntialias() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L) {
            return -1;
        }
        long options = Cairo.cairo_font_options_create();
        Cairo.cairo_get_font_options(this.data.cairo, options);
        int antialias = Cairo.cairo_font_options_get_antialias(options);
        Cairo.cairo_font_options_destroy(options);
        switch (antialias) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public void getTransform(Transform transform) {
        long cairo;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        if ((cairo = this.data.cairo) != 0L) {
            Cairo.cairo_get_matrix(cairo, transform.handle);
        } else {
            transform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public boolean getXORMode() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        return values.function == 2L;
    }

    public int hashCode() {
        return (int)this.handle;
    }

    void init(Drawable drawable, GCData data, long gdkGC) {
        Image image;
        GdkColor background;
        GdkColor foreground = data.foreground;
        if (foreground != null) {
            OS.gdk_gc_set_foreground(gdkGC, foreground);
        }
        if ((background = data.background) != null) {
            OS.gdk_gc_set_background(gdkGC, background);
        }
        if ((image = data.image) != null) {
            image.memGC = this;
            if (image.transparentPixel != -1) {
                image.destroyMask();
            }
        }
        this.drawable = drawable;
        this.data = data;
        this.handle = gdkGC;
    }

    void initCairo() {
        this.data.device.checkCairo();
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            return;
        }
        long xDisplay = OS.GDK_DISPLAY();
        long xVisual = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system());
        long xDrawable = 0L;
        int translateX = 0;
        int translateY = 0;
        long drawable = this.data.drawable;
        if (this.data.image != null) {
            xDrawable = OS.GDK_PIXMAP_XID(drawable);
        } else {
            int[] x = new int[1];
            int[] y = new int[1];
            long[] real_drawable = new long[1];
            OS.gdk_window_get_internal_paint_info(drawable, real_drawable, x, y);
            xDrawable = OS.gdk_x11_drawable_get_xid(real_drawable[0]);
            translateX = -x[0];
            translateY = -y[0];
        }
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gdk_drawable_get_size(drawable, w, h);
        int width = w[0];
        int height = h[0];
        long surface = Cairo.cairo_xlib_surface_create(xDisplay, xDrawable, xVisual, width, height);
        if (surface == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_surface_set_device_offset(surface, translateX, translateY);
        this.data.cairo = cairo = Cairo.cairo_create(surface);
        Cairo.cairo_surface_destroy(surface);
        if (cairo == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_set_fill_rule(cairo, 1);
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        GdkColor color = new GdkColor();
        color.pixel = values.foreground_pixel;
        long colormap = OS.gdk_colormap_get_system();
        OS.gdk_colormap_query_color(colormap, color.pixel, color);
        Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, (float)this.data.alpha / 255.0f);
        Cairo.cairo_set_line_width(cairo, Math.max(1, values.line_width));
        int cap = 0;
        switch (values.cap_style) {
            case 2: {
                cap = 1;
                break;
            }
            case 1: {
                cap = 0;
                break;
            }
            case 3: {
                cap = 2;
            }
        }
        Cairo.cairo_set_line_cap(cairo, cap);
        int join = 0;
        switch (values.join_style) {
            case 0: {
                join = 0;
                break;
            }
            case 1: {
                join = 1;
                break;
            }
            case 2: {
                join = 2;
            }
        }
        Cairo.cairo_set_line_join(cairo, join);
        if (this.data.dashes != null) {
            double[] dashes = new double[this.data.dashes.length];
            int i = 0;
            while (i < dashes.length) {
                dashes[i] = this.data.dashes[i];
                ++i;
            }
            Cairo.cairo_set_dash(cairo, dashes, dashes.length, 0.0);
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            GC.setCairoFont(cairo, this.data.font);
        }
        GC.setCairoClip(cairo, this.data.clipRgn);
    }

    public boolean isClipped() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.clipRgn != 0L;
    }

    public boolean isDisposed() {
        return this.handle == 0L;
    }

    boolean isIdentity(double[] matrix) {
        if (matrix == null) {
            return true;
        }
        return matrix[0] == 1.0 && matrix[1] == 0.0 && matrix[2] == 0.0 && matrix[3] == 1.0 && matrix[4] == 0.0 && matrix[5] == 0.0;
    }

    public void setAdvanced(boolean advanced) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (advanced && this.data.cairo != 0L) {
            return;
        }
        if (advanced) {
            try {
                this.initCairo();
            }
            catch (SWTException sWTException) {}
        } else {
            long cairo = this.data.cairo;
            if (cairo != 0L) {
                Cairo.cairo_destroy(cairo);
            }
            this.data.cairo = 0L;
            this.data.interpolation = -1;
            this.data.foregroundPattern = null;
            this.data.backgroundPattern = null;
            this.setClipping(0L);
        }
    }

    public void setAlpha(int alpha) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L && (alpha & 0xFF) == 255) {
            return;
        }
        this.initCairo();
        this.data.alpha = alpha & 0xFF;
        if (this.data.foregroundPattern == null) {
            GdkGCValues values = new GdkGCValues();
            OS.gdk_gc_get_values(this.handle, values);
            GdkColor color = new GdkColor();
            color.pixel = values.foreground_pixel;
            long colormap = OS.gdk_colormap_get_system();
            OS.gdk_colormap_query_color(colormap, color.pixel, color);
            long cairo = this.data.cairo;
            Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, (float)this.data.alpha / 255.0f);
        }
    }

    public void setAntialias(int antialias) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L && antialias == -1) {
            return;
        }
        int mode = 0;
        switch (antialias) {
            case -1: {
                mode = 0;
                break;
            }
            case 0: {
                mode = 1;
                break;
            }
            case 1: {
                mode = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        long cairo = this.data.cairo;
        Cairo.cairo_set_antialias(cairo, mode);
    }

    public void setBackground(Color color) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_gc_set_background(this.handle, color.handle);
        this.data.backgroundPattern = null;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0L && pattern == null) {
            return;
        }
        this.initCairo();
        this.data.backgroundPattern = pattern;
    }

    static void setCairoFont(long cairo, Font font) {
        GC.setCairoFont(cairo, font.handle);
    }

    static void setCairoFont(long cairo, long font) {
        long family = OS.pango_font_description_get_family(font);
        int length = OS.strlen(family);
        byte[] buffer = new byte[length + 1];
        OS.memmove(buffer, family, (long)length);
        double height = OS.PANGO_PIXELS(OS.pango_font_description_get_size(font)) * 96 / 72;
        int pangoStyle = OS.pango_font_description_get_style(font);
        int pangoWeight = OS.pango_font_description_get_weight(font);
        int slant = 0;
        if (pangoStyle == 2) {
            slant = 1;
        }
        if (pangoStyle == 1) {
            slant = 2;
        }
        int weight = 0;
        if (pangoWeight == 700) {
            weight = 1;
        }
        Cairo.cairo_select_font_face(cairo, buffer, slant, weight);
        Cairo.cairo_set_font_size(cairo, height);
    }

    static void setCairoClip(long cairo, long clipRgn) {
        Cairo.cairo_reset_clip(cairo);
        if (clipRgn == 0L) {
            return;
        }
        int[] nRects = new int[1];
        long[] rects = new long[1];
        OS.gdk_region_get_rectangles(clipRgn, rects, nRects);
        GdkRectangle rect = new GdkRectangle();
        int i = 0;
        while (i < nRects[0]) {
            OS.memmove(rect, rects[0] + (long)(i * GdkRectangle.sizeof), (long)GdkRectangle.sizeof);
            Cairo.cairo_rectangle(cairo, rect.x, rect.y, rect.width, rect.height);
            ++i;
        }
        Cairo.cairo_clip(cairo);
        Cairo.cairo_new_path(cairo);
        if (rects[0] != 0L) {
            OS.g_free(rects[0]);
        }
    }

    static void setCairoPatternColor(long pattern, int offset, Color c, int alpha) {
        GdkColor color = c.handle;
        double aa = (double)(alpha & 0xFF) / 255.0;
        double red = (double)(color.red & 0xFFFF) / 65535.0;
        double green = (double)(color.green & 0xFFFF) / 65535.0;
        double blue = (double)(color.blue & 0xFFFF) / 65535.0;
        Cairo.cairo_pattern_add_color_stop_rgba(pattern, offset, red, green, blue, aa);
    }

    void setClipping(long clipRgn) {
        long clipping;
        if (clipRgn == 0L) {
            if (this.data.clipRgn == 0L) {
                return;
            }
            OS.gdk_region_destroy(this.data.clipRgn);
            this.data.clipRgn = 0L;
            clipping = this.data.damageRgn != 0L ? this.data.damageRgn : 0L;
            OS.gdk_gc_set_clip_region(this.handle, clipping);
        } else {
            if (this.data.clipRgn == 0L) {
                this.data.clipRgn = OS.gdk_region_new();
            }
            OS.gdk_region_subtract(this.data.clipRgn, this.data.clipRgn);
            OS.gdk_region_union(this.data.clipRgn, clipRgn);
            clipping = clipRgn;
            if (this.data.damageRgn != 0L) {
                clipping = OS.gdk_region_new();
                OS.gdk_region_union(clipping, clipRgn);
                OS.gdk_region_intersect(clipping, this.data.damageRgn);
            }
            OS.gdk_gc_set_clip_region(this.handle, clipping);
            if (clipping != clipRgn) {
                OS.gdk_region_destroy(clipping);
            }
        }
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            GC.setCairoClip(cairo, clipRgn);
        }
    }

    public void setClipping(int x, int y, int width, int height) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        GdkRectangle rect = new GdkRectangle();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        long clipRgn = OS.gdk_region_new();
        OS.gdk_region_union_with_rect(clipRgn, rect);
        this.setClipping(clipRgn);
        OS.gdk_region_destroy(clipRgn);
    }

    public void setClipping(Path path) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(44);
        }
        this.setClipping(0L);
        if (path != null) {
            this.initCairo();
            long cairo = this.data.cairo;
            long copy = Cairo.cairo_copy_path(path.handle);
            if (copy == 0L) {
                SWT.error(2);
            }
            Cairo.cairo_append_path(cairo, copy);
            Cairo.cairo_path_destroy(copy);
            Cairo.cairo_clip(cairo);
            Cairo.cairo_new_path(cairo);
        }
    }

    public void setClipping(Rectangle rect) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (rect == null) {
            this.setClipping(0L);
        } else {
            this.setClipping(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(region != null ? region.handle : 0L);
    }

    public void setFont(Font font) {
        long cairo;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (font == null) {
            font = this.data.device.systemFont;
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        long fontHandle = this.data.font = font.handle;
        if (this.data.layout != 0L) {
            OS.pango_layout_set_font_description(this.data.layout, fontHandle);
        }
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 0) && (cairo = this.data.cairo) != 0L) {
            GC.setCairoFont(cairo, fontHandle);
        }
    }

    public void setFillRule(int rule) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        int cairo_mode = 1;
        switch (rule) {
            case 2: {
                cairo_mode = 0;
                break;
            }
            case 1: {
                cairo_mode = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            Cairo.cairo_set_fill_rule(cairo, cairo_mode);
        }
    }

    public void setForeground(Color color) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_gc_set_foreground(this.handle, color.handle);
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            GdkColor gdkColor = color.handle;
            Cairo.cairo_set_source_rgba(cairo, (float)(gdkColor.red & 0xFFFF) / 65535.0f, (float)(gdkColor.green & 0xFFFF) / 65535.0f, (float)(gdkColor.blue & 0xFFFF) / 65535.0f, (float)this.data.alpha / 255.0f);
        }
        this.data.foregroundPattern = null;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0L && pattern == null) {
            return;
        }
        this.initCairo();
        long cairo = this.data.cairo;
        if (pattern != null) {
            Cairo.cairo_set_source(cairo, pattern.handle);
        } else {
            GdkGCValues values = new GdkGCValues();
            OS.gdk_gc_get_values(this.handle, values);
            GdkColor color = new GdkColor();
            color.pixel = values.foreground_pixel;
            long colormap = OS.gdk_colormap_get_system();
            OS.gdk_colormap_query_color(colormap, color.pixel, color);
            Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, (float)this.data.alpha / 255.0f);
        }
        this.data.foregroundPattern = pattern;
    }

    public void setInterpolation(int interpolation) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L && interpolation == -1) {
            return;
        }
        switch (interpolation) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        this.data.interpolation = interpolation;
    }

    public void setLineCap(int cap) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        int cap_style = 0;
        int cairo_style = 0;
        switch (cap) {
            case 2: {
                cap_style = 2;
                cairo_style = 1;
                break;
            }
            case 1: {
                cap_style = 1;
                cairo_style = 0;
                break;
            }
            case 3: {
                cap_style = 3;
                cairo_style = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        int line_style = this.data.lineStyle == 1 ? 0 : 1;
        OS.gdk_gc_set_line_attributes(this.handle, values.line_width, line_style, cap_style, values.join_style);
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            Cairo.cairo_set_line_cap(cairo, cairo_style);
        }
    }

    public void setLineDash(int[] dashes) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (dashes != null && dashes.length > 0) {
            byte[] dash_list = new byte[dashes.length];
            int i = 0;
            while (i < dashes.length) {
                int dash = dashes[i];
                if (dash <= 0) {
                    SWT.error(5);
                }
                dash_list[i] = (byte)dash;
                ++i;
            }
            OS.gdk_gc_set_dashes(this.handle, 0, dash_list, dash_list.length);
            this.data.dashes = new int[dashes.length];
            System.arraycopy(dashes, 0, this.data.dashes, 0, dashes.length);
            this.data.lineStyle = 6;
        } else {
            this.data.dashes = null;
            this.data.lineStyle = 1;
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        int line_style = this.data.lineStyle == 1 ? 0 : 1;
        OS.gdk_gc_set_line_attributes(this.handle, values.line_width, line_style, values.cap_style, values.join_style);
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            if (this.data.dashes != null) {
                double[] cairoDashes = new double[this.data.dashes.length];
                int i = 0;
                while (i < dashes.length) {
                    cairoDashes[i] = this.data.dashes[i];
                    ++i;
                }
                Cairo.cairo_set_dash(cairo, cairoDashes, cairoDashes.length, 0.0);
            } else {
                Cairo.cairo_set_dash(cairo, null, 0, 0.0);
            }
        }
    }

    public void setLineJoin(int join) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        int join_style = 0;
        int cairo_style = 0;
        switch (join) {
            case 1: {
                join_style = 0;
                cairo_style = 0;
                break;
            }
            case 2: {
                join_style = 1;
                cairo_style = 1;
                break;
            }
            case 3: {
                join_style = 2;
                cairo_style = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        int line_style = this.data.lineStyle == 1 ? 0 : 1;
        OS.gdk_gc_set_line_attributes(this.handle, values.line_width, line_style, values.cap_style, join_style);
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            Cairo.cairo_set_line_join(cairo, cairo_style);
        }
    }

    public void setLineStyle(int lineStyle) {
        long cairo;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        int[] dashes = null;
        int width = values.line_width;
        switch (lineStyle) {
            case 1: {
                break;
            }
            case 2: {
                dashes = width != 0 ? LINE_DASH : LINE_DASH_ZERO;
                break;
            }
            case 3: {
                dashes = width != 0 ? LINE_DOT : LINE_DOT_ZERO;
                break;
            }
            case 4: {
                dashes = width != 0 ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                break;
            }
            case 5: {
                dashes = width != 0 ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                break;
            }
            case 6: {
                dashes = this.data.dashes;
                if (dashes != null) break;
                lineStyle = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = lineStyle;
        OS.gdk_gc_set_line_attributes(this.handle, values.line_width, dashes != null ? 1 : 0, values.cap_style, values.join_style);
        if (dashes != null) {
            byte[] dash_list = new byte[dashes.length];
            int i = 0;
            while (i < dash_list.length) {
                dash_list[i] = (byte)(width == 0 ? dashes[i] : dashes[i] * width);
                ++i;
            }
            OS.gdk_gc_set_dashes(this.handle, 0, dash_list, dash_list.length);
        }
        if ((cairo = this.data.cairo) != 0L) {
            if (dashes != null) {
                double[] cairoDashes = new double[dashes.length];
                int i = 0;
                while (i < cairoDashes.length) {
                    cairoDashes[i] = width == 0 ? dashes[i] : dashes[i] * width;
                    ++i;
                }
                Cairo.cairo_set_dash(cairo, cairoDashes, cairoDashes.length, 0.0);
            } else {
                Cairo.cairo_set_dash(cairo, null, 0, 0.0);
            }
        }
    }

    public void setLineWidth(int lineWidth) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values(this.handle, values);
        int line_style = this.data.lineStyle == 1 ? 0 : 1;
        OS.gdk_gc_set_line_attributes(this.handle, lineWidth, line_style, values.cap_style, values.join_style);
        this.data.lineWidth = lineWidth;
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            Cairo.cairo_set_line_width(cairo, Math.max(1, lineWidth));
        }
        switch (this.data.lineStyle) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.setLineStyle(this.data.lineStyle);
            }
        }
    }

    void setString(String string, int flags) {
        byte[] buffer;
        int mnemonic;
        if (this.data.layout == 0L) {
            this.createLayout();
        }
        if (string == this.data.string && (flags & 0xFFFFFFFE) == (this.data.drawFlags & 0xFFFFFFFE)) {
            return;
        }
        int length = string.length();
        long layout = this.data.layout;
        char[] text = new char[length];
        string.getChars(0, length, text, 0);
        if ((flags & 8) != 0 && (mnemonic = this.fixMnemonic(text)) != -1) {
            char[] text1 = new char[mnemonic - 1];
            System.arraycopy(text, 0, text1, 0, text1.length);
            byte[] buffer1 = Converter.wcsToMbcs(null, text1, false);
            char[] text2 = new char[text.length - mnemonic];
            System.arraycopy(text, mnemonic - 1, text2, 0, text2.length);
            byte[] buffer2 = Converter.wcsToMbcs(null, text2, false);
            buffer = new byte[buffer1.length + buffer2.length];
            System.arraycopy(buffer1, 0, buffer, 0, buffer1.length);
            System.arraycopy(buffer2, 0, buffer, buffer1.length, buffer2.length);
            long attr_list = OS.pango_attr_list_new();
            long attr = OS.pango_attr_underline_new(3);
            PangoAttribute attribute = new PangoAttribute();
            OS.memmove(attribute, attr, (long)PangoAttribute.sizeof);
            attribute.start_index = buffer1.length;
            attribute.end_index = buffer1.length + 1;
            OS.memmove(attr, attribute, (long)PangoAttribute.sizeof);
            OS.pango_attr_list_insert(attr_list, attr);
            OS.pango_layout_set_attributes(layout, attr_list);
            OS.pango_attr_list_unref(attr_list);
        } else {
            buffer = Converter.wcsToMbcs(null, text, false);
            OS.pango_layout_set_attributes(layout, 0L);
        }
        OS.pango_layout_set_text(layout, buffer, buffer.length);
        OS.pango_layout_set_single_paragraph_mode(layout, (flags & 2) == 0);
        OS.pango_layout_set_tabs(layout, (flags & 4) != 0 ? 0L : this.data.device.emptyTab);
        this.data.string = string;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
        this.data.drawFlags = flags;
    }

    public void setTextAntialias(int antialias) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L && antialias == -1) {
            return;
        }
        int mode = 0;
        switch (antialias) {
            case -1: {
                mode = 0;
                break;
            }
            case 0: {
                mode = 1;
                break;
            }
            case 1: {
                mode = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        long options = Cairo.cairo_font_options_create();
        Cairo.cairo_font_options_set_antialias(options, mode);
        Cairo.cairo_set_font_options(this.data.cairo, options);
        Cairo.cairo_font_options_destroy(options);
    }

    public void setTransform(Transform transform) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0L && transform == null) {
            return;
        }
        this.initCairo();
        long cairo = this.data.cairo;
        if (transform != null) {
            Cairo.cairo_set_matrix(cairo, transform.handle);
        } else {
            Cairo.cairo_identity_matrix(cairo);
        }
        long clipRgn = this.data.clipRgn;
        if (clipRgn != 0L) {
            double[] matrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
            Cairo.cairo_get_matrix(cairo, matrix);
            Cairo.cairo_matrix_invert(matrix);
            long newRgn = OS.gdk_region_new();
            int[] nRects = new int[1];
            long[] rects = new long[1];
            OS.gdk_region_get_rectangles(clipRgn, rects, nRects);
            GdkRectangle rect = new GdkRectangle();
            int[] pointArray = new int[8];
            double[] x = new double[1];
            double[] y = new double[1];
            int i = 0;
            while (i < nRects[0]) {
                OS.memmove(rect, rects[0] + (long)(i * GdkRectangle.sizeof), (long)GdkRectangle.sizeof);
                x[0] = rect.x;
                y[0] = rect.y;
                Cairo.cairo_matrix_transform_point(matrix, x, y);
                pointArray[0] = (int)Math.round(x[0]);
                pointArray[1] = (int)Math.round(y[0]);
                x[0] = rect.x + rect.width;
                y[0] = rect.y;
                Cairo.cairo_matrix_transform_point(matrix, x, y);
                pointArray[2] = (int)Math.round(x[0]);
                pointArray[3] = (int)Math.round(y[0]);
                x[0] = rect.x + rect.width;
                y[0] = rect.y + rect.height;
                Cairo.cairo_matrix_transform_point(matrix, x, y);
                pointArray[4] = (int)Math.round(x[0]);
                pointArray[5] = (int)Math.round(y[0]);
                x[0] = rect.x;
                y[0] = rect.y + rect.height;
                Cairo.cairo_matrix_transform_point(matrix, x, y);
                pointArray[6] = (int)Math.round(x[0]);
                pointArray[7] = (int)Math.round(y[0]);
                long polyRgn = OS.gdk_region_polygon(pointArray, pointArray.length / 2, 0);
                OS.gdk_region_union(newRgn, polyRgn);
                OS.gdk_region_destroy(polyRgn);
                ++i;
            }
            if (rects[0] != 0L) {
                OS.g_free(rects[0]);
            }
            OS.gdk_region_destroy(clipRgn);
            this.data.clipRgn = newRgn;
        }
    }

    public void setXORMode(boolean xor) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        OS.gdk_gc_set_function(this.handle, xor ? 2 : 0);
        this.data.xorMode = xor;
    }

    public Point stringExtent(String string) {
        return this.textExtent(string, 0);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int flags) {
        long cairo;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if ((cairo = this.data.cairo) != 0L && OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            byte[] buffer = Converter.wcsToMbcs(null, string, true);
            cairo_font_extents_t font_extents = new cairo_font_extents_t();
            Cairo.cairo_font_extents(cairo, font_extents);
            cairo_text_extents_t extents = new cairo_text_extents_t();
            Cairo.cairo_text_extents(cairo, buffer, extents);
            return new Point((int)extents.width, (int)font_extents.height);
        }
        this.setString(string, flags);
        if (this.data.stringWidth != -1) {
            return new Point(this.data.stringWidth, this.data.stringHeight);
        }
        int[] width = new int[1];
        int[] height = new int[1];
        OS.pango_layout_get_size(this.data.layout, width, height);
        this.data.stringWidth = OS.PANGO_PIXELS(width[0]);
        this.data.stringHeight = OS.PANGO_PIXELS(height[0]);
        return new Point(this.data.stringWidth, this.data.stringHeight);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }
}

