/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.EventQueue;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpStatusCode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.SessionStructure;

public class ProxyListenerLog
implements ProxyListener {
    private static final Logger log = Logger.getLogger(ProxyListenerLog.class);
    public static final int PROXY_LISTENER_ORDER = 5000;
    private ViewDelegate view = null;
    private Model model = null;
    private boolean isFirstAccess = true;
    private ExtensionHistory extension = null;

    public ProxyListenerLog(Model model, ViewDelegate viewDelegate, ExtensionHistory extensionHistory) {
        this.model = model;
        this.view = viewDelegate;
        this.extension = extensionHistory;
    }

    @Override
    public int getArrangeableListenerOrder() {
        return 5000;
    }

    @Override
    public boolean onHttpRequestSend(HttpMessage httpMessage) {
        HttpMessage httpMessage2 = this.model.getSession().getSiteTree().pollPath(httpMessage);
        if (httpMessage2 != null && !httpMessage2.getResponseHeader().isEmpty() && HttpStatusCode.isSuccess(httpMessage2.getResponseHeader().getStatusCode())) {
            return true;
        }
        if (httpMessage.getRequestHeader().getHeader("If-Modified-Since") != null) {
            httpMessage.getRequestHeader().setHeader("If-Modified-Since", null);
        }
        if (httpMessage.getRequestHeader().getHeader("If-None-Match") != null) {
            httpMessage.getRequestHeader().setHeader("If-None-Match", null);
        }
        return true;
    }

    @Override
    public boolean onHttpResponseReceive(final HttpMessage httpMessage) {
        int n = 1;
        if (this.isSkipImage(httpMessage.getRequestHeader()) || this.isSkipImage(httpMessage.getResponseHeader())) {
            if (httpMessage.getResponseHeader().getStatusCode() == 200) {
                n = 6;
            } else {
                return true;
            }
        }
        final int n2 = n;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ProxyListenerLog.this.addHistory(httpMessage, n2);
            }
        });
        thread.start();
        return true;
    }

    public boolean isSkipImage(HttpHeader httpHeader) {
        return httpHeader.isImage() && !this.model.getOptionsParam().getViewParam().isProcessImages();
    }

    private void addHistory(HttpMessage httpMessage, int n) {
        HistoryReference historyReference = null;
        try {
            historyReference = new HistoryReference(this.model.getSession(), n, httpMessage);
        }
        catch (Exception exception) {
            log.warn((Object)exception.getMessage(), (Throwable)exception);
            return;
        }
        if (n != 1 && n != 6) {
            return;
        }
        this.extension.addHistory(historyReference);
        this.addToSiteMap(historyReference, httpMessage);
    }

    private void addToSiteMap(final HistoryReference historyReference, final HttpMessage httpMessage) {
        if (View.isInitialised() && !EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ProxyListenerLog.this.addToSiteMap(historyReference, httpMessage);
                    }
                });
            }
            catch (Exception exception) {
                log.warn((Object)exception.getMessage(), (Throwable)exception);
            }
            return;
        }
        SessionStructure.addPath(this.model.getSession(), historyReference, httpMessage);
        if (this.isFirstAccess && !Constant.isLowMemoryOptionSet()) {
            this.isFirstAccess = false;
            if (View.isInitialised()) {
                this.view.getSiteTreePanel().expandRoot();
            }
        }
    }
}

