/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import ch.csnc.extension.httpclient.SSLContextManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.DecoratedSocketsSslSocketFactory;
import org.parosproxy.paros.network.RelaxedX509TrustManager;
import org.parosproxy.paros.security.CachedSslCertifificateServiceImpl;
import org.parosproxy.paros.security.SslCertificateService;

public class SSLConnector
implements SecureProtocolSocketFactory {
    private static final String SSL = "SSL";
    private static final String CONTENTS_UNRECOGNIZED_NAME_EXCEPTION = "unrecognized_name";
    public static final String SECURITY_PROTOCOL_SSL_V2_HELLO = "SSLv2Hello";
    public static final String SECURITY_PROTOCOL_SSL_V3 = "SSLv3";
    public static final String SECURITY_PROTOCOL_TLS_V1 = "TLSv1";
    public static final String SECURITY_PROTOCOL_TLS_V1_1 = "TLSv1.1";
    public static final String SECURITY_PROTOCOL_TLS_V1_2 = "TLSv1.2";
    private static final String[] DEFAULT_ENABLED_PROTOCOLS = new String[]{"SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"};
    private static final String[] FAIL_SAFE_DEFAULT_ENABLED_PROTOCOLS = new String[]{"TLSv1"};
    private SSLSocketFactory clientSSLSockFactory = null;
    private SSLSocketFactory clientSSLSockCertFactory = null;
    private static String[] supportedProtocols;
    private static String[] clientEnabledProtocols;
    private static String[] serverEnabledProtocols;
    private static ServerSslSocketsDecorator serverSslSocketsDecorator;
    private static ClientSslSocketsDecorator clientSslSocketsDecorator;
    private static long MAX_AGE_MISCONFIGURED_HOST_IN_MIN;
    private static long MAX_AGE_MISCONFIGURED_HOST_IN_MS;
    private static LRUMap misconfiguredHosts;
    private static long timeStampLastStaleCheck;
    private static final Logger logger;
    private static SSLContextManager sslContextManager;
    private boolean relaxedTrust = true;

    public SSLConnector() {
        this(true);
    }

    public SSLConnector(boolean bl) {
        this.relaxedTrust = bl;
        if (this.clientSSLSockFactory == null) {
            serverSslSocketsDecorator = new ServerSslSocketsDecorator();
            clientSslSocketsDecorator = new ClientSslSocketsDecorator();
            this.clientSSLSockFactory = this.getClientSocketFactory(SSL);
            misconfiguredHosts = new LRUMap(10);
        }
        if (sslContextManager == null) {
            sslContextManager = new SSLContextManager();
        }
    }

    public SSLContextManager getSSLContextManager() {
        return sslContextManager;
    }

    public void setEnableClientCert(boolean bl) {
        if (bl) {
            this.clientSSLSockFactory = this.clientSSLSockCertFactory;
            logger.info((Object)("ClientCert enabled using: " + sslContextManager.getDefaultKey()));
        } else {
            this.clientSSLSockFactory = this.getClientSocketFactory(SSL);
            logger.info((Object)"ClientCert disabled");
        }
    }

    public void setActiveCertificate() {
        SSLContext sSLContext = sslContextManager.getSSLContext(sslContextManager.getDefaultKey());
        this.clientSSLSockCertFactory = SSLConnector.createDecoratedClientSslSocketFactory(sSLContext.getSocketFactory());
        logger.info((Object)("ActiveCertificate set to: " + sslContextManager.getDefaultKey()));
    }

    public ServerSocket listen(int n, int n2, InetAddress inetAddress) throws IOException {
        throw new UnsupportedOperationException("this code is probably not needed any more, SSL server sockets are not \"static\", they're created on the fly");
    }

    public SSLSocketFactory getClientSocketFactory(String string) {
        TrustManager[] trustManagerArray = new TrustManager[]{new RelaxedX509TrustManager()};
        try {
            SSLContext sSLContext = SSLContext.getInstance(string);
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.setSeed(System.currentTimeMillis());
            if (this.relaxedTrust) {
                sSLContext.init(null, trustManagerArray, secureRandom);
            } else {
                sSLContext.init(null, null, secureRandom);
            }
            this.clientSSLSockFactory = SSLConnector.createDecoratedClientSslSocketFactory(sSLContext.getSocketFactory());
            HttpsURLConnection.setDefaultSSLSocketFactory(this.clientSSLSockFactory);
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return this.clientSSLSockFactory;
    }

    @Deprecated
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        throw new UnsupportedOperationException("Method no longer supported since it's no longer required/called by Commons HttpClient library (version >= 3.0).");
    }

    public static String[] getSupportedProtocols() {
        if (supportedProtocols == null) {
            SSLConnector.readSupportedProtocols(null);
        }
        return Arrays.copyOf(supportedProtocols, supportedProtocols.length);
    }

    private static synchronized void readSupportedProtocols(SSLSocket sSLSocket) {
        if (supportedProtocols == null) {
            Object[] objectArray;
            logger.info((Object)"Reading supported SSL/TLS protocols...");
            if (sSLSocket != null) {
                logger.info((Object)"Using an existing SSLSocket...");
                objectArray = sSLSocket.getSupportedProtocols();
            } else {
                logger.info((Object)"Using a SSLEngine...");
                try {
                    SSLContext sSLContext = SSLContext.getInstance(SSL);
                    sSLContext.init(null, null, null);
                    try {
                        objectArray = sSLContext.createSSLEngine().getSupportedProtocols();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        logger.warn((Object)"Failed to use SSLEngine. Trying with unconnected socket...", (Throwable)unsupportedOperationException);
                        try (SSLSocket sSLSocket2 = (SSLSocket)sSLContext.getSocketFactory().createSocket();){
                            objectArray = sSLSocket2.getSupportedProtocols();
                        }
                    }
                }
                catch (IOException | KeyManagementException | NoSuchAlgorithmException exception) {
                    logger.error((Object)("Failed to read the SSL/TLS supported protocols. Using default protocol versions: " + Arrays.toString(FAIL_SAFE_DEFAULT_ENABLED_PROTOCOLS)), (Throwable)exception);
                    objectArray = FAIL_SAFE_DEFAULT_ENABLED_PROTOCOLS;
                }
            }
            Arrays.sort(objectArray);
            supportedProtocols = objectArray;
            logger.info((Object)("Done reading supported SSL/TLS protocols: " + Arrays.toString(supportedProtocols)));
        }
    }

    public static String[] getClientEnabledProtocols() {
        if (clientEnabledProtocols == null) {
            SSLConnector.setClientEnabledProtocols(DEFAULT_ENABLED_PROTOCOLS);
        }
        return Arrays.copyOf(clientEnabledProtocols, clientEnabledProtocols.length);
    }

    public static void setClientEnabledProtocols(String[] stringArray) {
        clientEnabledProtocols = SSLConnector.extractSupportedProtocols(stringArray);
    }

    public static String[] getServerEnabledProtocols() {
        if (serverEnabledProtocols == null) {
            SSLConnector.setServerEnabledProtocols(DEFAULT_ENABLED_PROTOCOLS);
        }
        return Arrays.copyOf(serverEnabledProtocols, serverEnabledProtocols.length);
    }

    public static void setServerEnabledProtocols(String[] stringArray) {
        serverEnabledProtocols = SSLConnector.extractSupportedProtocols(stringArray);
    }

    private static String[] extractSupportedProtocols(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Protocol(s) required but no protocol set.");
        }
        Object[] objectArray = SSLConnector.getSupportedProtocols();
        ArrayList<String> arrayList = new ArrayList<String>(objectArray.length);
        for (String string : stringArray) {
            if (string == null || Arrays.binarySearch(objectArray, string) < 0) continue;
            arrayList.add(string);
        }
        arrayList.trimToSize();
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("No supported protocol(s) set.");
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2, HttpConnectionParams httpConnectionParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (httpConnectionParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int n3 = httpConnectionParams.getConnectionTimeout();
        if (n3 == 0) {
            InetAddress inetAddress2 = SSLConnector.getCachedMisconfiguredHost(string, n);
            if (inetAddress2 != null) {
                return this.clientSSLSockFactory.createSocket(inetAddress2, n, inetAddress, n2);
            }
            try {
                SSLSocket sSLSocket = (SSLSocket)this.clientSSLSockFactory.createSocket(string, n, inetAddress, n2);
                sSLSocket.startHandshake();
                return sSLSocket;
            }
            catch (SSLException sSLException) {
                if (!sSLException.getMessage().contains(CONTENTS_UNRECOGNIZED_NAME_EXCEPTION)) {
                    throw sSLException;
                }
                inetAddress2 = InetAddress.getByName(string);
                SSLConnector.cacheMisconfiguredHost(string, n, inetAddress2);
                return this.clientSSLSockFactory.createSocket(inetAddress2, n, inetAddress, n2);
            }
        }
        Socket socket = this.clientSSLSockFactory.createSocket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n2);
        socket.bind(inetSocketAddress);
        InetSocketAddress inetSocketAddress2 = new InetSocketAddress(string, n);
        socket.connect(inetSocketAddress2, n3);
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheMisconfiguredHost(String string, int n, InetAddress inetAddress) {
        LRUMap lRUMap = misconfiguredHosts;
        synchronized (lRUMap) {
            if (!misconfiguredHosts.isEmpty()) {
                SSLConnector.removeStaleCachedMisconfiguredHosts();
            }
            logger.info((Object)("Caching address of misconfigured (\"unrecognized_name\") host [host=" + string + ", port=" + n + "] for the next " + MAX_AGE_MISCONFIGURED_HOST_IN_MIN + " minutes, following connections will not use the hostname."));
            misconfiguredHosts.put((Object)(string + n), (Object)new MisconfiguredHostCacheEntry(string, n, inetAddress));
        }
    }

    private static void removeStaleCachedMisconfiguredHosts() {
        long l = System.currentTimeMillis();
        if (l - timeStampLastStaleCheck < MAX_AGE_MISCONFIGURED_HOST_IN_MS) {
            return;
        }
        timeStampLastStaleCheck = l;
        MapIterator mapIterator = misconfiguredHosts.mapIterator();
        while (mapIterator.hasNext()) {
            mapIterator.next();
            MisconfiguredHostCacheEntry misconfiguredHostCacheEntry = (MisconfiguredHostCacheEntry)mapIterator.getValue();
            if (!misconfiguredHostCacheEntry.isStale(l)) continue;
            logger.info((Object)("Removing stale cached address of misconfigured (\"unrecognized_name\") host [host=" + misconfiguredHostCacheEntry.getHost() + ", port=" + misconfiguredHostCacheEntry.getPort() + "], following connections will be attempted with the hostname."));
            mapIterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress getCachedMisconfiguredHost(String string, int n) {
        LRUMap lRUMap = misconfiguredHosts;
        synchronized (lRUMap) {
            if (misconfiguredHosts.isEmpty()) {
                return null;
            }
            SSLConnector.removeStaleCachedMisconfiguredHosts();
            MisconfiguredHostCacheEntry misconfiguredHostCacheEntry = (MisconfiguredHostCacheEntry)misconfiguredHosts.get((Object)(string + n));
            if (misconfiguredHostCacheEntry != null) {
                return misconfiguredHostCacheEntry.getAddress();
            }
            return null;
        }
    }

    @Deprecated
    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        throw new UnsupportedOperationException("Method no longer supported since it's no longer required/called by Commons HttpClient library (version >= 3.0).");
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        InetAddress inetAddress = SSLConnector.getCachedMisconfiguredHost(string, n);
        if (inetAddress != null) {
            return this.clientSSLSockFactory.createSocket(socket, inetAddress.getHostAddress(), n, bl);
        }
        try {
            SSLSocket sSLSocket = (SSLSocket)this.clientSSLSockFactory.createSocket(socket, string, n, bl);
            sSLSocket.startHandshake();
            return sSLSocket;
        }
        catch (SSLException sSLException) {
            if (sSLException.getMessage().contains(CONTENTS_UNRECOGNIZED_NAME_EXCEPTION)) {
                SSLConnector.cacheMisconfiguredHost(string, n, InetAddress.getByName(string));
            }
            throw sSLException;
        }
    }

    public Socket createTunnelServerSocket(String string, Socket socket) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)this.getTunnelSSLSocketFactory(string).createSocket(socket, socket.getInetAddress().getHostAddress(), socket.getPort(), true);
        sSLSocket.setUseClientMode(false);
        sSLSocket.startHandshake();
        return sSLSocket;
    }

    public SSLSocketFactory getTunnelSSLSocketFactory(String string) {
        try {
            SSLContext sSLContext = SSLContext.getInstance(SSL);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            SslCertificateService sslCertificateService = CachedSslCertifificateServiceImpl.getService();
            KeyStore keyStore = sslCertificateService.createCertForHost(string);
            keyManagerFactory.init(keyStore, SslCertificateService.PASSPHRASE);
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.setSeed(System.currentTimeMillis());
            sSLContext.init(keyManagerFactory.getKeyManagers(), null, secureRandom);
            SSLSocketFactory sSLSocketFactory = SSLConnector.createDecoratedServerSslSocketFactory(sSLContext.getSocketFactory());
            return sSLSocketFactory;
        }
        catch (IOException | InvalidKeyException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | UnrecoverableKeyException | CertificateException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static SSLSocketFactory createDecoratedServerSslSocketFactory(SSLSocketFactory sSLSocketFactory) {
        return new DecoratedSocketsSslSocketFactory(sSLSocketFactory, serverSslSocketsDecorator);
    }

    private static SSLSocketFactory createDecoratedClientSslSocketFactory(SSLSocketFactory sSLSocketFactory) {
        return new DecoratedSocketsSslSocketFactory(sSLSocketFactory, clientSslSocketsDecorator);
    }

    static {
        MAX_AGE_MISCONFIGURED_HOST_IN_MIN = 5L;
        MAX_AGE_MISCONFIGURED_HOST_IN_MS = TimeUnit.MINUTES.toMillis(MAX_AGE_MISCONFIGURED_HOST_IN_MIN);
        logger = Logger.getLogger(SSLConnector.class);
        sslContextManager = null;
    }

    private static class MisconfiguredHostCacheEntry {
        private final String host;
        private final int port;
        private final InetAddress address;
        private final long timeStampCreation;

        public MisconfiguredHostCacheEntry(String string, int n, InetAddress inetAddress) {
            this.host = string;
            this.port = n;
            this.address = inetAddress;
            this.timeStampCreation = System.currentTimeMillis();
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public InetAddress getAddress() {
            return this.address;
        }

        public boolean isStale(long l) {
            return l - this.timeStampCreation >= MAX_AGE_MISCONFIGURED_HOST_IN_MS;
        }
    }

    private static class ClientSslSocketsDecorator
    implements DecoratedSocketsSslSocketFactory.SslSocketDecorator {
        private ClientSslSocketsDecorator() {
        }

        @Override
        public void decorate(SSLSocket sSLSocket) {
            if (supportedProtocols == null) {
                SSLConnector.readSupportedProtocols(sSLSocket);
            }
            sSLSocket.setEnabledProtocols(SSLConnector.getClientEnabledProtocols());
        }
    }

    private static class ServerSslSocketsDecorator
    implements DecoratedSocketsSslSocketFactory.SslSocketDecorator {
        private ServerSslSocketsDecorator() {
        }

        @Override
        public void decorate(SSLSocket sSLSocket) {
            if (supportedProtocols == null) {
                SSLConnector.readSupportedProtocols(sSLSocket);
            }
            sSLSocket.setEnabledProtocols(SSLConnector.getServerEnabledProtocols());
        }
    }
}

