/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.extension.AbstractDialog;
import org.zaproxy.zap.extension.ascan.ActiveScan;
import org.zaproxy.zap.extension.ascan.ScanProgressActionIcon;
import org.zaproxy.zap.extension.ascan.ScanProgressItem;
import org.zaproxy.zap.extension.ascan.ScanProgressTableModel;
import org.zaproxy.zap.view.LayoutHelper;

public class ScanProgressDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private transient Color JTABLE_ALTERNATE_BACKGROUND = (Color)LookAndFeel.getDesktopPropertyValue("Table.alternateRowColor", new Color(0xF2F2F2));
    private JScrollPane jScrollPane = null;
    private JTable table;
    private ScanProgressTableModel model;
    private JButton closeButton = null;
    private JComboBox<String> hostSelect = null;
    private String site = null;
    private ActiveScan scan = null;
    private boolean stopThread = false;

    public ScanProgressDialog(Frame frame, String string) {
        super(frame, false);
        this.site = string;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(560, 504));
        if (this.site != null) {
            this.setTitle(MessageFormat.format(Constant.messages.getString("ascan.progress.title"), this.site));
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(Constant.messages.getString("ascan.progress.label.host")), LayoutHelper.getGBC(0, 0, 1, 0.4));
        jPanel.add(this.getHostSelect(), LayoutHelper.getGBC(1, 0, 1, 0.6));
        this.add((Component)jPanel, LayoutHelper.getGBC(0, 0, 3, 1.0, 0.0));
        this.add((Component)this.getJScrollPane(), LayoutHelper.getGBC(0, 1, 3, 1.0, 1.0));
        this.add((Component)new JLabel(), LayoutHelper.getGBC(0, 1, 1, 1.0, 0.0));
        this.add((Component)this.getCloseButton(), LayoutHelper.getGBC(1, 2, 1, 0.0, 0.0));
        this.add((Component)new JLabel(), LayoutHelper.getGBC(2, 1, 1, 1.0, 0.0));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                ScanProgressDialog.this.stopThread = true;
            }
        });
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getMainPanel());
            this.jScrollPane.setName("ScanProgressScrollPane");
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setVerticalScrollBarPolicy(20);
        }
        return this.jScrollPane;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton(Constant.messages.getString("all.button.close"));
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScanProgressDialog.this.dispatchEvent(new WindowEvent(ScanProgressDialog.this, 201));
                }
            });
        }
        return this.closeButton;
    }

    private JTable getMainPanel() {
        if (this.table == null) {
            this.model = new ScanProgressTableModel();
            this.table = new JTable();
            this.table.setModel(this.model);
            this.table.setRowSelectionAllowed(false);
            this.table.setColumnSelectionAllowed(false);
            this.table.setDoubleBuffered(true);
            this.table.getColumnModel().getColumn(0).setPreferredWidth(256);
            this.table.getColumnModel().getColumn(1).setPreferredWidth(80);
            this.table.getColumnModel().getColumn(2).setPreferredWidth(80);
            this.table.getColumnModel().getColumn(2).setCellRenderer(new ScanProgressBarRenderer());
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            defaultTableCellRenderer.setHorizontalAlignment(0);
            this.table.getColumnModel().getColumn(3).setPreferredWidth(80);
            this.table.getColumnModel().getColumn(3).setCellRenderer(defaultTableCellRenderer);
            this.table.getColumnModel().getColumn(4).setPreferredWidth(40);
            this.table.getColumnModel().getColumn(4).setCellRenderer(new ScanProgressActionRenderer());
            ScanProgressActionListener scanProgressActionListener = new ScanProgressActionListener(this.table);
            this.table.addMouseListener(scanProgressActionListener);
            this.table.addMouseMotionListener(scanProgressActionListener);
        }
        return this.table;
    }

    private void showProgress() {
        HostProcess hostProcess = this.getSelectedHostProcess();
        if (this.scan.getHostProcesses() != null && hostProcess != null) {
            this.model.updateValues(this.scan, hostProcess);
            if (this.scan.isStopped()) {
                this.stopThread = true;
            }
        }
    }

    private HostProcess getSelectedHostProcess() {
        String string = (String)this.getHostSelect().getSelectedItem();
        if (string == null) {
            return null;
        }
        for (HostProcess hostProcess : this.scan.getHostProcesses()) {
            if (!string.equals(hostProcess.getHostAndPort())) continue;
            return hostProcess;
        }
        return null;
    }

    public void setActiveScan(ActiveScan activeScan) {
        this.scan = activeScan;
        if (activeScan == null) {
            return;
        }
        this.getHostSelect().removeAll();
        for (HostProcess hostProcess : activeScan.getHostProcesses()) {
            this.getHostSelect().addItem(hostProcess.getHostAndPort());
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (!ScanProgressDialog.this.stopThread) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ScanProgressDialog.this.showProgress();
                        }
                    });
                    try {
                        3.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        thread.start();
    }

    private JComboBox<String> getHostSelect() {
        if (this.hostSelect == null) {
            this.hostSelect = new JComboBox();
            this.hostSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScanProgressDialog.this.showProgress();
                }
            });
        }
        return this.hostSelect;
    }

    private class ScanProgressActionListener
    implements MouseListener,
    MouseMotionListener {
        private JTable table;

        public ScanProgressActionListener(JTable jTable) {
            this.table = jTable;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ScanProgressActionIcon scanProgressActionIcon = this.getScanProgressAction(mouseEvent);
            if (scanProgressActionIcon != null) {
                scanProgressActionIcon.invokeAction();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ScanProgressActionIcon scanProgressActionIcon = this.getScanProgressAction(mouseEvent);
            if (scanProgressActionIcon != null) {
                scanProgressActionIcon.setPressed();
                scanProgressActionIcon.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ScanProgressActionIcon scanProgressActionIcon = this.getScanProgressAction(mouseEvent);
            if (scanProgressActionIcon != null) {
                scanProgressActionIcon.setReleased();
                scanProgressActionIcon.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            ScanProgressActionIcon scanProgressActionIcon = this.getScanProgressAction(mouseEvent);
            if (scanProgressActionIcon != null) {
                ScanProgressDialog.this.model.setFocusedAction(scanProgressActionIcon);
                scanProgressActionIcon.repaint();
            } else if (ScanProgressDialog.this.model.getFocusedAction() != null) {
                ScanProgressDialog.this.model.setFocusedAction(scanProgressActionIcon);
                this.table.repaint();
            }
        }

        private ScanProgressActionIcon getScanProgressAction(MouseEvent mouseEvent) {
            Object object;
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = mouseEvent.getY() / this.table.getRowHeight();
            if (n2 < this.table.getRowCount() && n2 >= 0 && n < this.table.getColumnCount() && n >= 0 && (object = this.table.getValueAt(n2, n)) instanceof ScanProgressActionIcon) {
                return (ScanProgressActionIcon)object;
            }
            return null;
        }
    }

    private class ScanProgressActionRenderer
    implements TableCellRenderer {
        private ScanProgressActionRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent;
            if (object != null) {
                ScanProgressActionIcon scanProgressActionIcon = (ScanProgressActionIcon)object;
                if (scanProgressActionIcon == ScanProgressDialog.this.model.getFocusedAction()) {
                    scanProgressActionIcon.setOver();
                } else {
                    scanProgressActionIcon.setNormal();
                }
                jComponent = scanProgressActionIcon;
            } else {
                jComponent = (JComponent)Box.createGlue();
            }
            jComponent.setOpaque(true);
            jComponent.setBackground(ScanProgressDialog.this.JTABLE_ALTERNATE_BACKGROUND);
            return jComponent;
        }
    }

    private class ScanProgressBarRenderer
    implements TableCellRenderer {
        private ScanProgressBarRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent;
            if (object != null) {
                ScanProgressItem scanProgressItem = (ScanProgressItem)object;
                JProgressBar jProgressBar = new JProgressBar();
                jProgressBar.setMaximum(100);
                jProgressBar.setValue(scanProgressItem.getProgressPercentage());
                jComponent = jProgressBar;
            } else {
                jComponent = (JComponent)Box.createGlue();
            }
            jComponent.setOpaque(true);
            jComponent.setBackground(ScanProgressDialog.this.JTABLE_ALTERNATE_BACKGROUND);
            return jComponent;
        }
    }
}

