/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.component.all.request;

import java.awt.BorderLayout;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.apache.commons.configuration.FileConfiguration;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.component.HttpPanelComponentInterface;
import org.zaproxy.zap.extension.httppanel.component.HttpPanelComponentViewsManager;
import org.zaproxy.zap.extension.httppanel.component.all.request.HttpRequestAllPanelTextView;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelDefaultViewSelector;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.request.RequestStringHttpPanelViewModel;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.extension.search.SearchableHttpPanelComponent;
import org.zaproxy.zap.model.HttpMessageLocation;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlighter;

public class RequestAllComponent
implements HttpPanelComponentInterface,
SearchableHttpPanelComponent,
MessageLocationHighlighter {
    public static final String NAME = "RequestAll";
    private static final String BUTTON_TOOL_TIP = Constant.messages.getString("http.panel.component.all.tooltip");
    protected JToggleButton buttonShowView;
    protected JPanel panelOptions;
    protected JPanel panelMain;
    protected Message message = null;
    protected HttpPanelComponentViewsManager views = new HttpPanelComponentViewsManager("all");

    public RequestAllComponent() {
        this.initUi();
    }

    protected void initUi() {
        this.buttonShowView = new JToggleButton(new ImageIcon(RequestAllComponent.class.getResource("/resource/icon/view_all.png")));
        this.buttonShowView.setToolTipText(BUTTON_TOOL_TIP);
        this.panelOptions = new JPanel();
        this.panelOptions.add(this.views.getSelectableViewsComponent());
        this.initViews();
        this.panelMain = new JPanel(new BorderLayout());
        this.panelMain.add(this.views.getViewsPanel());
        this.setSelected(false);
    }

    @Override
    public void setParentConfigurationKey(String string) {
        this.views.setConfigurationKey(string);
    }

    @Override
    public JToggleButton getButton() {
        return this.buttonShowView;
    }

    @Override
    public JPanel getOptionsPanel() {
        return this.panelOptions;
    }

    @Override
    public JPanel getMoreOptionsPanel() {
        return null;
    }

    @Override
    public JPanel getMainPanel() {
        return this.panelMain;
    }

    @Override
    public void setSelected(boolean bl) {
        this.buttonShowView.setSelected(bl);
        this.views.setSelected(bl);
    }

    @Override
    public boolean isEnabled(Message message) {
        if (message == null) {
            return true;
        }
        return message instanceof HttpMessage;
    }

    protected void initViews() {
        this.views.addView(new HttpRequestAllPanelTextView(new RequestStringHttpPanelViewModel()));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPosition() {
        return 2;
    }

    @Override
    public void setMessage(Message message) {
        this.message = message;
        this.views.setMessage(this.message);
    }

    @Override
    public void save() {
        if (this.message == null) {
            return;
        }
        this.views.save();
    }

    @Override
    public void addView(HttpPanelView httpPanelView, Object object, FileConfiguration fileConfiguration) {
        this.views.addView(httpPanelView, fileConfiguration);
    }

    @Override
    public void removeView(String string, Object object) {
        this.views.removeView(string);
    }

    @Override
    public void clearView() {
        this.views.clearView();
    }

    @Override
    public void clearView(boolean bl) {
        this.views.clearView();
        this.setEnableViewSelect(bl);
    }

    @Override
    public void setEnableViewSelect(boolean bl) {
        this.views.setEnableViewSelect(bl);
    }

    @Override
    public void addDefaultViewSelector(HttpPanelDefaultViewSelector httpPanelDefaultViewSelector, Object object) {
        this.views.addDefaultViewSelector(httpPanelDefaultViewSelector);
    }

    @Override
    public void removeDefaultViewSelector(String string, Object object) {
        this.views.removeDefaultViewSelector(string);
    }

    @Override
    public void loadConfig(FileConfiguration fileConfiguration) {
        this.views.loadConfig(fileConfiguration);
    }

    @Override
    public void saveConfig(FileConfiguration fileConfiguration) {
        this.views.saveConfig(fileConfiguration);
    }

    @Override
    public void setEditable(boolean bl) {
        this.views.setEditable(bl);
    }

    @Override
    public void highlightHeader(SearchMatch searchMatch) {
        this.views.highlight(searchMatch);
    }

    @Override
    public void highlightBody(SearchMatch searchMatch) {
        this.views.highlight(searchMatch);
    }

    @Override
    public void searchHeader(Pattern pattern, List<SearchMatch> list) {
        this.views.search(pattern, list);
    }

    @Override
    public void searchBody(Pattern pattern, List<SearchMatch> list) {
        this.views.search(pattern, list);
    }

    @Override
    public boolean supports(MessageLocation messageLocation) {
        if (!(messageLocation instanceof HttpMessageLocation)) {
            return false;
        }
        HttpMessageLocation httpMessageLocation = (HttpMessageLocation)messageLocation;
        switch (httpMessageLocation.getLocation()) {
            case REQUEST_HEADER: 
            case RESPONSE_HEADER: 
            case REQUEST_BODY: 
            case RESPONSE_BODY: {
                return this.views.supports(httpMessageLocation);
            }
        }
        return false;
    }

    @Override
    public boolean supports(Class<? extends MessageLocation> clazz) {
        return !HttpMessageLocation.class.isAssignableFrom(clazz);
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation messageLocation) {
        if (!(messageLocation instanceof HttpMessageLocation)) {
            return null;
        }
        HttpMessageLocation httpMessageLocation = (HttpMessageLocation)messageLocation;
        switch (httpMessageLocation.getLocation()) {
            case REQUEST_HEADER: 
            case RESPONSE_HEADER: 
            case REQUEST_BODY: 
            case RESPONSE_BODY: {
                return this.views.highlight(httpMessageLocation);
            }
        }
        return null;
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation messageLocation, MessageLocationHighlight messageLocationHighlight) {
        if (!(messageLocation instanceof HttpMessageLocation)) {
            return null;
        }
        HttpMessageLocation httpMessageLocation = (HttpMessageLocation)messageLocation;
        switch (httpMessageLocation.getLocation()) {
            case REQUEST_HEADER: 
            case RESPONSE_HEADER: 
            case REQUEST_BODY: 
            case RESPONSE_BODY: {
                return this.views.highlight(httpMessageLocation, messageLocationHighlight);
            }
        }
        return null;
    }

    @Override
    public void removeHighlight(MessageLocation messageLocation, MessageLocationHighlight messageLocationHighlight) {
        if (!(messageLocation instanceof HttpMessageLocation)) {
            return;
        }
        HttpMessageLocation httpMessageLocation = (HttpMessageLocation)messageLocation;
        switch (httpMessageLocation.getLocation()) {
            case REQUEST_HEADER: 
            case RESPONSE_HEADER: 
            case REQUEST_BODY: 
            case RESPONSE_BODY: {
                this.views.removeHighlight(httpMessageLocation, messageLocationHighlight);
                break;
            }
        }
    }

    @Override
    public HttpPanelView setSelectedView(String string) {
        return this.views.setSelectedView(string);
    }
}

