/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.extension.spider.OptionsSpiderPanel;
import org.zaproxy.zap.extension.spider.SpiderAPI;
import org.zaproxy.zap.extension.spider.SpiderDialog;
import org.zaproxy.zap.extension.spider.SpiderPanel;
import org.zaproxy.zap.extension.spider.SpiderScan;
import org.zaproxy.zap.extension.spider.SpiderScanController;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ScanController;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.filters.FetchFilter;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionSpider
extends ExtensionAdaptor
implements SessionChangedListener,
ScanController<SpiderScan> {
    public static final int EXTENSION_ORDER = 30;
    private static final Logger log = Logger.getLogger(ExtensionSpider.class);
    public static final String NAME = "ExtensionSpider";
    private SpiderPanel spiderPanel = null;
    SpiderDialog spiderDialog = null;
    private OptionsSpiderPanel optionsSpiderPanel = null;
    private SpiderParam params = null;
    private List<SpiderParser> customParsers;
    private List<FetchFilter> customFetchFilters;
    private List<ParseFilter> customParseFilters;
    private SpiderAPI spiderApi;
    private SpiderScanController scanController = null;
    private List<String> excludeList = null;
    private ZapMenuItem menuItemCustomScan = null;

    public ExtensionSpider() {
        super(NAME);
        this.initialize();
    }

    public ExtensionSpider(String string) {
        super(string);
    }

    private void initialize() {
        this.setOrder(30);
        this.customParsers = new LinkedList<SpiderParser>();
        this.customFetchFilters = new LinkedList<FetchFilter>();
        this.customParseFilters = new LinkedList<ParseFilter>();
        this.scanController = new SpiderScanController(this);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addSessionListener(this);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuItemCustomScan());
            extensionHook.getHookView().addStatusPanel(this.getSpiderPanel());
            extensionHook.getHookView().addOptionPanel(this.getOptionsSpiderPanel());
            ExtensionHelp.enableHelpKey(this.getSpiderPanel(), "ui.tabs.spider");
        }
        extensionHook.addOptionsParamSet(this.getSpiderParam());
        this.spiderApi = new SpiderAPI(this);
        this.spiderApi.addApiOptions(this.getSpiderParam());
        API.getInstance().registerApiImplementor(this.spiderApi);
    }

    @Override
    public List<String> getActiveActions() {
        List<SpiderScan> list = this.scanController.getActiveScans();
        if (list.isEmpty()) {
            return null;
        }
        String string = Constant.messages.getString("spider.activeActionPrefix");
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (SpiderScan spiderScan : list) {
            arrayList.add(MessageFormat.format(string, spiderScan.getDisplayName()));
        }
        return arrayList;
    }

    protected SpiderParam getSpiderParam() {
        if (this.params == null) {
            this.params = new SpiderParam();
        }
        return this.params;
    }

    protected SpiderPanel getSpiderPanel() {
        if (this.spiderPanel == null) {
            this.spiderPanel = new SpiderPanel(this, this.getSpiderParam());
        }
        return this.spiderPanel;
    }

    @Override
    public void sessionAboutToChange(Session session) {
        this.scanController.reset();
        if (View.isInitialised()) {
            this.getSpiderPanel().reset();
        }
    }

    @Override
    public void sessionChanged(final Session session) {
        if (EventQueue.isDispatchThread()) {
            this.sessionChangedEventHandler(session);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionSpider.this.sessionChangedEventHandler(session);
                    }
                });
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void sessionChangedEventHandler(Session session) {
        if (View.isInitialised()) {
            this.getSpiderPanel().reset();
        }
        if (session == null) {
            return;
        }
    }

    private OptionsSpiderPanel getOptionsSpiderPanel() {
        if (this.optionsSpiderPanel == null) {
            this.optionsSpiderPanel = new OptionsSpiderPanel();
        }
        return this.optionsSpiderPanel;
    }

    public void setExcludeList(List<String> list) {
        this.excludeList = list;
    }

    public List<String> getExcludeList() {
        return this.excludeList;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("spider.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public void sessionScopeChanged(Session session) {
        if (View.isInitialised()) {
            this.getSpiderPanel().sessionScopeChanged(session);
        }
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
        if (View.isInitialised()) {
            this.getSpiderPanel().sessionModeChanged(mode);
        }
    }

    public void startScanNode(SiteNode siteNode) {
        Target target = new Target(siteNode);
        target.setRecurse(true);
        this.startScan(target.getDisplayName(), target, null, null);
    }

    public void startScanNode(SiteNode siteNode, User user) {
        Target target = new Target(siteNode);
        target.setRecurse(true);
        this.startScan(target.getDisplayName(), target, user, null);
    }

    public void startScanAllInScope() {
        Target target = new Target(true);
        target.setRecurse(true);
        this.startScan(target.getDisplayName(), target, null, null);
    }

    public void startScan(SiteNode siteNode) {
        Target target = new Target(siteNode);
        target.setRecurse(true);
        this.startScan(target.getDisplayName(), target, null, null);
    }

    public void startScanAllInContext(Context context, User user) {
        Target target = new Target(context);
        target.setRecurse(true);
        this.startScan(target.getDisplayName(), target, user, null);
    }

    @Override
    public void destroy() {
        this.stopAllScans();
        if (View.isInitialised()) {
            this.getSpiderPanel().reset();
        }
    }

    public List<SpiderParser> getCustomParsers() {
        return this.customParsers;
    }

    public List<FetchFilter> getCustomFetchFilters() {
        return this.customFetchFilters;
    }

    public List<ParseFilter> getCustomParseFilters() {
        return this.customParseFilters;
    }

    public void addCustomParser(SpiderParser spiderParser) {
        this.customParsers.add(spiderParser);
    }

    public void addCustomFetchFilter(FetchFilter fetchFilter) {
        this.customFetchFilters.add(fetchFilter);
    }

    public void addCustomParseFilter(ParseFilter parseFilter) {
        this.customParseFilters.add(parseFilter);
    }

    @Override
    public int startScan(String string, Target target, User user, Object[] objectArray) {
        int n = this.scanController.startScan(string, target, user, objectArray);
        if (View.isInitialised()) {
            SpiderScan spiderScan = this.scanController.getScan(n);
            this.getSpiderPanel().scannerStarted(spiderScan);
            spiderScan.setListener(this.getSpiderPanel());
            this.getSpiderPanel().switchView(spiderScan);
            this.getSpiderPanel().setTabFocus();
        }
        return n;
    }

    @Override
    public List<SpiderScan> getAllScans() {
        return this.scanController.getAllScans();
    }

    @Override
    public List<SpiderScan> getActiveScans() {
        return this.scanController.getActiveScans();
    }

    @Override
    public SpiderScan getScan(int n) {
        return this.scanController.getScan(n);
    }

    @Override
    public void stopScan(int n) {
        this.scanController.stopScan(n);
    }

    @Override
    public void stopAllScans() {
        this.scanController.stopAllScans();
    }

    @Override
    public void pauseScan(int n) {
        this.scanController.pauseScan(n);
        if (View.isInitialised()) {
            this.getSpiderPanel().updateScannerUI();
        }
    }

    @Override
    public void pauseAllScans() {
        this.scanController.pauseAllScans();
        if (View.isInitialised()) {
            this.getSpiderPanel().updateScannerUI();
        }
    }

    @Override
    public void resumeScan(int n) {
        this.scanController.resumeScan(n);
        if (View.isInitialised()) {
            this.getSpiderPanel().updateScannerUI();
        }
    }

    @Override
    public void resumeAllScans() {
        this.scanController.resumeAllScans();
        if (View.isInitialised()) {
            this.getSpiderPanel().updateScannerUI();
        }
    }

    @Override
    public SpiderScan removeScan(int n) {
        return this.scanController.removeScan(n);
    }

    @Override
    public int removeAllScans() {
        return this.scanController.removeAllScans();
    }

    @Override
    public int removeFinishedScans() {
        return this.scanController.removeFinishedScans();
    }

    @Override
    public SpiderScan getLastScan() {
        return this.scanController.getLastScan();
    }

    private ZapMenuItem getMenuItemCustomScan() {
        if (this.menuItemCustomScan == null) {
            this.menuItemCustomScan = new ZapMenuItem("menu.tools.spider", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8, false));
            this.menuItemCustomScan.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionSpider.this.showSpiderDialog(null);
                }
            });
        }
        return this.menuItemCustomScan;
    }

    public void showSpiderDialog(SiteNode siteNode) {
        if (this.spiderDialog == null) {
            this.spiderDialog = new SpiderDialog(this, View.getSingleton().getMainFrame(), new Dimension(700, 400));
        }
        if (this.spiderDialog.isVisible()) {
            this.spiderDialog.toFront();
            return;
        }
        if (siteNode != null) {
            this.spiderDialog.init(new Target(siteNode));
        } else {
            this.spiderDialog.init(null);
        }
        this.spiderDialog.setVisible(true);
    }

    @Override
    public boolean supportsLowMemory() {
        return true;
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }
}

