/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.stdmenus;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.stdmenus.PopupContextTreeMenu;
import org.zaproxy.zap.extension.stdmenus.PopupCopyMenu;
import org.zaproxy.zap.extension.stdmenus.PopupExcludeFromProxyMenu;
import org.zaproxy.zap.extension.stdmenus.PopupExcludeFromScanMenu;
import org.zaproxy.zap.extension.stdmenus.PopupExcludeFromSpiderMenu;
import org.zaproxy.zap.extension.stdmenus.PopupMenuActiveScanCustom;
import org.zaproxy.zap.extension.stdmenus.PopupMenuAlert;
import org.zaproxy.zap.extension.stdmenus.PopupMenuCopyUrls;
import org.zaproxy.zap.extension.stdmenus.PopupMenuOpenUrlInBrowser;
import org.zaproxy.zap.extension.stdmenus.PopupMenuResendMessage;
import org.zaproxy.zap.extension.stdmenus.PopupMenuShowInHistory;
import org.zaproxy.zap.extension.stdmenus.PopupMenuShowInSites;
import org.zaproxy.zap.extension.stdmenus.PopupMenuSpiderDialog;
import org.zaproxy.zap.extension.stdmenus.PopupPasteMenu;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.view.popup.PopupMenuItemContextExclude;
import org.zaproxy.zap.view.popup.PopupMenuItemContextInclude;

public class ExtensionStdMenus
extends ExtensionAdaptor
implements ClipboardOwner {
    public static final String NAME = "ExtensionStandardMenus";
    private PopupCopyMenu popupCopyMenu = null;
    private PopupPasteMenu popupPaste = null;
    private PopupMenuActiveScanCustom popupMenuActiveScanCustom = null;
    private PopupMenuSpiderDialog popupMenuSpiderDialog = null;
    private PopupExcludeFromProxyMenu popupExcludeFromProxyMenu = null;
    private PopupExcludeFromScanMenu popupExcludeFromScanMenu = null;
    private PopupExcludeFromSpiderMenu popupExcludeFromSpiderMenu = null;
    private PopupMenuResendMessage popupMenuResendMessage = null;
    private PopupMenuShowInHistory popupMenuShowInHistory = null;
    private PopupMenuShowInSites popupMenuShowInSites = null;
    private PopupMenuOpenUrlInBrowser popupMenuOpenUrlInBrowser = null;
    private PopupMenuItemContextInclude popupContextIncludeMenu = null;
    private PopupMenuItemContextExclude popupContextExcludeMenu = null;
    private PopupMenuCopyUrls popupMenuCopyUrls = null;
    private PopupContextTreeMenu popupContextTreeMenuInScope = null;
    private PopupContextTreeMenu popupContextTreeMenuOutScope = null;
    private PopupContextTreeMenu popupContextTreeMenuDelete = null;
    private PopupMenuAlert popupMenuAlert = null;
    private static Logger log = Logger.getLogger(ExtensionStdMenus.class);

    public ExtensionStdMenus() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(31);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuCopy());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuPaste());
            ExtensionLoader extensionLoader = Control.getSingleton().getExtensionLoader();
            boolean bl = extensionLoader.isExtensionEnabled("ExtensionHistory");
            boolean bl2 = extensionLoader.isExtensionEnabled("ExtensionActiveScan");
            boolean bl3 = extensionLoader.isExtensionEnabled("ExtensionSpider");
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupExcludeFromProxyMenu(0));
            if (bl2) {
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupExcludeFromScanMenu(0));
            }
            if (bl3) {
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupExcludeFromSpiderMenu(0));
            }
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupContextIncludeMenu(1));
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupContextExcludeMenu(2));
            if (bl2) {
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuActiveScanCustom(3));
            }
            if (bl3) {
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuSpiderDialog(3));
            }
            if (bl) {
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuResendMessage(4));
            }
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuAlert(5));
            if (bl) {
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuShowInHistory(6));
            }
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuShowInSites(6));
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuOpenUrlInBrowser(7));
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuCopyUrls(8));
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupContextTreeMenuInScope());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupContextTreeMenuOutScope());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupContextTreeMenuDelete());
        }
    }

    private PopupContextTreeMenu getPopupContextTreeMenuInScope() {
        if (this.popupContextTreeMenuInScope == null) {
            this.popupContextTreeMenuInScope = new PopupContextTreeMenu(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isEnabledForContext(int n) {
                    Context context = Model.getSingleton().getSession().getContext(n);
                    return context != null && !context.isInScope();
                }
            };
            this.popupContextTreeMenuInScope.setText(Constant.messages.getString("context.inscope.popup"));
            this.popupContextTreeMenuInScope.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Context context = Model.getSingleton().getSession().getContext(ExtensionStdMenus.this.popupContextTreeMenuOutScope.getContextId());
                    context.setInScope(true);
                    Model.getSingleton().getSession().saveContext(context);
                }
            });
        }
        return this.popupContextTreeMenuInScope;
    }

    private PopupContextTreeMenu getPopupContextTreeMenuOutScope() {
        if (this.popupContextTreeMenuOutScope == null) {
            this.popupContextTreeMenuOutScope = new PopupContextTreeMenu(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isEnabledForContext(int n) {
                    Context context = Model.getSingleton().getSession().getContext(n);
                    return context != null && context.isInScope();
                }
            };
            this.popupContextTreeMenuOutScope.setText(Constant.messages.getString("context.outscope.popup"));
            this.popupContextTreeMenuOutScope.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Context context = Model.getSingleton().getSession().getContext(ExtensionStdMenus.this.popupContextTreeMenuOutScope.getContextId());
                    context.setInScope(false);
                    Model.getSingleton().getSession().saveContext(context);
                }
            });
        }
        return this.popupContextTreeMenuOutScope;
    }

    private PopupContextTreeMenu getPopupContextTreeMenuDelete() {
        if (this.popupContextTreeMenuDelete == null) {
            this.popupContextTreeMenuDelete = new PopupContextTreeMenu();
            this.popupContextTreeMenuDelete.setText(Constant.messages.getString("context.delete.popup"));
            this.popupContextTreeMenuDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Context context = Model.getSingleton().getSession().getContext(ExtensionStdMenus.this.popupContextTreeMenuOutScope.getContextId());
                    if (View.getSingleton().showConfirmDialog(Constant.messages.getString("context.delete.warning")) == 0) {
                        Model.getSingleton().getSession().deleteContext(context);
                    }
                }
            });
        }
        return this.popupContextTreeMenuDelete;
    }

    private PopupCopyMenu getPopupMenuCopy() {
        if (this.popupCopyMenu == null) {
            this.popupCopyMenu = new PopupCopyMenu();
            this.popupCopyMenu.setText(Constant.messages.getString("copy.copy.popup"));
            this.popupCopyMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionStdMenus.this.setClipboardContents(ExtensionStdMenus.this.popupCopyMenu.getLastInvoker().getSelectedText());
                }
            });
        }
        return this.popupCopyMenu;
    }

    private PopupPasteMenu getPopupMenuPaste() {
        if (this.popupPaste == null) {
            this.popupPaste = new PopupPasteMenu();
            this.popupPaste.setText(Constant.messages.getString("paste.paste.popup"));
            this.popupPaste.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionStdMenus.this.popupPaste.getLastInvoker().setText(ExtensionStdMenus.this.popupPaste.getLastInvoker().getText() + ExtensionStdMenus.this.getClipboardContents());
                }
            });
        }
        return this.popupPaste;
    }

    private String getClipboardContents() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException exception) {
                log.error((Object)"Unable to get data from clipboard");
            }
        }
        return "";
    }

    private void setClipboardContents(String string) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(string), this);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private PopupMenuSpiderDialog getPopupMenuSpiderDialog(int n) {
        if (this.popupMenuSpiderDialog == null) {
            this.popupMenuSpiderDialog = new PopupMenuSpiderDialog(Constant.messages.getString("spider.custom.popup"));
        }
        return this.popupMenuSpiderDialog;
    }

    private PopupMenuActiveScanCustom getPopupMenuActiveScanCustom(int n) {
        if (this.popupMenuActiveScanCustom == null) {
            this.popupMenuActiveScanCustom = new PopupMenuActiveScanCustom(Constant.messages.getString("ascan.custom.popup"));
        }
        return this.popupMenuActiveScanCustom;
    }

    private PopupMenuOpenUrlInBrowser getPopupMenuOpenUrlInBrowser(int n) {
        if (this.popupMenuOpenUrlInBrowser == null) {
            this.popupMenuOpenUrlInBrowser = new PopupMenuOpenUrlInBrowser(Constant.messages.getString("history.browser.popup"));
            this.popupMenuOpenUrlInBrowser.setMenuIndex(n);
        }
        return this.popupMenuOpenUrlInBrowser;
    }

    private PopupMenuCopyUrls getPopupMenuCopyUrls(int n) {
        if (this.popupMenuCopyUrls == null) {
            this.popupMenuCopyUrls = new PopupMenuCopyUrls(Constant.messages.getString("stdexts.copyurls.popup"));
            this.popupMenuCopyUrls.setMenuIndex(n);
        }
        return this.popupMenuCopyUrls;
    }

    private PopupExcludeFromProxyMenu getPopupExcludeFromProxyMenu(int n) {
        if (this.popupExcludeFromProxyMenu == null) {
            this.popupExcludeFromProxyMenu = new PopupExcludeFromProxyMenu();
            this.popupExcludeFromProxyMenu.setMenuIndex(n);
        }
        return this.popupExcludeFromProxyMenu;
    }

    private PopupExcludeFromScanMenu getPopupExcludeFromScanMenu(int n) {
        if (this.popupExcludeFromScanMenu == null) {
            this.popupExcludeFromScanMenu = new PopupExcludeFromScanMenu();
            this.popupExcludeFromScanMenu.setMenuIndex(n);
        }
        return this.popupExcludeFromScanMenu;
    }

    private PopupExcludeFromSpiderMenu getPopupExcludeFromSpiderMenu(int n) {
        if (this.popupExcludeFromSpiderMenu == null) {
            this.popupExcludeFromSpiderMenu = new PopupExcludeFromSpiderMenu();
            this.popupExcludeFromSpiderMenu.setMenuIndex(n);
        }
        return this.popupExcludeFromSpiderMenu;
    }

    private PopupMenuResendMessage getPopupMenuResendMessage(int n) {
        if (this.popupMenuResendMessage == null) {
            this.popupMenuResendMessage = new PopupMenuResendMessage(Constant.messages.getString("history.resend.popup"), (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory"));
            this.popupMenuResendMessage.setMenuIndex(n);
        }
        return this.popupMenuResendMessage;
    }

    private PopupMenuShowInSites getPopupMenuShowInSites(int n) {
        if (this.popupMenuShowInSites == null) {
            this.popupMenuShowInSites = new PopupMenuShowInSites(Constant.messages.getString("sites.showinsites.popup"));
            this.popupMenuShowInSites.setMenuIndex(n);
        }
        return this.popupMenuShowInSites;
    }

    private PopupMenuShowInHistory getPopupMenuShowInHistory(int n) {
        if (this.popupMenuShowInHistory == null) {
            this.popupMenuShowInHistory = new PopupMenuShowInHistory(Constant.messages.getString("history.showinhistory.popup"), (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory"));
            this.popupMenuShowInHistory.setMenuIndex(n);
        }
        return this.popupMenuShowInHistory;
    }

    private PopupMenuAlert getPopupMenuAlert(int n) {
        if (this.popupMenuAlert == null) {
            this.popupMenuAlert = new PopupMenuAlert(Constant.messages.getString("history.alert.popup"));
            this.popupMenuAlert.setMenuIndex(n);
        }
        return this.popupMenuAlert;
    }

    private PopupMenuItemContextInclude getPopupContextIncludeMenu(int n) {
        if (this.popupContextIncludeMenu == null) {
            this.popupContextIncludeMenu = new PopupMenuItemContextInclude();
            this.popupContextIncludeMenu.setParentMenuIndex(n);
        }
        return this.popupContextIncludeMenu;
    }

    private PopupMenuItemContextExclude getPopupContextExcludeMenu(int n) {
        if (this.popupContextExcludeMenu == null) {
            this.popupContextExcludeMenu = new PopupMenuItemContextExclude();
            this.popupContextExcludeMenu.setParentMenuIndex(n);
        }
        return this.popupContextExcludeMenu;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("stdexts.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }
}

