/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.stdmenus;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.view.SessionExcludeFromScanPanel;
import org.zaproxy.zap.view.popup.PopupMenuItemSiteNodeContainer;

public class PopupExcludeFromScanMenu
extends PopupMenuItemSiteNodeContainer {
    private static final long serialVersionUID = 2282358266003940700L;
    private static final Logger logger = Logger.getLogger(PopupExcludeFromScanMenu.class);

    public PopupExcludeFromScanMenu() {
        super(Constant.messages.getString("sites.exclude.ascan.popup"), true);
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    @Override
    public String getParentMenuName() {
        return Constant.messages.getString("sites.exclude.popup");
    }

    @Override
    public int getParentMenuIndex() {
        return 1;
    }

    @Override
    public void performAction(SiteNode siteNode) {
        String string;
        Session session = Model.getSingleton().getSession();
        try {
            string = new URI(siteNode.getHierarchicNodeName(), false).toString();
        }
        catch (URIException uRIException) {
            logger.error((Object)("Failed to create the URI to exclude from scanner: " + uRIException.getMessage()), (Throwable)uRIException);
            return;
        }
        string = siteNode.isLeaf() ? Pattern.quote(string) : Pattern.quote(string + "/") + ".*";
        session.getExcludeFromScanRegexs().add(string);
    }

    @Override
    public void performHistoryReferenceActions(List<HistoryReference> list) {
        super.performHistoryReferenceActions(list);
        View.getSingleton().showSessionDialog(Model.getSingleton().getSession(), SessionExcludeFromScanPanel.PANEL_NAME);
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

