/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class SingleColumnTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = null;
    private List<String> lines = new ArrayList<String>();
    private boolean editable = true;

    public SingleColumnTableModel(String string) {
        this.columnNames = new String[]{string};
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.lines.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.lines.get(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.editable;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.editable) {
            this.lines.set(n, (String)object);
            this.checkAndAppendNewRow();
            this.fireTableCellUpdated(n, n2);
        }
    }

    public List<String> getLines() {
        ArrayList<String> arrayList = new ArrayList<String>(this.lines);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (!((String)iterator.next()).equals("")) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public void setLines(List<String> list) {
        this.lines = list == null ? new ArrayList<String>() : new ArrayList<String>(list);
        if (this.editable) {
            this.checkAndAppendNewRow();
        }
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    private void checkAndAppendNewRow() {
        String string = null;
        if (this.lines.size() > 0) {
            string = this.lines.get(this.lines.size() - 1);
            if (!string.equals("")) {
                string = "";
                this.lines.add(string);
            }
        } else {
            string = "";
            this.lines.add(string);
        }
    }

    public Class<String> getColumnClass(int n) {
        return String.class;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }
}

