/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.widgets;

import java.awt.Component;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.model.Context;

public class ContextSelectComboBox
extends JComboBox<Context> {
    private static final long serialVersionUID = 6177823947839642740L;

    public ContextSelectComboBox() {
        this.reloadContexts(false);
        this.setRenderer(new ContextComboBoxRenderer());
    }

    public void reloadContexts(boolean bl) {
        Context context = null;
        if (bl) {
            context = (Context)this.getSelectedItem();
        }
        List<Context> list = Model.getSingleton().getSession().getContexts();
        Context[] contextArray = list.toArray(new Context[list.size()]);
        DefaultComboBoxModel<Context> defaultComboBoxModel = new DefaultComboBoxModel<Context>(contextArray);
        defaultComboBoxModel.setSelectedItem(context);
        this.setModel(defaultComboBoxModel);
    }

    public Context getSelectedContext() {
        return (Context)this.getSelectedItem();
    }

    private static class ContextComboBoxRenderer
    extends BasicComboBoxRenderer {
        private static final Border BORDER = new EmptyBorder(2, 8, 2, 8);
        private static final long serialVersionUID = 3272133514462699823L;

        private ContextComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                Context context = (Context)object;
                this.setText(context.getName());
                this.setBorder(BORDER);
            }
            return this;
        }
    }
}

