'''OpenGL extension SGIX.instruments

This module customises the behaviour of the 
OpenGL.raw.GL.SGIX.instruments to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension allows the gathering and return of performance
	measurements from within the graphics pipeline by adding
	instrumentation.
	
	There are two reasons to do this.  The first is as a part of some
	type of fixed-frame-rate load management scheme.  If we know that
	the pipeline is stalled or struggling to process the amount of
	data we have given it so far, we can reduce the level of detail of
	the remaining objects in the current frame or the next frame, or
	adjust the framebuffer resolution for the next frame if we have a
	video-zoom capability available.  We can call this type of
	instrumentation Load Monitoring.
	
	The second is for performance tuning and debugging of an
	application. It might tell us how many triangles were culled or
	clipped before being rasterized.  We can call this simply Tuning.
	
	Load Monitoring requires that the instrumentation and the access
	of the measurements be efficient, otherwise the instrumentation
	itself will reduce performance more than any load-management
	scheme could hope to offset.  Tuning does not have the same
	requirements.
	
	The proposed extension adds a call to setup a measurements return
	buffer, similar to FeedbackBuffer but with an asynchrounous
	behavior to prevent filling the pipeline with NOP's while waiting
	for the data to be returned.
	
	Note that although the extension has been specified without any
	particular instruments, defining either a device dependent or
	device independent instrument should be as simple as introducing
	an extension consisting primarily of a new enumerant to identify
	the instrument.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/SGIX/instruments.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.SGIX.instruments import *
### END AUTOGENERATED SECTION