"use strict";

var _interopRequire = function (obj) { return obj && obj.__esModule ? obj["default"] : obj; };

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var PreviousMap = _interopRequire(require("./previous-map"));

var path = _interopRequire(require("path"));

// Error while CSS parsing

var CssSyntaxError = (function (SyntaxError) {
    function CssSyntaxError(message, line, column, source, file) {
        _classCallCheck(this, CssSyntaxError);

        this.reason = message;

        this.message = file ? file : "<css input>";
        if (typeof line != "undefined" && typeof column != "undefined") {
            this.line = line;
            this.column = column;
            this.message += ":" + line + ":" + column + ": " + message;
        } else {
            this.message += ": " + message;
        }

        if (file) this.file = file;
        if (source) this.source = source;

        if (Error.captureStackTrace) {
            Error.captureStackTrace(this, CssSyntaxError);
        }
    }

    _inherits(CssSyntaxError, SyntaxError);

    // Return source of broken lines

    CssSyntaxError.prototype.highlight = function highlight(color) {
        var num = this.line - 1;
        var lines = this.source.split("\n");

        var prev = num > 0 ? lines[num - 1] + "\n" : "";
        var broken = lines[num];
        var next = num < lines.length - 1 ? "\n" + lines[num + 1] : "";

        var mark = "\n";
        for (var i = 0; i < this.column - 1; i++) {
            mark += " ";
        }

        if (typeof color == "undefined" && typeof process != "undefined") {
            if (process.stdout && process.env) {
                color = process.stdout.isTTY && !process.env.NODE_DISABLE_COLORS;
            }
        }

        if (color) {
            mark += "\u001b[1;31m^\u001b[0m";
        } else {
            mark += "^";
        }

        return prev + broken + mark + next;
    };

    CssSyntaxError.prototype.setMozillaProps = function setMozillaProps() {
        var sample = Error.call(this, message);
        if (sample.columnNumber) this.columnNumber = this.column;
        if (sample.description) this.description = this.message;
        if (sample.lineNumber) this.lineNumber = this.line;
        if (sample.fileName) this.fileName = this.file;
    };

    CssSyntaxError.prototype.toString = function toString() {
        var text = this.message;
        if (this.source) text += "\n" + this.highlight();
        return this.name + ": " + text;
    };

    return CssSyntaxError;
})(SyntaxError);

module.exports = CssSyntaxError;

CssSyntaxError.prototype.name = "CssSyntaxError";