"""Generated message classes for deploymentmanager version v2.

The Deployment Manager API allows users to declaratively configure, deploy and
run complex solutions on the Google Cloud Platform.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from googlecloudsdk.third_party.apitools.base.protorpclite import messages as _messages


package = 'deploymentmanager'


class ConfigFile(_messages.Message):
  """ConfigFile message type.

  Fields:
    content: The contents of the file.
  """

  content = _messages.StringField(1)


class Deployment(_messages.Message):
  """Deployment message type.

  Fields:
    description: An optional user-provided description of the deployment.
    fingerprint: Provides a fingerprint to use in requests to modify a
      deployment, such as update(), stop(), and cancelPreview() requests. A
      fingerprint is a randomly generated value that must be provided with
      update(), stop(), and cancelPreview() requests to perform optimistic
      locking. This ensures optimistic concurrency so that only one request
      happens at a time.  The fingerprint is initially generated by Deployment
      Manager and changes after every request to modify data. To get the
      latest fingerprint value, perform a get() request to a deployment.
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    insertTime: [Output Only] Timestamp when the deployment was created, in
      RFC3339 text format .
    manifest: [Output Only] URL of the manifest representing the last manifest
      that was successfully deployed.
    name: Name of the resource; provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    operation: [Output Only] The Operation that most recently ran, or is
      currently running, on this deployment.
    target: [Input Only] The parameters that define your deployment, including
      the deployment configuration and relevant templates.
    update: [Output Only] If Deployment Manager is currently updating or
      previewing an update to this deployment, the updated configuration
      appears here.
  """

  description = _messages.StringField(1)
  fingerprint = _messages.BytesField(2)
  id = _messages.IntegerField(3, variant=_messages.Variant.UINT64)
  insertTime = _messages.StringField(4)
  manifest = _messages.StringField(5)
  name = _messages.StringField(6)
  operation = _messages.MessageField('Operation', 7)
  target = _messages.MessageField('TargetConfiguration', 8)
  update = _messages.MessageField('DeploymentUpdate', 9)


class DeploymentUpdate(_messages.Message):
  """DeploymentUpdate message type.

  Fields:
    manifest: [Output Only] URL of the manifest representing the update
      configuration of this deployment.
  """

  manifest = _messages.StringField(1)


class DeploymentmanagerDeploymentsCancelPreviewRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsCancelPreviewRequest object.

  Fields:
    deployment: The name of the deployment for this request.
    deploymentsCancelPreviewRequest: A DeploymentsCancelPreviewRequest
      resource to be passed as the request body.
    project: The project ID for this request.
  """

  deployment = _messages.StringField(1, required=True)
  deploymentsCancelPreviewRequest = _messages.MessageField('DeploymentsCancelPreviewRequest', 2)
  project = _messages.StringField(3, required=True)


class DeploymentmanagerDeploymentsDeleteRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsDeleteRequest object.

  Fields:
    deployment: The name of the deployment for this request.
    project: The project ID for this request.
  """

  deployment = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class DeploymentmanagerDeploymentsGetRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsGetRequest object.

  Fields:
    deployment: The name of the deployment for this request.
    project: The project ID for this request.
  """

  deployment = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class DeploymentmanagerDeploymentsInsertRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsInsertRequest object.

  Fields:
    deployment: A Deployment resource to be passed as the request body.
    preview: If set to true, creates a deployment and creates "shell"
      resources but does not actually instantiate these resources. This allows
      you to preview what your deployment looks like. After previewing a
      deployment, you can deploy your resources by making a request with the
      update() method or you can use the cancelPreview() method to cancel the
      preview altogether. Note that the deployment will still exist after you
      cancel the preview and you must separately delete this deployment if you
      want to remove it.
    project: The project ID for this request.
  """

  deployment = _messages.MessageField('Deployment', 1)
  preview = _messages.BooleanField(2)
  project = _messages.StringField(3, required=True)


class DeploymentmanagerDeploymentsListRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances whose name is not equal to example-instance, you would use
      filter=name ne example-instance.  Compute Engine Beta API Only: If you
      use filtering in the Beta API, you can also filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. In particular, use filtering
      on nested fields to take advantage of instance labels to organize and
      filter results based on label values.  The Beta API also supports
      filtering on multiple expressions by providing each separate expression
      within parentheses. For example, (scheduling.automaticRestart eq true)
      (zone eq us-central1-f). Multiple expressions are treated as AND
      expressions meaning that resources must match all expressions to pass
      the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: The project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)


class DeploymentmanagerDeploymentsPatchRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsPatchRequest object.

  Enums:
    CreatePolicyValueValuesEnum: Sets the policy to use for creating new
      resources.
    DeletePolicyValueValuesEnum: Sets the policy to use for deleting
      resources.

  Fields:
    createPolicy: Sets the policy to use for creating new resources.
    deletePolicy: Sets the policy to use for deleting resources.
    deployment: The name of the deployment for this request.
    deploymentResource: A Deployment resource to be passed as the request
      body.
    preview: If set to true, updates the deployment and creates and updates
      the "shell" resources but does not actually alter or instantiate these
      resources. This allows you to preview what your deployment will look
      like. You can use this intent to preview how an update would affect your
      deployment. You must provide a target.config with a configuration if
      this is set to true. After previewing a deployment, you can deploy your
      resources by making a request with the update() or you can
      cancelPreview() to remove the preview altogether. Note that the
      deployment will still exist after you cancel the preview and you must
      separately delete this deployment if you want to remove it.
    project: The project ID for this request.
  """

  class CreatePolicyValueValuesEnum(_messages.Enum):
    """Sets the policy to use for creating new resources.

    Values:
      ACQUIRE: <no description>
      CREATE_OR_ACQUIRE: <no description>
    """
    ACQUIRE = 0
    CREATE_OR_ACQUIRE = 1

  class DeletePolicyValueValuesEnum(_messages.Enum):
    """Sets the policy to use for deleting resources.

    Values:
      ABANDON: <no description>
      DELETE: <no description>
    """
    ABANDON = 0
    DELETE = 1

  createPolicy = _messages.EnumField('CreatePolicyValueValuesEnum', 1, default=u'CREATE_OR_ACQUIRE')
  deletePolicy = _messages.EnumField('DeletePolicyValueValuesEnum', 2, default=u'DELETE')
  deployment = _messages.StringField(3, required=True)
  deploymentResource = _messages.MessageField('Deployment', 4)
  preview = _messages.BooleanField(5, default=False)
  project = _messages.StringField(6, required=True)


class DeploymentmanagerDeploymentsStopRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsStopRequest object.

  Fields:
    deployment: The name of the deployment for this request.
    deploymentsStopRequest: A DeploymentsStopRequest resource to be passed as
      the request body.
    project: The project ID for this request.
  """

  deployment = _messages.StringField(1, required=True)
  deploymentsStopRequest = _messages.MessageField('DeploymentsStopRequest', 2)
  project = _messages.StringField(3, required=True)


class DeploymentmanagerDeploymentsUpdateRequest(_messages.Message):
  """A DeploymentmanagerDeploymentsUpdateRequest object.

  Enums:
    CreatePolicyValueValuesEnum: Sets the policy to use for creating new
      resources.
    DeletePolicyValueValuesEnum: Sets the policy to use for deleting
      resources.

  Fields:
    createPolicy: Sets the policy to use for creating new resources.
    deletePolicy: Sets the policy to use for deleting resources.
    deployment: The name of the deployment for this request.
    deploymentResource: A Deployment resource to be passed as the request
      body.
    preview: If set to true, updates the deployment and creates and updates
      the "shell" resources but does not actually alter or instantiate these
      resources. This allows you to preview what your deployment will look
      like. You can use this intent to preview how an update would affect your
      deployment. You must provide a target.config with a configuration if
      this is set to true. After previewing a deployment, you can deploy your
      resources by making a request with the update() or you can
      cancelPreview() to remove the preview altogether. Note that the
      deployment will still exist after you cancel the preview and you must
      separately delete this deployment if you want to remove it.
    project: The project ID for this request.
  """

  class CreatePolicyValueValuesEnum(_messages.Enum):
    """Sets the policy to use for creating new resources.

    Values:
      ACQUIRE: <no description>
      CREATE_OR_ACQUIRE: <no description>
    """
    ACQUIRE = 0
    CREATE_OR_ACQUIRE = 1

  class DeletePolicyValueValuesEnum(_messages.Enum):
    """Sets the policy to use for deleting resources.

    Values:
      ABANDON: <no description>
      DELETE: <no description>
    """
    ABANDON = 0
    DELETE = 1

  createPolicy = _messages.EnumField('CreatePolicyValueValuesEnum', 1, default=u'CREATE_OR_ACQUIRE')
  deletePolicy = _messages.EnumField('DeletePolicyValueValuesEnum', 2, default=u'DELETE')
  deployment = _messages.StringField(3, required=True)
  deploymentResource = _messages.MessageField('Deployment', 4)
  preview = _messages.BooleanField(5, default=False)
  project = _messages.StringField(6, required=True)


class DeploymentmanagerManifestsGetRequest(_messages.Message):
  """A DeploymentmanagerManifestsGetRequest object.

  Fields:
    deployment: The name of the deployment for this request.
    manifest: The name of the manifest for this request.
    project: The project ID for this request.
  """

  deployment = _messages.StringField(1, required=True)
  manifest = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class DeploymentmanagerManifestsListRequest(_messages.Message):
  """A DeploymentmanagerManifestsListRequest object.

  Fields:
    deployment: The name of the deployment for this request.
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances whose name is not equal to example-instance, you would use
      filter=name ne example-instance.  Compute Engine Beta API Only: If you
      use filtering in the Beta API, you can also filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. In particular, use filtering
      on nested fields to take advantage of instance labels to organize and
      filter results based on label values.  The Beta API also supports
      filtering on multiple expressions by providing each separate expression
      within parentheses. For example, (scheduling.automaticRestart eq true)
      (zone eq us-central1-f). Multiple expressions are treated as AND
      expressions meaning that resources must match all expressions to pass
      the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: The project ID for this request.
  """

  deployment = _messages.StringField(1, required=True)
  filter = _messages.StringField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class DeploymentmanagerOperationsGetRequest(_messages.Message):
  """A DeploymentmanagerOperationsGetRequest object.

  Fields:
    operation: The name of the operation for this request.
    project: The project ID for this request.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class DeploymentmanagerOperationsListRequest(_messages.Message):
  """A DeploymentmanagerOperationsListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances whose name is not equal to example-instance, you would use
      filter=name ne example-instance.  Compute Engine Beta API Only: If you
      use filtering in the Beta API, you can also filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. In particular, use filtering
      on nested fields to take advantage of instance labels to organize and
      filter results based on label values.  The Beta API also supports
      filtering on multiple expressions by providing each separate expression
      within parentheses. For example, (scheduling.automaticRestart eq true)
      (zone eq us-central1-f). Multiple expressions are treated as AND
      expressions meaning that resources must match all expressions to pass
      the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: The project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)


class DeploymentmanagerResourcesGetRequest(_messages.Message):
  """A DeploymentmanagerResourcesGetRequest object.

  Fields:
    deployment: The name of the deployment for this request.
    project: The project ID for this request.
    resource: The name of the resource for this request.
  """

  deployment = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class DeploymentmanagerResourcesListRequest(_messages.Message):
  """A DeploymentmanagerResourcesListRequest object.

  Fields:
    deployment: The name of the deployment for this request.
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances whose name is not equal to example-instance, you would use
      filter=name ne example-instance.  Compute Engine Beta API Only: If you
      use filtering in the Beta API, you can also filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. In particular, use filtering
      on nested fields to take advantage of instance labels to organize and
      filter results based on label values.  The Beta API also supports
      filtering on multiple expressions by providing each separate expression
      within parentheses. For example, (scheduling.automaticRestart eq true)
      (zone eq us-central1-f). Multiple expressions are treated as AND
      expressions meaning that resources must match all expressions to pass
      the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: The project ID for this request.
  """

  deployment = _messages.StringField(1, required=True)
  filter = _messages.StringField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class DeploymentmanagerTypesListRequest(_messages.Message):
  """A DeploymentmanagerTypesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances whose name is not equal to example-instance, you would use
      filter=name ne example-instance.  Compute Engine Beta API Only: If you
      use filtering in the Beta API, you can also filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. In particular, use filtering
      on nested fields to take advantage of instance labels to organize and
      filter results based on label values.  The Beta API also supports
      filtering on multiple expressions by providing each separate expression
      within parentheses. For example, (scheduling.automaticRestart eq true)
      (zone eq us-central1-f). Multiple expressions are treated as AND
      expressions meaning that resources must match all expressions to pass
      the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: The project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)


class DeploymentsCancelPreviewRequest(_messages.Message):
  """DeploymentsCancelPreviewRequest message type.

  Fields:
    fingerprint: Specifies a fingerprint for cancelPreview() requests. A
      fingerprint is a randomly generated value that must be provided in
      cancelPreview() requests to perform optimistic locking. This ensures
      optimistic concurrency so that the deployment does not have conflicting
      requests (e.g. if someone attempts to make a new update request while
      another user attempts to cancel a preview, this would prevent one of the
      requests).  The fingerprint is initially generated by Deployment Manager
      and changes after every request to modify a deployment. To get the
      latest fingerprint value, perform a get() request on the deployment.
  """

  fingerprint = _messages.BytesField(1)


class DeploymentsListResponse(_messages.Message):
  """A response containing a partial list of deployments and a page token used
  to build the next request if the request has been truncated.

  Fields:
    deployments: [Output Only] The deployments contained in this response.
    nextPageToken: [Output Only] A token used to continue a truncated list
      request.
  """

  deployments = _messages.MessageField('Deployment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class DeploymentsStopRequest(_messages.Message):
  """DeploymentsStopRequest message type.

  Fields:
    fingerprint: Specifies a fingerprint for stop() requests. A fingerprint is
      a randomly generated value that must be provided in stop() requests to
      perform optimistic locking. This ensures optimistic concurrency so that
      the deployment does not have conflicting requests (e.g. if someone
      attempts to make a new update request while another user attempts to
      stop an ongoing update request, this would prevent a collision).  The
      fingerprint is initially generated by Deployment Manager and changes
      after every request to modify a deployment. To get the latest
      fingerprint value, perform a get() request on the deployment.
  """

  fingerprint = _messages.BytesField(1)


class ImportFile(_messages.Message):
  """ImportFile message type.

  Fields:
    content: The contents of the file.
    name: The name of the file.
  """

  content = _messages.StringField(1)
  name = _messages.StringField(2)


class Manifest(_messages.Message):
  """Manifest message type.

  Fields:
    config: [Output Only] The YAML configuration for this manifest.
    expandedConfig: [Output Only] The fully-expanded configuration file,
      including any templates and references.
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    imports: [Output Only] The imported files for this manifest.
    insertTime: [Output Only] Timestamp when the manifest was created, in
      RFC3339 text format.
    layout: [Output Only] The YAML layout for this manifest.
    name: [Output Only] The name of the manifest.
    selfLink: [Output Only] Self link for the manifest.
  """

  config = _messages.MessageField('ConfigFile', 1)
  expandedConfig = _messages.StringField(2)
  id = _messages.IntegerField(3, variant=_messages.Variant.UINT64)
  imports = _messages.MessageField('ImportFile', 4, repeated=True)
  insertTime = _messages.StringField(5)
  layout = _messages.StringField(6)
  name = _messages.StringField(7)
  selfLink = _messages.StringField(8)


class ManifestsListResponse(_messages.Message):
  """A response containing a partial list of manifests and a page token used
  to build the next request if the request has been truncated.

  Fields:
    manifests: [Output Only] Manifests contained in this list response.
    nextPageToken: [Output Only] A token used to continue a truncated list
      request.
  """

  manifests = _messages.MessageField('Manifest', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class Operation(_messages.Message):
  """An Operation resource, used to manage asynchronous API requests.

  Messages:
    ErrorValue: [Output Only] If errors are generated during processing of the
      operation, this field will be populated.
    WarningsValueListEntry: A WarningsValueListEntry object.

  Fields:
    clientOperationId: [Output Only] Reserved for future use.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: [Output Only] A textual description of the operation, which
      is set when the operation is created.
    endTime: [Output Only] The time that this operation was completed. This
      value is in RFC3339 text format.
    error: [Output Only] If errors are generated during processing of the
      operation, this field will be populated.
    httpErrorMessage: [Output Only] If the operation fails, this field
      contains the HTTP error message that was returned, such as NOT FOUND.
    httpErrorStatusCode: [Output Only] If the operation fails, this field
      contains the HTTP error status code that was returned. For example, a
      404 means the resource was not found.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    insertTime: [Output Only] The time that this operation was requested. This
      value is in RFC3339 text format.
    kind: [Output Only] Type of the resource. Always compute#operation for
      Operation resources.
    name: [Output Only] Name of the resource.
    operationType: [Output Only] The type of operation, such as insert,
      update, or delete, and so on.
    progress: [Output Only] An optional progress indicator that ranges from 0
      to 100. There is no requirement that this be linear or support any
      granularity of operations. This should not be used to guess when the
      operation will be complete. This number should monotonically increase as
      the operation progresses.
    region: [Output Only] The URL of the region where the operation resides.
      Only available when performing regional operations.
    selfLink: [Output Only] Server-defined URL for the resource.
    startTime: [Output Only] The time that this operation was started by the
      server. This value is in RFC3339 text format.
    status: [Output Only] The status of the operation, which can be one of the
      following: PENDING, RUNNING, or DONE.
    statusMessage: [Output Only] An optional textual description of the
      current status of the operation.
    targetId: [Output Only] The unique target ID, which identifies a specific
      incarnation of the target resource.
    targetLink: [Output Only] The URL of the resource that the operation
      modifies.
    user: [Output Only] User who requested the operation, for example:
      user@example.com.
    warnings: [Output Only] If warning messages are generated during
      processing of the operation, this field will be populated.
    zone: [Output Only] The URL of the zone where the operation resides. Only
      available when performing per-zone operations.
  """

  class ErrorValue(_messages.Message):
    """[Output Only] If errors are generated during processing of the
    operation, this field will be populated.

    Messages:
      ErrorsValueListEntry: A ErrorsValueListEntry object.

    Fields:
      errors: [Output Only] The array of errors encountered while processing
        this operation.
    """

    class ErrorsValueListEntry(_messages.Message):
      """A ErrorsValueListEntry object.

      Fields:
        code: [Output Only] The error type identifier for this error.
        location: [Output Only] Indicates the field in the request which
          caused the error. This property is optional.
        message: [Output Only] An optional, human-readable error message.
      """

      code = _messages.StringField(1)
      location = _messages.StringField(2)
      message = _messages.StringField(3)

    errors = _messages.MessageField('ErrorsValueListEntry', 1, repeated=True)

  class WarningsValueListEntry(_messages.Message):
    """A WarningsValueListEntry object.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource, and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.StringField(1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  clientOperationId = _messages.StringField(1)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  endTime = _messages.StringField(4)
  error = _messages.MessageField('ErrorValue', 5)
  httpErrorMessage = _messages.StringField(6)
  httpErrorStatusCode = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  id = _messages.IntegerField(8, variant=_messages.Variant.UINT64)
  insertTime = _messages.StringField(9)
  kind = _messages.StringField(10, default=u'deploymentmanager#operation')
  name = _messages.StringField(11)
  operationType = _messages.StringField(12)
  progress = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  region = _messages.StringField(14)
  selfLink = _messages.StringField(15)
  startTime = _messages.StringField(16)
  status = _messages.StringField(17)
  statusMessage = _messages.StringField(18)
  targetId = _messages.IntegerField(19, variant=_messages.Variant.UINT64)
  targetLink = _messages.StringField(20)
  user = _messages.StringField(21)
  warnings = _messages.MessageField('WarningsValueListEntry', 22, repeated=True)
  zone = _messages.StringField(23)


class OperationsListResponse(_messages.Message):
  """A response containing a partial list of operations and a page token used
  to build the next request if the request has been truncated.

  Fields:
    nextPageToken: [Output Only] A token used to continue a truncated list
      request.
    operations: [Output Only] Operations contained in this list response.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Resource(_messages.Message):
  """Resource message type.

  Messages:
    WarningsValueListEntry: A WarningsValueListEntry object.

  Fields:
    finalProperties: [Output Only] The evaluated properties of the resource
      with references expanded. Returned as serialized YAML.
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    insertTime: [Output Only] Timestamp when the resource was created or
      acquired, in RFC3339 text format .
    manifest: [Output Only] URL of the manifest representing the current
      configuration of this resource.
    name: [Output Only] The name of the resource as it appears in the YAML
      config.
    properties: [Output Only] The current properties of the resource before
      any references have been filled in. Returned as serialized YAML.
    type: [Output Only] The type of the resource, for example
      compute.v1.instance, or replicaPools.v1beta2.instanceGroupManager.
    update: [Output Only] If Deployment Manager is currently updating or
      previewing an update to this resource, the updated configuration appears
      here.
    updateTime: [Output Only] Timestamp when the resource was updated, in
      RFC3339 text format .
    url: [Output Only] The URL of the actual resource.
    warnings: [Output Only] If warning messages are generated during
      processing of this resource, this field will be populated.
  """

  class WarningsValueListEntry(_messages.Message):
    """A WarningsValueListEntry object.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource, and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.StringField(1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  finalProperties = _messages.StringField(1)
  id = _messages.IntegerField(2, variant=_messages.Variant.UINT64)
  insertTime = _messages.StringField(3)
  manifest = _messages.StringField(4)
  name = _messages.StringField(5)
  properties = _messages.StringField(6)
  type = _messages.StringField(7)
  update = _messages.MessageField('ResourceUpdate', 8)
  updateTime = _messages.StringField(9)
  url = _messages.StringField(10)
  warnings = _messages.MessageField('WarningsValueListEntry', 11, repeated=True)


class ResourceUpdate(_messages.Message):
  """ResourceUpdate message type.

  Messages:
    ErrorValue: [Output Only] If errors are generated during update of the
      resource, this field will be populated.
    WarningsValueListEntry: A WarningsValueListEntry object.

  Fields:
    error: [Output Only] If errors are generated during update of the
      resource, this field will be populated.
    finalProperties: [Output Only] The expanded properties of the resource
      with reference values expanded. Returned as serialized YAML.
    intent: [Output Only] The intent of the resource: PREVIEW, UPDATE, or
      CANCEL.
    manifest: [Output Only] URL of the manifest representing the update
      configuration of this resource.
    properties: [Output Only] The set of updated properties for this resource,
      before references are expanded. Returned as serialized YAML.
    state: [Output Only] The state of the resource.
    warnings: [Output Only] If warning messages are generated during
      processing of this resource, this field will be populated.
  """

  class ErrorValue(_messages.Message):
    """[Output Only] If errors are generated during update of the resource,
    this field will be populated.

    Messages:
      ErrorsValueListEntry: A ErrorsValueListEntry object.

    Fields:
      errors: [Output Only] The array of errors encountered while processing
        this operation.
    """

    class ErrorsValueListEntry(_messages.Message):
      """A ErrorsValueListEntry object.

      Fields:
        code: [Output Only] The error type identifier for this error.
        location: [Output Only] Indicates the field in the request which
          caused the error. This property is optional.
        message: [Output Only] An optional, human-readable error message.
      """

      code = _messages.StringField(1)
      location = _messages.StringField(2)
      message = _messages.StringField(3)

    errors = _messages.MessageField('ErrorsValueListEntry', 1, repeated=True)

  class WarningsValueListEntry(_messages.Message):
    """A WarningsValueListEntry object.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource, and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.StringField(1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  error = _messages.MessageField('ErrorValue', 1)
  finalProperties = _messages.StringField(2)
  intent = _messages.StringField(3)
  manifest = _messages.StringField(4)
  properties = _messages.StringField(5)
  state = _messages.StringField(6)
  warnings = _messages.MessageField('WarningsValueListEntry', 7, repeated=True)


class ResourcesListResponse(_messages.Message):
  """A response containing a partial list of resources and a page token used
  to build the next request if the request has been truncated.

  Fields:
    nextPageToken: A token used to continue a truncated list request.
    resources: Resources contained in this list response.
  """

  nextPageToken = _messages.StringField(1)
  resources = _messages.MessageField('Resource', 2, repeated=True)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    AltValueValuesEnum: Data format for the response.

  Fields:
    alt: Data format for the response.
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters. Overrides userIp if both are provided.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    userIp: IP address of the site where the request originates. Use this if
      you want to enforce per-user limits.
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for the response.

    Values:
      json: Responses with Content-Type of application/json
    """
    json = 0

  alt = _messages.EnumField('AltValueValuesEnum', 1, default=u'json')
  fields = _messages.StringField(2)
  key = _messages.StringField(3)
  oauth_token = _messages.StringField(4)
  prettyPrint = _messages.BooleanField(5, default=True)
  quotaUser = _messages.StringField(6)
  trace = _messages.StringField(7)
  userIp = _messages.StringField(8)


class TargetConfiguration(_messages.Message):
  """TargetConfiguration message type.

  Fields:
    config: The configuration to use for this deployment.
    imports: Specifies any files to import for this configuration. This can be
      used to import templates or other files. For example, you might import a
      text file in order to use the file in a template.
  """

  config = _messages.MessageField('ConfigFile', 1)
  imports = _messages.MessageField('ImportFile', 2, repeated=True)


class Type(_messages.Message):
  """A resource type supported by Deployment Manager.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    insertTime: [Output Only] Timestamp when the type was created, in RFC3339
      text format.
    name: Name of the type.
    selfLink: [Output Only] Self link for the type.
  """

  id = _messages.IntegerField(1, variant=_messages.Variant.UINT64)
  insertTime = _messages.StringField(2)
  name = _messages.StringField(3)
  selfLink = _messages.StringField(4)


class TypesListResponse(_messages.Message):
  """A response that returns all Types supported by Deployment Manager

  Fields:
    nextPageToken: A token used to continue a truncated list request.
    types: [Output Only] A list of resource types supported by Deployment
      Manager.
  """

  nextPageToken = _messages.StringField(1)
  types = _messages.MessageField('Type', 2, repeated=True)


