"""Generated client library for genomics version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from googlecloudsdk.third_party.apitools.base.py import base_api
from googlecloudsdk.third_party.apis.genomics.v1 import genomics_v1_messages as messages


class GenomicsV1(base_api.BaseApiClient):
  """Generated client library for service genomics version v1."""

  MESSAGES_MODULE = messages

  _PACKAGE = u'genomics'
  _SCOPES = [u'https://www.googleapis.com/auth/bigquery', u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/devstorage.read_write', u'https://www.googleapis.com/auth/genomics', u'https://www.googleapis.com/auth/genomics.readonly']
  _VERSION = u'v1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'GenomicsV1'
  _URL_VERSION = u'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None):
    """Create a new genomics handle."""
    url = url or u'https://genomics.googleapis.com/'
    super(GenomicsV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers)
    self.callsets = self.CallsetsService(self)
    self.datasets = self.DatasetsService(self)
    self.operations = self.OperationsService(self)
    self.readgroupsets_coveragebuckets = self.ReadgroupsetsCoveragebucketsService(self)
    self.readgroupsets = self.ReadgroupsetsService(self)
    self.reads = self.ReadsService(self)
    self.references_bases = self.ReferencesBasesService(self)
    self.references = self.ReferencesService(self)
    self.referencesets = self.ReferencesetsService(self)
    self.variants = self.VariantsService(self)
    self.variantsets = self.VariantsetsService(self)

  class CallsetsService(base_api.BaseApiService):
    """Service class for the callsets resource."""

    _NAME = u'callsets'

    def __init__(self, client):
      super(GenomicsV1.CallsetsService, self).__init__(client)
      self._method_configs = {
          'Create': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.callsets.create',
              ordered_params=[],
              path_params=[],
              query_params=[],
              relative_path=u'v1/callsets',
              request_field='<request>',
              request_type_name=u'CallSet',
              response_type_name=u'CallSet',
              supports_download=False,
          ),
          'Delete': base_api.ApiMethodInfo(
              http_method=u'DELETE',
              method_id=u'genomics.callsets.delete',
              ordered_params=[u'callSetId'],
              path_params=[u'callSetId'],
              query_params=[],
              relative_path=u'v1/callsets/{callSetId}',
              request_field='',
              request_type_name=u'GenomicsCallsetsDeleteRequest',
              response_type_name=u'Empty',
              supports_download=False,
          ),
          'Get': base_api.ApiMethodInfo(
              http_method=u'GET',
              method_id=u'genomics.callsets.get',
              ordered_params=[u'callSetId'],
              path_params=[u'callSetId'],
              query_params=[],
              relative_path=u'v1/callsets/{callSetId}',
              request_field='',
              request_type_name=u'GenomicsCallsetsGetRequest',
              response_type_name=u'CallSet',
              supports_download=False,
          ),
          'Patch': base_api.ApiMethodInfo(
              http_method=u'PATCH',
              method_id=u'genomics.callsets.patch',
              ordered_params=[u'callSetId'],
              path_params=[u'callSetId'],
              query_params=[u'updateMask'],
              relative_path=u'v1/callsets/{callSetId}',
              request_field=u'callSet',
              request_type_name=u'GenomicsCallsetsPatchRequest',
              response_type_name=u'CallSet',
              supports_download=False,
          ),
          'Search': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.callsets.search',
              ordered_params=[],
              path_params=[],
              query_params=[],
              relative_path=u'v1/callsets/search',
              request_field='<request>',
              request_type_name=u'SearchCallSetsRequest',
              response_type_name=u'SearchCallSetsResponse',
              supports_download=False,
          ),
          }

      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      """Creates a new call set.

For the definitions of call sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

      Args:
        request: (CallSet) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CallSet) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Delete(self, request, global_params=None):
      """Deletes a call set.

For the definitions of call sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

      Args:
        request: (GenomicsCallsetsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Get(self, request, global_params=None):
      """Gets a call set by ID.

For the definitions of call sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

      Args:
        request: (GenomicsCallsetsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CallSet) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Patch(self, request, global_params=None):
      """Updates a call set.

For the definitions of call sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

This method supports patch semantics.

      Args:
        request: (GenomicsCallsetsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CallSet) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Search(self, request, global_params=None):
      """Gets a list of call sets matching the criteria.

For the definitions of call sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

Implements [GlobalAllianceApi.searchCallSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L178).

      Args:
        request: (SearchCallSetsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchCallSetsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

  class DatasetsService(base_api.BaseApiService):
    """Service class for the datasets resource."""

    _NAME = u'datasets'

    def __init__(self, client):
      super(GenomicsV1.DatasetsService, self).__init__(client)
      self._method_configs = {
          'Create': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.datasets.create',
              ordered_params=[],
              path_params=[],
              query_params=[],
              relative_path=u'v1/datasets',
              request_field='<request>',
              request_type_name=u'Dataset',
              response_type_name=u'Dataset',
              supports_download=False,
          ),
          'Delete': base_api.ApiMethodInfo(
              http_method=u'DELETE',
              method_id=u'genomics.datasets.delete',
              ordered_params=[u'datasetId'],
              path_params=[u'datasetId'],
              query_params=[],
              relative_path=u'v1/datasets/{datasetId}',
              request_field='',
              request_type_name=u'GenomicsDatasetsDeleteRequest',
              response_type_name=u'Empty',
              supports_download=False,
          ),
          'Get': base_api.ApiMethodInfo(
              http_method=u'GET',
              method_id=u'genomics.datasets.get',
              ordered_params=[u'datasetId'],
              path_params=[u'datasetId'],
              query_params=[],
              relative_path=u'v1/datasets/{datasetId}',
              request_field='',
              request_type_name=u'GenomicsDatasetsGetRequest',
              response_type_name=u'Dataset',
              supports_download=False,
          ),
          'GetIamPolicy': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.datasets.getIamPolicy',
              ordered_params=[u'resource'],
              path_params=[u'resource'],
              query_params=[],
              relative_path=u'v1/{+resource}:getIamPolicy',
              request_field=u'getIamPolicyRequest',
              request_type_name=u'GenomicsDatasetsGetIamPolicyRequest',
              response_type_name=u'Policy',
              supports_download=False,
          ),
          'List': base_api.ApiMethodInfo(
              http_method=u'GET',
              method_id=u'genomics.datasets.list',
              ordered_params=[],
              path_params=[],
              query_params=[u'pageSize', u'pageToken', u'projectId'],
              relative_path=u'v1/datasets',
              request_field='',
              request_type_name=u'GenomicsDatasetsListRequest',
              response_type_name=u'ListDatasetsResponse',
              supports_download=False,
          ),
          'Patch': base_api.ApiMethodInfo(
              http_method=u'PATCH',
              method_id=u'genomics.datasets.patch',
              ordered_params=[u'datasetId'],
              path_params=[u'datasetId'],
              query_params=[u'updateMask'],
              relative_path=u'v1/datasets/{datasetId}',
              request_field=u'dataset',
              request_type_name=u'GenomicsDatasetsPatchRequest',
              response_type_name=u'Dataset',
              supports_download=False,
          ),
          'SetIamPolicy': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.datasets.setIamPolicy',
              ordered_params=[u'resource'],
              path_params=[u'resource'],
              query_params=[],
              relative_path=u'v1/{+resource}:setIamPolicy',
              request_field=u'setIamPolicyRequest',
              request_type_name=u'GenomicsDatasetsSetIamPolicyRequest',
              response_type_name=u'Policy',
              supports_download=False,
          ),
          'TestIamPermissions': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.datasets.testIamPermissions',
              ordered_params=[u'resource'],
              path_params=[u'resource'],
              query_params=[],
              relative_path=u'v1/{+resource}:testIamPermissions',
              request_field=u'testIamPermissionsRequest',
              request_type_name=u'GenomicsDatasetsTestIamPermissionsRequest',
              response_type_name=u'TestIamPermissionsResponse',
              supports_download=False,
          ),
          'Undelete': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.datasets.undelete',
              ordered_params=[u'datasetId'],
              path_params=[u'datasetId'],
              query_params=[],
              relative_path=u'v1/datasets/{datasetId}:undelete',
              request_field=u'undeleteDatasetRequest',
              request_type_name=u'GenomicsDatasetsUndeleteRequest',
              response_type_name=u'Dataset',
              supports_download=False,
          ),
          }

      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      """Creates a new dataset.

For the definitions of datasets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

      Args:
        request: (Dataset) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Dataset) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Delete(self, request, global_params=None):
      """Deletes a dataset.

For the definitions of datasets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

      Args:
        request: (GenomicsDatasetsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Get(self, request, global_params=None):
      """Gets a dataset by ID.

For the definitions of datasets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

      Args:
        request: (GenomicsDatasetsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Dataset) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    def GetIamPolicy(self, request, global_params=None):
      """Gets the access control policy for the dataset. This is empty if the.
policy or resource does not exist.

See <a href="/iam/docs/managing-policies#getting_a_policy">Getting a
Policy</a> for more information.

For the definitions of datasets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

      Args:
        request: (GenomicsDatasetsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    def List(self, request, global_params=None):
      """Lists datasets within a project.

For the definitions of datasets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

      Args:
        request: (GenomicsDatasetsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDatasetsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Patch(self, request, global_params=None):
      """Updates a dataset.

For the definitions of datasets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

This method supports patch semantics.

      Args:
        request: (GenomicsDatasetsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Dataset) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    def SetIamPolicy(self, request, global_params=None):
      """Sets the access control policy on the specified dataset. Replaces any.
existing policy.

For the definitions of datasets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

See <a href="/iam/docs/managing-policies#setting_a_policy">Setting a
Policy</a> for more information.

      Args:
        request: (GenomicsDatasetsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    def TestIamPermissions(self, request, global_params=None):
      """Returns permissions that a caller has on the specified resource.
See <a href="/iam/docs/managing-policies#testing_permissions">Testing
Permissions</a> for more information.

For the definitions of datasets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

      Args:
        request: (GenomicsDatasetsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Undelete(self, request, global_params=None):
      """Undeletes a dataset by restoring a dataset which was deleted via this API.

For the definitions of datasets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

This operation is only possible for a week after the deletion occurred.

      Args:
        request: (GenomicsDatasetsUndeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Dataset) The response message.
      """
      config = self.GetMethodConfig('Undelete')
      return self._RunMethod(
          config, request, global_params=global_params)

  class OperationsService(base_api.BaseApiService):
    """Service class for the operations resource."""

    _NAME = u'operations'

    def __init__(self, client):
      super(GenomicsV1.OperationsService, self).__init__(client)
      self._method_configs = {
          'Cancel': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.operations.cancel',
              ordered_params=[u'name'],
              path_params=[u'name'],
              query_params=[],
              relative_path=u'v1/{+name}:cancel',
              request_field=u'cancelOperationRequest',
              request_type_name=u'GenomicsOperationsCancelRequest',
              response_type_name=u'Empty',
              supports_download=False,
          ),
          'Get': base_api.ApiMethodInfo(
              http_method=u'GET',
              method_id=u'genomics.operations.get',
              ordered_params=[u'name'],
              path_params=[u'name'],
              query_params=[],
              relative_path=u'v1/{+name}',
              request_field='',
              request_type_name=u'GenomicsOperationsGetRequest',
              response_type_name=u'Operation',
              supports_download=False,
          ),
          'List': base_api.ApiMethodInfo(
              http_method=u'GET',
              method_id=u'genomics.operations.list',
              ordered_params=[u'name'],
              path_params=[u'name'],
              query_params=[u'filter', u'pageSize', u'pageToken'],
              relative_path=u'v1/{+name}',
              request_field='',
              request_type_name=u'GenomicsOperationsListRequest',
              response_type_name=u'ListOperationsResponse',
              supports_download=False,
          ),
          }

      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      """Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. Clients may use Operations.GetOperation or Operations.ListOperations to check whether the cancellation succeeded or the operation completed despite cancellation.

      Args:
        request: (GenomicsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Get(self, request, global_params=None):
      """Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (GenomicsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    def List(self, request, global_params=None):
      """Lists operations that match the specified filter in the request.

      Args:
        request: (GenomicsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

  class ReadgroupsetsCoveragebucketsService(base_api.BaseApiService):
    """Service class for the readgroupsets_coveragebuckets resource."""

    _NAME = u'readgroupsets_coveragebuckets'

    def __init__(self, client):
      super(GenomicsV1.ReadgroupsetsCoveragebucketsService, self).__init__(client)
      self._method_configs = {
          'List': base_api.ApiMethodInfo(
              http_method=u'GET',
              method_id=u'genomics.readgroupsets.coveragebuckets.list',
              ordered_params=[u'readGroupSetId'],
              path_params=[u'readGroupSetId'],
              query_params=[u'end', u'pageSize', u'pageToken', u'referenceName', u'start', u'targetBucketWidth'],
              relative_path=u'v1/readgroupsets/{readGroupSetId}/coveragebuckets',
              request_field='',
              request_type_name=u'GenomicsReadgroupsetsCoveragebucketsListRequest',
              response_type_name=u'ListCoverageBucketsResponse',
              supports_download=False,
          ),
          }

      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      """Lists fixed width coverage buckets for a read group set, each of which.
correspond to a range of a reference sequence. Each bucket summarizes
coverage information across its corresponding genomic range.

For the definitions of read group sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

Coverage is defined as the number of reads which are aligned to a given
base in the reference sequence. Coverage buckets are available at several
precomputed bucket widths, enabling retrieval of various coverage 'zoom
levels'. The caller must have READ permissions for the target read group
set.

      Args:
        request: (GenomicsReadgroupsetsCoveragebucketsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCoverageBucketsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

  class ReadgroupsetsService(base_api.BaseApiService):
    """Service class for the readgroupsets resource."""

    _NAME = u'readgroupsets'

    def __init__(self, client):
      super(GenomicsV1.ReadgroupsetsService, self).__init__(client)
      self._method_configs = {
          'Delete': base_api.ApiMethodInfo(
              http_method=u'DELETE',
              method_id=u'genomics.readgroupsets.delete',
              ordered_params=[u'readGroupSetId'],
              path_params=[u'readGroupSetId'],
              query_params=[],
              relative_path=u'v1/readgroupsets/{readGroupSetId}',
              request_field='',
              request_type_name=u'GenomicsReadgroupsetsDeleteRequest',
              response_type_name=u'Empty',
              supports_download=False,
          ),
          'Export': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.readgroupsets.export',
              ordered_params=[u'readGroupSetId'],
              path_params=[u'readGroupSetId'],
              query_params=[],
              relative_path=u'v1/readgroupsets/{readGroupSetId}:export',
              request_field=u'exportReadGroupSetRequest',
              request_type_name=u'GenomicsReadgroupsetsExportRequest',
              response_type_name=u'Operation',
              supports_download=False,
          ),
          'Get': base_api.ApiMethodInfo(
              http_method=u'GET',
              method_id=u'genomics.readgroupsets.get',
              ordered_params=[u'readGroupSetId'],
              path_params=[u'readGroupSetId'],
              query_params=[],
              relative_path=u'v1/readgroupsets/{readGroupSetId}',
              request_field='',
              request_type_name=u'GenomicsReadgroupsetsGetRequest',
              response_type_name=u'ReadGroupSet',
              supports_download=False,
          ),
          'Import': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.readgroupsets.import',
              ordered_params=[],
              path_params=[],
              query_params=[],
              relative_path=u'v1/readgroupsets:import',
              request_field='<request>',
              request_type_name=u'ImportReadGroupSetsRequest',
              response_type_name=u'Operation',
              supports_download=False,
          ),
          'Patch': base_api.ApiMethodInfo(
              http_method=u'PATCH',
              method_id=u'genomics.readgroupsets.patch',
              ordered_params=[u'readGroupSetId'],
              path_params=[u'readGroupSetId'],
              query_params=[u'updateMask'],
              relative_path=u'v1/readgroupsets/{readGroupSetId}',
              request_field=u'readGroupSet',
              request_type_name=u'GenomicsReadgroupsetsPatchRequest',
              response_type_name=u'ReadGroupSet',
              supports_download=False,
          ),
          'Search': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.readgroupsets.search',
              ordered_params=[],
              path_params=[],
              query_params=[],
              relative_path=u'v1/readgroupsets/search',
              request_field='<request>',
              request_type_name=u'SearchReadGroupSetsRequest',
              response_type_name=u'SearchReadGroupSetsResponse',
              supports_download=False,
          ),
          }

      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      """Deletes a read group set.

For the definitions of read group sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

      Args:
        request: (GenomicsReadgroupsetsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Export(self, request, global_params=None):
      """Exports a read group set to a BAM file in Google Cloud Storage.

For the definitions of read group sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

Note that currently there may be some differences between exported BAM
files and the original BAM file at the time of import. See
[ImportReadGroupSets](google.genomics.v1.ReadServiceV1.ImportReadGroupSets)
for caveats.

      Args:
        request: (GenomicsReadgroupsetsExportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Export')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Get(self, request, global_params=None):
      """Gets a read group set by ID.

For the definitions of read group sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

      Args:
        request: (GenomicsReadgroupsetsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReadGroupSet) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Import(self, request, global_params=None):
      """Creates read group sets by asynchronously importing the provided.
information.

For the definitions of read group sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

The caller must have WRITE permissions to the dataset.

## Notes on [BAM](https://samtools.github.io/hts-specs/SAMv1.pdf) import

- Tags will be converted to strings - tag types are not preserved
- Comments (`@CO`) in the input file header will not be preserved
- Original header order of references (`@SQ`) will not be preserved
- Any reverse stranded unmapped reads will be reverse complemented, and
their qualities (also the "BQ" and "OQ" tags, if any) will be reversed
- Unmapped reads will be stripped of positional information (reference name
and position)

      Args:
        request: (ImportReadGroupSetsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Import')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Patch(self, request, global_params=None):
      """Updates a read group set.

For the definitions of read group sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

This method supports patch semantics.

      Args:
        request: (GenomicsReadgroupsetsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReadGroupSet) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Search(self, request, global_params=None):
      """Searches for read group sets matching the criteria.

For the definitions of read group sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

Implements [GlobalAllianceApi.searchReadGroupSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/readmethods.avdl#L135).

      Args:
        request: (SearchReadGroupSetsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchReadGroupSetsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

  class ReadsService(base_api.BaseApiService):
    """Service class for the reads resource."""

    _NAME = u'reads'

    def __init__(self, client):
      super(GenomicsV1.ReadsService, self).__init__(client)
      self._method_configs = {
          'Search': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.reads.search',
              ordered_params=[],
              path_params=[],
              query_params=[],
              relative_path=u'v1/reads/search',
              request_field='<request>',
              request_type_name=u'SearchReadsRequest',
              response_type_name=u'SearchReadsResponse',
              supports_download=False,
          ),
          'Stream': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.reads.stream',
              ordered_params=[],
              path_params=[],
              query_params=[],
              relative_path=u'v1/reads:stream',
              request_field='<request>',
              request_type_name=u'StreamReadsRequest',
              response_type_name=u'StreamReadsResponse',
              supports_download=False,
          ),
          }

      self._upload_configs = {
          }

    def Search(self, request, global_params=None):
      """Gets a list of reads for one or more read group sets.

For the definitions of read group sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

Reads search operates over a genomic coordinate space of reference sequence
& position defined over the reference sequences to which the requested
read group sets are aligned.

If a target positional range is specified, search returns all reads whose
alignment to the reference genome overlap the range. A query which
specifies only read group set IDs yields all reads in those read group
sets, including unmapped reads.

All reads returned (including reads on subsequent pages) are ordered by
genomic coordinate (by reference sequence, then position). Reads with
equivalent genomic coordinates are returned in an unspecified order. This
order is consistent, such that two queries for the same content (regardless
of page size) yield reads in the same order across their respective streams
of paginated responses.

Implements [GlobalAllianceApi.searchReads](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/readmethods.avdl#L85).

      Args:
        request: (SearchReadsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchReadsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Stream(self, request, global_params=None):
      """Returns a stream of all the reads matching the search request, ordered.
by reference name, position, and ID.

      Args:
        request: (StreamReadsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (StreamReadsResponse) The response message.
      """
      config = self.GetMethodConfig('Stream')
      return self._RunMethod(
          config, request, global_params=global_params)

  class ReferencesBasesService(base_api.BaseApiService):
    """Service class for the references_bases resource."""

    _NAME = u'references_bases'

    def __init__(self, client):
      super(GenomicsV1.ReferencesBasesService, self).__init__(client)
      self._method_configs = {
          'List': base_api.ApiMethodInfo(
              http_method=u'GET',
              method_id=u'genomics.references.bases.list',
              ordered_params=[u'referenceId'],
              path_params=[u'referenceId'],
              query_params=[u'end', u'pageSize', u'pageToken', u'start'],
              relative_path=u'v1/references/{referenceId}/bases',
              request_field='',
              request_type_name=u'GenomicsReferencesBasesListRequest',
              response_type_name=u'ListBasesResponse',
              supports_download=False,
          ),
          }

      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      """Lists the bases in a reference, optionally restricted to a range.

For the definitions of references and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

Implements [GlobalAllianceApi.getReferenceBases](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/referencemethods.avdl#L221).

      Args:
        request: (GenomicsReferencesBasesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListBasesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

  class ReferencesService(base_api.BaseApiService):
    """Service class for the references resource."""

    _NAME = u'references'

    def __init__(self, client):
      super(GenomicsV1.ReferencesService, self).__init__(client)
      self._method_configs = {
          'Get': base_api.ApiMethodInfo(
              http_method=u'GET',
              method_id=u'genomics.references.get',
              ordered_params=[u'referenceId'],
              path_params=[u'referenceId'],
              query_params=[],
              relative_path=u'v1/references/{referenceId}',
              request_field='',
              request_type_name=u'GenomicsReferencesGetRequest',
              response_type_name=u'Reference',
              supports_download=False,
          ),
          'Search': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.references.search',
              ordered_params=[],
              path_params=[],
              query_params=[],
              relative_path=u'v1/references/search',
              request_field='<request>',
              request_type_name=u'SearchReferencesRequest',
              response_type_name=u'SearchReferencesResponse',
              supports_download=False,
          ),
          }

      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      """Gets a reference.

For the definitions of references and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

Implements [GlobalAllianceApi.getReference](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/referencemethods.avdl#L158).

      Args:
        request: (GenomicsReferencesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Reference) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Search(self, request, global_params=None):
      """Searches for references which match the given criteria.

For the definitions of references and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

Implements [GlobalAllianceApi.searchReferences](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/referencemethods.avdl#L146).

      Args:
        request: (SearchReferencesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchReferencesResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

  class ReferencesetsService(base_api.BaseApiService):
    """Service class for the referencesets resource."""

    _NAME = u'referencesets'

    def __init__(self, client):
      super(GenomicsV1.ReferencesetsService, self).__init__(client)
      self._method_configs = {
          'Get': base_api.ApiMethodInfo(
              http_method=u'GET',
              method_id=u'genomics.referencesets.get',
              ordered_params=[u'referenceSetId'],
              path_params=[u'referenceSetId'],
              query_params=[],
              relative_path=u'v1/referencesets/{referenceSetId}',
              request_field='',
              request_type_name=u'GenomicsReferencesetsGetRequest',
              response_type_name=u'ReferenceSet',
              supports_download=False,
          ),
          'Search': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.referencesets.search',
              ordered_params=[],
              path_params=[],
              query_params=[],
              relative_path=u'v1/referencesets/search',
              request_field='<request>',
              request_type_name=u'SearchReferenceSetsRequest',
              response_type_name=u'SearchReferenceSetsResponse',
              supports_download=False,
          ),
          }

      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      """Gets a reference set.

For the definitions of references and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

Implements [GlobalAllianceApi.getReferenceSet](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/referencemethods.avdl#L83).

      Args:
        request: (GenomicsReferencesetsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReferenceSet) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Search(self, request, global_params=None):
      """Searches for reference sets which match the given criteria.

For the definitions of references and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

Implements [GlobalAllianceApi.searchReferenceSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/referencemethods.avdl#L71)

      Args:
        request: (SearchReferenceSetsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchReferenceSetsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

  class VariantsService(base_api.BaseApiService):
    """Service class for the variants resource."""

    _NAME = u'variants'

    def __init__(self, client):
      super(GenomicsV1.VariantsService, self).__init__(client)
      self._method_configs = {
          'Create': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.variants.create',
              ordered_params=[],
              path_params=[],
              query_params=[],
              relative_path=u'v1/variants',
              request_field='<request>',
              request_type_name=u'Variant',
              response_type_name=u'Variant',
              supports_download=False,
          ),
          'Delete': base_api.ApiMethodInfo(
              http_method=u'DELETE',
              method_id=u'genomics.variants.delete',
              ordered_params=[u'variantId'],
              path_params=[u'variantId'],
              query_params=[],
              relative_path=u'v1/variants/{variantId}',
              request_field='',
              request_type_name=u'GenomicsVariantsDeleteRequest',
              response_type_name=u'Empty',
              supports_download=False,
          ),
          'Get': base_api.ApiMethodInfo(
              http_method=u'GET',
              method_id=u'genomics.variants.get',
              ordered_params=[u'variantId'],
              path_params=[u'variantId'],
              query_params=[],
              relative_path=u'v1/variants/{variantId}',
              request_field='',
              request_type_name=u'GenomicsVariantsGetRequest',
              response_type_name=u'Variant',
              supports_download=False,
          ),
          'Import': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.variants.import',
              ordered_params=[],
              path_params=[],
              query_params=[],
              relative_path=u'v1/variants:import',
              request_field='<request>',
              request_type_name=u'ImportVariantsRequest',
              response_type_name=u'Operation',
              supports_download=False,
          ),
          'Patch': base_api.ApiMethodInfo(
              http_method=u'PATCH',
              method_id=u'genomics.variants.patch',
              ordered_params=[u'variantId'],
              path_params=[u'variantId'],
              query_params=[u'updateMask'],
              relative_path=u'v1/variants/{variantId}',
              request_field=u'variant',
              request_type_name=u'GenomicsVariantsPatchRequest',
              response_type_name=u'Variant',
              supports_download=False,
          ),
          'Search': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.variants.search',
              ordered_params=[],
              path_params=[],
              query_params=[],
              relative_path=u'v1/variants/search',
              request_field='<request>',
              request_type_name=u'SearchVariantsRequest',
              response_type_name=u'SearchVariantsResponse',
              supports_download=False,
          ),
          'Stream': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.variants.stream',
              ordered_params=[],
              path_params=[],
              query_params=[],
              relative_path=u'v1/variants:stream',
              request_field='<request>',
              request_type_name=u'StreamVariantsRequest',
              response_type_name=u'StreamVariantsResponse',
              supports_download=False,
          ),
          }

      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      """Creates a new variant.

For the definitions of variants and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

      Args:
        request: (Variant) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Variant) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Delete(self, request, global_params=None):
      """Deletes a variant.

For the definitions of variants and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

      Args:
        request: (GenomicsVariantsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Get(self, request, global_params=None):
      """Gets a variant by ID.

For the definitions of variants and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

      Args:
        request: (GenomicsVariantsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Variant) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Import(self, request, global_params=None):
      """Creates variant data by asynchronously importing the provided information.

For the definitions of variant sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

The variants for import will be merged with any existing variant that
matches its reference sequence, start, end, reference bases, and
alternative bases. If no such variant exists, a new one will be created.

When variants are merged, the call information from the new variant
is added to the existing variant, and other fields (such as key/value
pairs) are discarded. In particular, this means for merged VCF variants
that have conflicting INFO fields, some data will be arbitrarily
discarded. As a special case, for single-sample VCF files, QUAL and
FILTER fields will be moved to the call level; these are sometimes
interpreted in a call-specific context.

Imported VCF headers are appended to the metadata already in a variant set.

      Args:
        request: (ImportVariantsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Import')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Patch(self, request, global_params=None):
      """Updates a variant.

For the definitions of variants and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

This method supports patch semantics. Returns the modified variant without its calls.

      Args:
        request: (GenomicsVariantsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Variant) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Search(self, request, global_params=None):
      """Gets a list of variants matching the criteria.

For the definitions of variants and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

Implements [GlobalAllianceApi.searchVariants](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L126).

      Args:
        request: (SearchVariantsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchVariantsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Stream(self, request, global_params=None):
      """Returns a stream of all the variants matching the search request, ordered.
by reference name, position, and ID.

      Args:
        request: (StreamVariantsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (StreamVariantsResponse) The response message.
      """
      config = self.GetMethodConfig('Stream')
      return self._RunMethod(
          config, request, global_params=global_params)

  class VariantsetsService(base_api.BaseApiService):
    """Service class for the variantsets resource."""

    _NAME = u'variantsets'

    def __init__(self, client):
      super(GenomicsV1.VariantsetsService, self).__init__(client)
      self._method_configs = {
          'Create': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.variantsets.create',
              ordered_params=[],
              path_params=[],
              query_params=[],
              relative_path=u'v1/variantsets',
              request_field='<request>',
              request_type_name=u'VariantSet',
              response_type_name=u'VariantSet',
              supports_download=False,
          ),
          'Delete': base_api.ApiMethodInfo(
              http_method=u'DELETE',
              method_id=u'genomics.variantsets.delete',
              ordered_params=[u'variantSetId'],
              path_params=[u'variantSetId'],
              query_params=[],
              relative_path=u'v1/variantsets/{variantSetId}',
              request_field='',
              request_type_name=u'GenomicsVariantsetsDeleteRequest',
              response_type_name=u'Empty',
              supports_download=False,
          ),
          'Export': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.variantsets.export',
              ordered_params=[u'variantSetId'],
              path_params=[u'variantSetId'],
              query_params=[],
              relative_path=u'v1/variantsets/{variantSetId}:export',
              request_field=u'exportVariantSetRequest',
              request_type_name=u'GenomicsVariantsetsExportRequest',
              response_type_name=u'Operation',
              supports_download=False,
          ),
          'Get': base_api.ApiMethodInfo(
              http_method=u'GET',
              method_id=u'genomics.variantsets.get',
              ordered_params=[u'variantSetId'],
              path_params=[u'variantSetId'],
              query_params=[],
              relative_path=u'v1/variantsets/{variantSetId}',
              request_field='',
              request_type_name=u'GenomicsVariantsetsGetRequest',
              response_type_name=u'VariantSet',
              supports_download=False,
          ),
          'Patch': base_api.ApiMethodInfo(
              http_method=u'PATCH',
              method_id=u'genomics.variantsets.patch',
              ordered_params=[u'variantSetId'],
              path_params=[u'variantSetId'],
              query_params=[u'updateMask'],
              relative_path=u'v1/variantsets/{variantSetId}',
              request_field=u'variantSet',
              request_type_name=u'GenomicsVariantsetsPatchRequest',
              response_type_name=u'VariantSet',
              supports_download=False,
          ),
          'Search': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'genomics.variantsets.search',
              ordered_params=[],
              path_params=[],
              query_params=[],
              relative_path=u'v1/variantsets/search',
              request_field='<request>',
              request_type_name=u'SearchVariantSetsRequest',
              response_type_name=u'SearchVariantSetsResponse',
              supports_download=False,
          ),
          }

      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      """Creates a new variant set.

For the definitions of variant sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

The provided variant set must have a valid `datasetId` set - all other
fields are optional. Note that the `id` field will be ignored, as this is
assigned by the server.

      Args:
        request: (VariantSet) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VariantSet) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Delete(self, request, global_params=None):
      """Deletes the contents of a variant set. The variant set object is not.
deleted.

For the definitions of variant sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

      Args:
        request: (GenomicsVariantsetsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Export(self, request, global_params=None):
      """Exports variant set data to an external destination.

For the definitions of variant sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

      Args:
        request: (GenomicsVariantsetsExportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Export')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Get(self, request, global_params=None):
      """Gets a variant set by ID.

For the definitions of variant sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

      Args:
        request: (GenomicsVariantsetsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VariantSet) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Patch(self, request, global_params=None):
      """Updates a variant set using patch semantics.

For the definitions of variant sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

      Args:
        request: (GenomicsVariantsetsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VariantSet) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Search(self, request, global_params=None):
      """Returns a list of all variant sets matching search criteria.

For the definitions of variant sets and other genomics resources, see [Fundamentals of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

Implements [GlobalAllianceApi.searchVariantSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L49).

      Args:
        request: (SearchVariantSetsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchVariantSetsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)
