/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class GraphicsUtil {
    public static AffineTransform IDENTITY = new AffineTransform();
    public static final ColorModel Linear_sRGB = new DirectColorModel(ColorSpace.getInstance(1004), 24, 0xFF0000, 65280, 255, 0, false, 3);
    public static final ColorModel Linear_sRGB_Pre = new DirectColorModel(ColorSpace.getInstance(1004), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
    public static final ColorModel Linear_sRGB_Unpre = new DirectColorModel(ColorSpace.getInstance(1004), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
    public static final ColorModel sRGB = new DirectColorModel(ColorSpace.getInstance(1000), 24, 0xFF0000, 65280, 255, 0, false, 3);
    public static final ColorModel sRGB_Pre = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
    public static final ColorModel sRGB_Unpre = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);

    public static ColorModel makeLinear_sRGBCM(boolean bl) {
        if (bl) {
            return Linear_sRGB_Pre;
        }
        return Linear_sRGB_Unpre;
    }

    public static BufferedImage makeLinearBufferedImage(int n, int n2, boolean bl) {
        ColorModel colorModel = GraphicsUtil.makeLinear_sRGBCM(bl);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new BufferedImage(colorModel, writableRaster, bl, null);
    }

    public static WritableRaster copyRaster(Raster raster) {
        return GraphicsUtil.copyRaster(raster, raster.getMinX(), raster.getMinY());
    }

    public static WritableRaster copyRaster(Raster raster, int n, int n2) {
        WritableRaster writableRaster = Raster.createWritableRaster(raster.getSampleModel(), new Point(0, 0));
        writableRaster = writableRaster.createWritableChild(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY(), raster.getWidth(), raster.getHeight(), n, n2, null);
        DataBuffer dataBuffer = raster.getDataBuffer();
        DataBuffer dataBuffer2 = writableRaster.getDataBuffer();
        if (dataBuffer.getDataType() != dataBuffer2.getDataType()) {
            throw new IllegalArgumentException("New DataBuffer doesn't match original");
        }
        int n3 = dataBuffer.getSize();
        int n4 = dataBuffer.getNumBanks();
        int[] nArray = dataBuffer.getOffsets();
        for (int i = 0; i < n4; ++i) {
            switch (dataBuffer.getDataType()) {
                case 0: {
                    DataBuffer dataBuffer3 = (DataBufferByte)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferByte)dataBuffer2;
                    System.arraycopy(((DataBufferByte)dataBuffer3).getData(i), nArray[i], ((DataBufferByte)dataBuffer4).getData(i), nArray[i], n3);
                }
                case 3: {
                    DataBuffer dataBuffer3 = (DataBufferInt)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferInt)dataBuffer2;
                    System.arraycopy(((DataBufferInt)dataBuffer3).getData(i), nArray[i], ((DataBufferInt)dataBuffer4).getData(i), nArray[i], n3);
                }
                case 2: {
                    DataBuffer dataBuffer3 = (DataBufferShort)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferShort)dataBuffer2;
                    System.arraycopy(((DataBufferShort)dataBuffer3).getData(i), nArray[i], ((DataBufferShort)dataBuffer4).getData(i), nArray[i], n3);
                }
                case 1: {
                    DataBuffer dataBuffer3 = (DataBufferUShort)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferUShort)dataBuffer2;
                    System.arraycopy(((DataBufferUShort)dataBuffer3).getData(i), nArray[i], ((DataBufferUShort)dataBuffer4).getData(i), nArray[i], n3);
                }
            }
        }
        return writableRaster;
    }

    public static WritableRaster makeRasterWritable(Raster raster) {
        return GraphicsUtil.makeRasterWritable(raster, raster.getMinX(), raster.getMinY());
    }

    public static WritableRaster makeRasterWritable(Raster raster, int n, int n2) {
        WritableRaster writableRaster = Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), new Point(0, 0));
        writableRaster = writableRaster.createWritableChild(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY(), raster.getWidth(), raster.getHeight(), n, n2, null);
        return writableRaster;
    }

    public static ColorModel coerceColorModel(ColorModel colorModel, boolean bl) {
        if (colorModel.isAlphaPremultiplied() == bl) {
            return colorModel;
        }
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(1, 1);
        return colorModel.coerceData(writableRaster, bl);
    }

    public static ColorModel coerceData(WritableRaster writableRaster, ColorModel colorModel, boolean bl) {
        if (!colorModel.hasAlpha()) {
            return colorModel;
        }
        if (colorModel.isAlphaPremultiplied() == bl) {
            return colorModel;
        }
        if (bl) {
            GraphicsUtil.multiplyAlpha(writableRaster);
        } else {
            GraphicsUtil.divideAlpha(writableRaster);
        }
        return GraphicsUtil.coerceColorModel(colorModel, bl);
    }

    public static void multiplyAlpha(WritableRaster writableRaster) {
        if (GraphicsUtil.is_BYTE_COMP_Data(writableRaster.getSampleModel())) {
            GraphicsUtil.mult_BYTE_COMP_Data(writableRaster);
        } else if (GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), true)) {
            GraphicsUtil.mult_INT_PACK_Data(writableRaster);
        } else {
            int[] nArray = null;
            int n = writableRaster.getNumBands();
            float f = 0.003921569f;
            int n2 = writableRaster.getMinX();
            int n3 = n2 + writableRaster.getWidth();
            int n4 = writableRaster.getMinY();
            int n5 = n4 + writableRaster.getHeight();
            for (int i = n4; i < n5; ++i) {
                for (int j = n2; j < n3; ++j) {
                    int n6 = (nArray = writableRaster.getPixel(j, i, nArray))[n - 1];
                    if (n6 < 0 || n6 >= 255) continue;
                    float f2 = (float)n6 * f;
                    for (int k = 0; k < n - 1; ++k) {
                        nArray[k] = (int)((float)nArray[k] * f2 + 0.5f);
                    }
                    writableRaster.setPixel(j, i, nArray);
                }
            }
        }
    }

    public static void divideAlpha(WritableRaster writableRaster) {
        if (GraphicsUtil.is_BYTE_COMP_Data(writableRaster.getSampleModel())) {
            GraphicsUtil.divide_BYTE_COMP_Data(writableRaster);
        } else if (GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), true)) {
            GraphicsUtil.divide_INT_PACK_Data(writableRaster);
        } else {
            int n = writableRaster.getNumBands();
            int[] nArray = null;
            int n2 = writableRaster.getMinX();
            int n3 = n2 + writableRaster.getWidth();
            int n4 = writableRaster.getMinY();
            int n5 = n4 + writableRaster.getHeight();
            for (int i = n4; i < n5; ++i) {
                for (int j = n2; j < n3; ++j) {
                    int n6 = (nArray = writableRaster.getPixel(j, i, nArray))[n - 1];
                    if (n6 <= 0 || n6 >= 255) continue;
                    float f = 255.0f / (float)n6;
                    for (int k = 0; k < n - 1; ++k) {
                        nArray[k] = (int)((float)nArray[k] * f + 0.5f);
                    }
                    writableRaster.setPixel(j, i, nArray);
                }
            }
        }
    }

    public static boolean is_INT_PACK_Data(SampleModel sampleModel, boolean bl) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        if (sampleModel.getDataType() != 3) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        if (nArray.length == 3 ? bl : nArray.length != 4) {
            return false;
        }
        if (nArray[0] != 0xFF0000) {
            return false;
        }
        if (nArray[1] != 65280) {
            return false;
        }
        if (nArray[2] != 255) {
            return false;
        }
        return nArray.length != 4 || nArray[3] == -16777216;
    }

    public static boolean is_BYTE_COMP_Data(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return false;
        }
        return sampleModel.getDataType() == 0;
    }

    protected static void divide_INT_PACK_Data(WritableRaster writableRaster) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n = writableRaster.getWidth();
        int n2 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n3 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        for (int i = 0; i < writableRaster.getHeight(); ++i) {
            int n4;
            int n5 = n4 + n;
            for (n4 = n3 + i * n2; n4 < n5; ++n4) {
                int n6 = nArray[n4];
                int n7 = n6 >>> 24;
                if (n7 <= 0) {
                    nArray[n4] = 0xFFFFFF;
                    continue;
                }
                if (n7 >= 255) continue;
                int n8 = 0xFF0000 / n7;
                nArray[n4] = n7 << 24 | ((n6 & 0xFF0000) >> 16) * n8 & 0xFF0000 | (((n6 & 0xFF00) >> 8) * n8 & 0xFF0000) >> 8 | ((n6 & 0xFF) * n8 & 0xFF0000) >> 16;
            }
        }
    }

    protected static void mult_INT_PACK_Data(WritableRaster writableRaster) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n = writableRaster.getWidth();
        int n2 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n3 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        for (int i = 0; i < writableRaster.getHeight(); ++i) {
            int n4;
            int n5 = n4 + n;
            for (n4 = n3 + i * n2; n4 < n5; ++n4) {
                int n6 = nArray[n4];
                int n7 = n6 >>> 24;
                if (n7 < 0 || n7 >= 255) continue;
                nArray[n4] = n7 << 24 | (n6 & 0xFF0000) * n7 >> 8 & 0xFF0000 | (n6 & 0xFF00) * n7 >> 8 & 0xFF00 | (n6 & 0xFF) * n7 >> 8 & 0xFF;
            }
        }
    }

    protected static void divide_BYTE_COMP_Data(WritableRaster writableRaster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
        int n = writableRaster.getWidth();
        int n2 = componentSampleModel.getScanlineStride();
        int n3 = componentSampleModel.getPixelStride();
        int[] nArray = componentSampleModel.getBandOffsets();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n4 = dataBufferByte.getOffset() + componentSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int n5 = 0;
        int n6 = nArray[nArray.length - 1];
        int n7 = nArray.length - 1;
        byte[] byArray = dataBufferByte.getBankData()[0];
        for (int i = 0; i < writableRaster.getHeight(); ++i) {
            int n8;
            int n9 = n8 + n * n3;
            for (n8 = n4 + i * n2; n8 < n9; n8 += n3) {
                int n10;
                n5 = byArray[n8 + n6] & 0xFF;
                if (n5 == 0) {
                    for (n10 = 0; n10 < n7; ++n10) {
                        byArray[n8 + nArray[n10]] = -1;
                    }
                    continue;
                }
                if (n5 >= 255) continue;
                int n11 = 0xFF0000 / n5;
                for (n10 = 0; n10 < n7; ++n10) {
                    int n12 = n8 + nArray[n10];
                    byArray[n12] = (byte)((byArray[n12] & 0xFF) * n11 >>> 16);
                }
            }
        }
    }

    protected static void mult_BYTE_COMP_Data(WritableRaster writableRaster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
        int n = writableRaster.getWidth();
        int n2 = componentSampleModel.getScanlineStride();
        int n3 = componentSampleModel.getPixelStride();
        int[] nArray = componentSampleModel.getBandOffsets();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n4 = dataBufferByte.getOffset() + componentSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int n5 = 0;
        int n6 = nArray[nArray.length - 1];
        int n7 = nArray.length - 1;
        byte[] byArray = dataBufferByte.getBankData()[0];
        for (int i = 0; i < writableRaster.getHeight(); ++i) {
            int n8;
            int n9 = n8 + n * n3;
            for (n8 = n4 + i * n2; n8 < n9; n8 += n3) {
                n5 = byArray[n8 + n6] & 0xFF;
                if (n5 == 255) continue;
                for (int j = 0; j < n7; ++j) {
                    int n10 = n8 + nArray[j];
                    byArray[n10] = (byte)((byArray[n10] & 0xFF) * n5 >> 8);
                }
            }
        }
    }
}

