/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.popup;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.intellij.openapi.util.Comparing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactInfoList {
    public static final ArtifactInfoList EMPTY = new ArtifactInfoList(Collections.<ArtifactInfo>emptyList());
    private final List<ListDataListener> myListeners;
    private final List<ArtifactInfo> myValues;

    public ArtifactInfoList(@NotNull List<ArtifactInfo> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/popup/ArtifactInfoList.<init> must not be null");
        }
        this.myListeners = new CopyOnWriteArrayList<ListDataListener>();
        this.myValues = new ArrayList<ArtifactInfo>(list);
    }

    public synchronized void onInfoChanged(@NotNull ArtifactInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/popup/ArtifactInfoList.onInfoChanged must not be null");
        }
        int minChange = Integer.MAX_VALUE;
        int maxChange = Integer.MIN_VALUE;
        for (int i = 0; i < this.myValues.size(); ++i) {
            ArtifactInfo oldInfo = this.myValues.get(i);
            if (!Comparing.strEqual((String)oldInfo.getUrl(), (String)info.getUrl())) continue;
            this.myValues.set(i, info);
            if (i > maxChange) {
                maxChange = i;
            }
            if (i >= minChange) continue;
            minChange = i;
        }
        if (minChange <= maxChange) {
            this.fireValueChanged(minChange, maxChange);
        }
    }

    public synchronized List<String> getURLs() {
        ArrayList<String> urls = new ArrayList<String>();
        for (ArtifactInfo info : this.myValues) {
            urls.add(info.getUrl());
        }
        return urls;
    }

    private void fireValueChanged(int minChange, int maxChange) {
        ListDataEvent event = new ListDataEvent(this, 0, minChange, maxChange);
        for (ListDataListener listDataListener : this.myListeners) {
            listDataListener.contentsChanged(event);
        }
    }

    public synchronized void addListDataListener(ListDataListener l) {
        this.myListeners.add(l);
    }

    public synchronized void removeListDataListener(ListDataListener l) {
        this.myListeners.remove(l);
    }

    public synchronized List<ArtifactInfo> getValuesSnapshot() {
        return Collections.unmodifiableList(this.myValues);
    }
}

