/*
 * Decompiled with CFR 0.152.
 */
package conf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import values.BrickColor;
import values.Settings;

public class Dialog
extends JDialog
implements ActionListener {
    private Settings settings;
    private JSpinner move;
    private JSpinner fire;
    private JComboBox locale;
    private JComboBox laf;
    private JComboBox theme;
    private Map<String, String> localeList;
    private Map<String, String> lafList;
    private Map<String, Integer> themeList;
    private boolean reInitRequired = false;

    public Dialog(Settings settings) {
        Object object;
        Object object2;
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
        this.settings = settings;
        this.setDefaultCloseOperation(2);
        this.setTitle(settings.getString("TITLE_CONF"));
        this.getOwner().setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("images/icon.png")).getImage());
        JLabel jLabel = new JLabel(settings.getString("CONF_MOVE_DELAY"));
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(settings.getMoveDelay(), 0, Integer.MAX_VALUE, 5);
        this.move = new JSpinner(spinnerNumberModel);
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.move.getEditor()).getTextField();
        jFormattedTextField.setEditable(false);
        jFormattedTextField.setBackground(Color.white);
        JLabel jLabel2 = new JLabel(settings.getString("CONF_FIRE_DELAY"));
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(settings.getFireDelay(), 0, Integer.MAX_VALUE, 25);
        this.fire = new JSpinner(spinnerNumberModel2);
        JFormattedTextField jFormattedTextField2 = ((JSpinner.DefaultEditor)this.fire.getEditor()).getTextField();
        jFormattedTextField2.setEditable(false);
        jFormattedTextField2.setBackground(Color.white);
        JLabel jLabel3 = new JLabel(settings.getString("CONF_LOCALE"));
        this.localeList = new HashMap<String, String>();
        this.localeList.put(settings.getString("CONF_AUTO"), "auto");
        String string = settings.getString("LANGUAGE");
        for (String string2 : string.split(";")) {
            String[] stringArray = string2.split(",");
            if (stringArray.length > 1) {
                this.localeList.put(stringArray[0], stringArray[1]);
                continue;
            }
            this.localeList.put(stringArray[0], "");
        }
        this.locale = new JComboBox<Object>(this.localeList.keySet().toArray());
        for (int i = 0; i < this.locale.getItemCount(); ++i) {
            if (!this.localeList.get(this.locale.getItemAt(i)).equals(settings.getLocale())) continue;
            this.locale.setSelectedIndex(i);
            break;
        }
        JLabel jLabel4 = new JLabel(settings.getString("CONF_LAF"));
        this.lafList = new HashMap<String, String>();
        this.lafList.put(settings.getString("CONF_AUTO"), "auto");
        for (UIManager.LookAndFeelInfo object32 : lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels()) {
            object2 = object32.getName();
            object = object32.getClassName();
            this.lafList.put((String)object2, (String)object);
        }
        this.laf = new JComboBox<Object>(this.lafList.keySet().toArray());
        for (int i = 0; i < this.laf.getItemCount(); ++i) {
            if (!this.lafList.get(this.laf.getItemAt(i)).equals(UIManager.getLookAndFeel().getClass().getName())) continue;
            this.laf.setSelectedIndex(i);
            break;
        }
        JLabel jLabel5 = new JLabel(settings.getString("CONF_THEME"));
        this.themeList = new LinkedHashMap<String, Integer>();
        this.themeList.put(settings.getString("THEME_MODERN"), 1);
        this.themeList.put(settings.getString("THEME_CLASSIC"), 2);
        this.themeList.put(settings.getString("THEME_CIRCLES"), 3);
        this.theme = new JComboBox<Object>(this.themeList.keySet().toArray());
        this.theme.setSelectedIndex(this.settings.getThemeIndex() - 1);
        JButton jButton = new JButton();
        jButton.setText("Ok");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton();
        jButton2.setText(settings.getString("CANCEL"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Dialog.this.setVisible(false);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        object2 = new JPanel();
        ((Container)object2).setLayout(new GridLayout(5, 1));
        ((Container)object2).add(jLabel);
        ((Container)object2).add(jLabel2);
        ((Container)object2).add(jLabel3);
        ((Container)object2).add(jLabel4);
        ((Container)object2).add(jLabel5);
        object = new JPanel();
        ((Container)object).setLayout(new GridLayout(5, 1));
        ((Container)object).add(this.move);
        ((Container)object).add(this.fire);
        ((Container)object).add(this.locale);
        ((Container)object).add(this.laf);
        ((Container)object).add(this.theme);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add((Component)object2);
        jPanel2.add((Component)object);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 3));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(9, 9, 0, 9));
        jPanel3.add(jPanel2);
        jPanel3.add(jPanel);
        this.setContentPane(jPanel3);
        this.pack();
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setModal(true);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        String string;
        Integer n2 = (Integer)this.move.getValue();
        if (this.settings.getMoveDelay() != n2.intValue()) {
            this.settings.setMoveDelay(n2);
        }
        n2 = (Integer)this.fire.getValue();
        if (this.settings.getFireDelay() != n2.intValue()) {
            this.settings.setFireDelay(n2);
        }
        if (!(string = this.localeList.get(this.locale.getSelectedItem())).equals(this.settings.getLocale())) {
            if ("auto".equals(string)) {
                this.settings.cleanLocale();
            } else {
                this.settings.setLocale(string);
            }
        }
        if (!(string = this.lafList.get(this.laf.getSelectedItem())).equals(UIManager.getLookAndFeel().getClass().getName())) {
            if ("auto".equals(string)) {
                this.settings.cleanLaF();
                string = this.settings.getDefaultLaF();
            } else {
                this.settings.setLaF(string);
            }
            try {
                UIManager.setLookAndFeel(string);
            }
            catch (Exception exception) {
                System.out.println(this.settings.getString("ERROR_LAF"));
            }
        }
        if ((n = this.themeList.get(this.theme.getSelectedItem()).intValue()) != this.settings.getThemeIndex()) {
            this.settings.setThemeIndex(n);
            BrickColor.init(n);
            this.reInitRequired = true;
        }
        this.setVisible(false);
    }

    public boolean isReInitRequired() {
        return this.reInitRequired;
    }
}

