/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.ui.rest;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.admin.ui.rest.RoleMappingResource;
import org.keycloak.admin.ui.rest.model.Authentication;
import org.keycloak.admin.ui.rest.model.AuthenticationMapper;
import org.keycloak.admin.ui.rest.model.ConfigurableRequiredActionProviderRepresentation;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class AuthenticationManagementResource
extends RoleMappingResource {
    private static final Logger logger = Logger.getLogger(AuthenticationManagementResource.class);

    public AuthenticationManagementResource(KeycloakSession session, RealmModel realm, AdminPermissionEvaluator auth) {
        super(session, realm, auth);
    }

    @GET
    @Path(value="/flows")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all authentication flows for this realm", description="This endpoint returns all the authentication flows and lists if there they are used.")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=Authentication.class, type=SchemaType.ARRAY))})
    public final List<Authentication> listIdentityProviders() {
        this.auth.realm().requireViewAuthenticationFlows();
        return this.realm.getAuthenticationFlowsStream().filter(flow -> flow.isTopLevel() && !Objects.equals(flow.getAlias(), "saml ecp")).map(flow -> AuthenticationMapper.convertToModel(this.session, flow, this.realm)).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{type}/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all clients or identity providers that this flow is used by", description="List all the clients or identity providers this flow is used by as a paginated list")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=String.class, type=SchemaType.ARRAY))})
    public final List<String> listUsed(@PathParam(value="id") String id, @PathParam(value="type") String type, @QueryParam(value="first") @DefaultValue(value="0") int first, @QueryParam(value="max") @DefaultValue(value="10") int max, @QueryParam(value="search") @DefaultValue(value="") String search) {
        this.auth.realm().requireViewAuthenticationFlows();
        AuthenticationFlowModel flow = this.realm.getAuthenticationFlowsStream().filter(f -> id.equals(f.getId())).toList().get(0);
        if ("clients".equals(type)) {
            Stream clients = this.realm.getClientsStream();
            return clients.filter(c -> c.getAuthenticationFlowBindingOverrides().get("browser") != null && ((String)c.getAuthenticationFlowBindingOverrides().get("browser")).equals(flow.getId()) || c.getAuthenticationFlowBindingOverrides().get("direct_grant") != null && ((String)c.getAuthenticationFlowBindingOverrides().get("direct_grant")).equals(flow.getId())).map(ClientModel::getClientId).filter(f -> f.contains(search)).skip("".equals(search) ? (long)first : 0L).limit(max).collect(Collectors.toList());
        }
        if ("idp".equals(type)) {
            return this.session.identityProviders().getByFlow(flow.getId(), search, Integer.valueOf(first), Integer.valueOf(max)).toList();
        }
        throw new IllegalArgumentException("Invalid type");
    }

    @Path(value="required-actions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="List all required actions for this realm.", description="List all required actions for this realm with Admin UI specific metadata.")
    public Stream<RequiredActionProviderRepresentation> getRequiredActions() {
        this.auth.realm().requireViewRequiredActions();
        return this.realm.getRequiredActionProvidersStream().map(this::toRepresentation);
    }

    public ConfigurableRequiredActionProviderRepresentation toRepresentation(RequiredActionProviderModel model) {
        ConfigurableRequiredActionProviderRepresentation rep = new ConfigurableRequiredActionProviderRepresentation();
        rep.setAlias(model.getAlias());
        rep.setProviderId(model.getProviderId());
        rep.setName(model.getName());
        rep.setDefaultAction(model.isDefaultAction());
        rep.setPriority(model.getPriority());
        rep.setEnabled(model.isEnabled());
        rep.setConfig(model.getConfig());
        RequiredActionFactory factory = (RequiredActionFactory)this.session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, model.getProviderId());
        if (factory != null) {
            rep.setConfigurable(factory.isConfigurable());
        } else {
            logger.warnv("Detected RequiredAction with missing provider. realm={0}, alias={1}, providerId={2}", (Object)this.realm.getName(), (Object)model.getAlias(), (Object)model.getProviderId());
        }
        return rep;
    }
}

