/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.representations.idm.UserProfileAttributeGroupMetadata;
import org.keycloak.representations.idm.UserProfileAttributeMetadata;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.representations.userprofile.config.UPGroup;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.AttributeGroupMetadata;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.AttributeValidatorMetadata;
import org.keycloak.userprofile.Attributes;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileMetadata;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.validate.Validators;

public class UserProfileUtil {
    private static final Logger logger = Logger.getLogger(UserProfileUtil.class);
    public static final String USER_METADATA_GROUP = "user-metadata";
    public static final Predicate<AttributeContext> ONLY_ADMIN_CONDITION = context -> context.getContext().isAdminContext();

    public static AttributeGroupMetadata lookupUserMetadataGroup(KeycloakSession session) {
        UserProfileProvider provider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
        UPConfig config = provider.getConfiguration();
        return config.getGroups().stream().filter(upGroup -> USER_METADATA_GROUP.equals(upGroup.getName())).map(upGroup -> new AttributeGroupMetadata(upGroup.getName(), upGroup.getDisplayHeader(), upGroup.getDisplayDescription(), upGroup.getAnnotations())).findAny().orElse(null);
    }

    public static AttributeMetadata createAttributeMetadata(String attrName, UserProfileMetadata metadata, AttributeGroupMetadata metadataGroup, int guiOrder, String storageProviderName) {
        return UserProfileUtil.createAttributeMetadata(attrName, metadata, metadataGroup, ONLY_ADMIN_CONDITION, AttributeMetadata.ALWAYS_FALSE, guiOrder, storageProviderName);
    }

    public static AttributeMetadata createAttributeMetadata(String attrName, UserProfileMetadata metadata, int guiOrder, String storageProviderName) {
        return UserProfileUtil.createAttributeMetadata(attrName, metadata, null, ONLY_ADMIN_CONDITION, ONLY_ADMIN_CONDITION, guiOrder, storageProviderName);
    }

    private static AttributeMetadata createAttributeMetadata(String attrName, UserProfileMetadata metadata, AttributeGroupMetadata metadataGroup, Predicate<AttributeContext> readCondition, Predicate<AttributeContext> writeCondition, int guiOrder, String storageProviderName) {
        if (metadata.getAttribute(attrName).isEmpty()) {
            logger.tracef("Adding metadata attribute '%s' to user profile by user storage provider '%s' for user profile context '%s'.", (Object)attrName, (Object)storageProviderName, (Object)metadata.getContext().toString());
            AttributeMetadata attributeMetadata = new AttributeMetadata(attrName, guiOrder).setValidators(Collections.emptyList()).addWriteCondition(writeCondition).addReadCondition(readCondition).setRequired(AttributeMetadata.ALWAYS_FALSE);
            if (metadataGroup != null) {
                attributeMetadata.setAttributeGroupMetadata(metadataGroup);
            }
            return attributeMetadata;
        }
        logger.tracef("Ignore adding metadata attribute '%s' to user profile by user storage provider '%s' as attribute is already defined on user profile.", (Object)attrName, (Object)storageProviderName);
        return null;
    }

    public static boolean isRootAttribute(String name) {
        return "username".equals(name) || "email".equals(name) || "firstName".equals(name) || "lastName".equals(name) || "locale".equals(name);
    }

    public static org.keycloak.representations.idm.UserProfileMetadata createUserProfileMetadata(KeycloakSession session, UserProfile profile) {
        Attributes profileAttributes = profile.getAttributes();
        Map am = profileAttributes.getReadable();
        if (am == null) {
            return null;
        }
        Map unmanagedAttributes = profileAttributes.getUnmanagedAttributes();
        List attributes = am.keySet().stream().map(arg_0 -> ((Attributes)profileAttributes).getMetadata(arg_0)).filter(Objects::nonNull).filter(attributeMetadata -> !unmanagedAttributes.containsKey(attributeMetadata.getName())).sorted(Comparator.comparingInt(AttributeMetadata::getGuiOrder)).map(sam -> UserProfileUtil.toRestMetadata(sam, session, profile)).collect(Collectors.toList());
        UserProfileProvider provider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
        UPConfig config = provider.getConfiguration();
        List groups = config.getGroups().stream().map(new Function<UPGroup, UserProfileAttributeGroupMetadata>(){

            @Override
            public UserProfileAttributeGroupMetadata apply(UPGroup upGroup) {
                return new UserProfileAttributeGroupMetadata(upGroup.getName(), upGroup.getDisplayHeader(), upGroup.getDisplayDescription(), upGroup.getAnnotations());
            }
        }).collect(Collectors.toList());
        return new org.keycloak.representations.idm.UserProfileMetadata(attributes, groups);
    }

    private static UserProfileAttributeMetadata toRestMetadata(AttributeMetadata am, KeycloakSession session, UserProfile profile) {
        String group = null;
        if (am.getAttributeGroupMetadata() != null) {
            group = am.getAttributeGroupMetadata().getName();
        }
        return new UserProfileAttributeMetadata(am.getName(), am.getAttributeDisplayName(), profile.getAttributes().isRequired(am.getName()), profile.getAttributes().isReadOnly(am.getName()), group, am.getAnnotations(), UserProfileUtil.toValidatorMetadata(am, session), am.isMultivalued());
    }

    private static Map<String, Map<String, Object>> toValidatorMetadata(AttributeMetadata am, KeycloakSession session) {
        return am.getValidators() == null ? null : am.getValidators().stream().filter(avm -> Validators.validator((KeycloakSession)session, (String)avm.getValidatorId()) instanceof ConfiguredProvider).collect(Collectors.toMap(AttributeValidatorMetadata::getValidatorId, AttributeValidatorMetadata::getValidatorConfig));
    }
}

