/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AnnotationsTransformationContext;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.InjectionPointsTransformer;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.Type;

public class InjectionPointModifier {
    private List<InjectionPointsTransformer> transformers;
    private BuildExtension.BuildContext buildContext;

    InjectionPointModifier(List<InjectionPointsTransformer> transformers, BuildExtension.BuildContext buildContext) {
        this.buildContext = buildContext;
        this.transformers = transformers;
    }

    public Set<AnnotationInstance> applyTransformers(Type type, AnnotationTarget target, AnnotationTarget methodParameterTarget, Set<AnnotationInstance> qualifiers) {
        if (this.transformers.isEmpty()) {
            return qualifiers;
        }
        TransformationContextImpl transformationContext = new TransformationContextImpl(this.buildContext, target, methodParameterTarget, qualifiers);
        for (InjectionPointsTransformer transformer : this.transformers) {
            if (!transformer.appliesTo(type)) continue;
            transformer.transform(transformationContext);
        }
        if (methodParameterTarget != null && AnnotationTarget.Kind.METHOD_PARAMETER.equals((Object)methodParameterTarget.kind())) {
            return transformationContext.getQualifiers().stream().filter(annotationInstance -> methodParameterTarget.equals(annotationInstance.target())).collect(Collectors.toSet());
        }
        return transformationContext.getQualifiers();
    }

    public Set<AnnotationInstance> applyTransformers(Type type, AnnotationTarget target, Set<AnnotationInstance> qualifiers) {
        return this.applyTransformers(type, target, null, qualifiers);
    }

    static class TransformationContextImpl
    extends AnnotationsTransformationContext<Set<AnnotationInstance>>
    implements InjectionPointsTransformer.TransformationContext {
        public TransformationContextImpl(BuildExtension.BuildContext buildContext, AnnotationTarget target, AnnotationTarget methodParameterTarget, Set<AnnotationInstance> annotations) {
            super(buildContext, target, methodParameterTarget, annotations);
        }

        @Override
        public InjectionPointsTransformer.Transformation transform() {
            return new InjectionPointsTransformer.Transformation((Set<AnnotationInstance>)new HashSet<AnnotationInstance>((Collection<AnnotationInstance>)this.getAnnotations()), this.getAnnotationTarget(), this::setAnnotations);
        }

        @Override
        public Set<AnnotationInstance> getQualifiers() {
            return (Set)this.getAnnotations();
        }
    }
}

