/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.tracing;

import java.util.Set;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.config.Option;
import org.keycloak.config.TracingOptions;
import org.keycloak.connections.httpclient.DefaultHttpClientFactory;
import org.keycloak.connections.httpclient.HttpClientBuilder;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.Provider;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.tracing.OTelHttpClientBuilder;
import org.keycloak.quarkus.runtime.tracing.OTelTracingProvider;
import org.keycloak.tracing.TracingProvider;

public class OTelHttpClientFactory
extends DefaultHttpClientFactory
implements EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "opentelemetry";
    private static OTelHttpClientBuilder BUILDER_SINGLETON;

    public String getId() {
        return PROVIDER_ID;
    }

    public HttpClientProvider create(KeycloakSession session) {
        if (BUILDER_SINGLETON == null) {
            BUILDER_SINGLETON = new OTelHttpClientBuilder((OTelTracingProvider)session.getProvider(TracingProvider.class));
        }
        return super.create(session);
    }

    protected HttpClientBuilder newHttpClientBuilder() {
        return BUILDER_SINGLETON;
    }

    public void init(Config.Scope config) {
        super.init(config.scope(new String[]{"connectionsHttpClient", "default"}));
    }

    public int order() {
        return super.order() + 10;
    }

    public Set<Class<? extends Provider>> dependsOn() {
        return Set.of(TracingProvider.class);
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.OPENTELEMETRY) && Configuration.isTrue((Option<Boolean>)TracingOptions.TRACING_ENABLED);
    }
}

