/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray.index.full;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.index.NDIndex;
import ai.djl.ndarray.index.dim.NDIndexAll;
import ai.djl.ndarray.index.dim.NDIndexElement;
import ai.djl.ndarray.index.dim.NDIndexTake;
import ai.djl.ndarray.types.Shape;
import java.util.Optional;

public final class NDIndexFullTake {
    private NDArray indices;
    private int axis;

    private NDIndexFullTake(NDArray indices, int axis) {
        this.indices = indices;
        this.axis = axis;
    }

    public static Optional<NDIndexFullTake> fromIndex(NDIndex index, Shape target) {
        int axis = 0;
        NDIndexFullTake fullTake = null;
        for (NDIndexElement el : index.getIndices()) {
            if (el instanceof NDIndexAll) {
                ++axis;
                continue;
            }
            if (el instanceof NDIndexTake) {
                if (fullTake != null) {
                    throw new UnsupportedOperationException("Only one take per get is currently supported.If this is triggered by array NDIndex: get(NDIndex array), then you should be aware of the following changes. 1. previously this was equivalent to .get(new NDIndex().addPickDim(array)), but now equivalent to .take(array). So please check if you want to restore the previous behaviour ie .get(new NDIndex().addPickDim(array)). If so do it explicitly. 2. Check if the array index is supposed to be boolean index. If so, remember to change the datatype of index to boolean. Or you can explicitly do new NDIndex().addBooleanIndex(array)");
                }
                NDArray indexElem = ((NDIndexTake)el).getIndex();
                if (!indexElem.getShape().isRankOne()) {
                    throw new UnsupportedOperationException("Only rank-1 indexing array is supported for take. If this is triggered by array NDIndex: get(NDIndex array), then you should be aware of the following changes. 1. previously this was equivalent to .get(new NDIndex().addPickDim(array)), but now equivalent to .take(array). So please check if you want to restore the previous behaviour ie .get(new NDIndex().addPickDim(array)). If so do it explicitly. 2. Check if the array index is supposed to be boolean index. If so, remember to change the datatype of index to boolean. Or you can explicitly do new NDIndex().addBooleanIndex(array)");
                }
                fullTake = new NDIndexFullTake(indexElem, axis);
                continue;
            }
            return Optional.empty();
        }
        return Optional.ofNullable(fullTake);
    }

    public NDArray getIndices() {
        return this.indices;
    }

    public int getAxis() {
        return this.axis;
    }
}

