/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.kernel;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import org.tribuo.math.kernel.Kernel;
import org.tribuo.math.la.SparseVector;

public class Polynomial
implements Kernel {
    private static final long serialVersionUID = 1L;
    @Config(mandatory=true, description="Coefficient to multiply the dot product by.")
    private double gamma;
    @Config(mandatory=true, description="Scalar to add to the dot product.")
    private double intercept;
    @Config(mandatory=true, description="Degree of the polynomial.")
    private double degree;

    private Polynomial() {
    }

    public Polynomial(double gamma, double intercept, double degree) {
        this.gamma = gamma;
        this.intercept = intercept;
        this.degree = degree;
    }

    @Override
    public double similarity(SparseVector a, SparseVector b) {
        return Math.pow(this.gamma * a.dot(b) + this.intercept, this.degree);
    }

    public String toString() {
        return "Polynomial(gamma=" + this.gamma + ",intercept=" + this.intercept + ",degree=" + this.degree + ")";
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "Kernel");
    }
}

