/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.action;

import com.o19s.es.ltr.feature.store.index.IndexFeatureStore;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestBuilder;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.master.MasterNodeReadRequest;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class ListStoresAction
extends ActionType<ListStoresActionResponse> {
    public static final String NAME = "cluster:admin/ltr/featurestore/list";
    public static final ListStoresAction INSTANCE = new ListStoresAction();

    private ListStoresAction() {
        super(NAME, ListStoresActionResponse::new);
    }

    public Writeable.Reader<ListStoresActionResponse> getResponseReader() {
        return ListStoresActionResponse::new;
    }

    public static class ListStoresActionBuilder
    extends ActionRequestBuilder<ListStoresActionRequest, ListStoresActionResponse> {
        public ListStoresActionBuilder(OpenSearchClient client) {
            super(client, (ActionType)INSTANCE, (ActionRequest)new ListStoresActionRequest());
        }
    }

    public static class IndexStoreInfo
    implements Writeable,
    ToXContent {
        private String storeName;
        private String indexName;
        private int version;
        private Map<String, Integer> counts;

        public IndexStoreInfo(String indexName, int version, Map<String, Integer> counts) {
            this.indexName = Objects.requireNonNull(indexName);
            this.storeName = IndexFeatureStore.storeName(indexName);
            this.version = version;
            this.counts = counts;
        }

        public IndexStoreInfo(StreamInput in) throws IOException {
            this.storeName = in.readString();
            this.indexName = in.readString();
            this.version = in.readVInt();
            this.counts = in.readMap(StreamInput::readString, StreamInput::readVInt);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.storeName);
            out.writeString(this.indexName);
            out.writeVInt(this.version);
            out.writeMap(this.counts, StreamOutput::writeString, StreamOutput::writeVInt);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("store", this.storeName).field("index", this.indexName).field("version", this.version).field("counts", this.counts).endObject();
        }

        public String getStoreName() {
            return this.storeName;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public int getVersion() {
            return this.version;
        }

        public Map<String, Integer> getCounts() {
            return this.counts;
        }
    }

    public static class ListStoresActionResponse
    extends ActionResponse
    implements ToXContentObject {
        private Map<String, IndexStoreInfo> stores;

        ListStoresActionResponse() {
        }

        ListStoresActionResponse(StreamInput in) throws IOException {
            super(in);
            this.stores = in.readMap(StreamInput::readString, IndexStoreInfo::new);
        }

        public ListStoresActionResponse(List<IndexStoreInfo> info) {
            this.stores = info.stream().collect(Collectors.toMap(i -> i.storeName, i -> i));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("stores", this.stores).endObject();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.stores, StreamOutput::writeString, (w, i) -> i.writeTo(w));
        }

        public Map<String, IndexStoreInfo> getStores() {
            return this.stores;
        }
    }

    public static class ListStoresActionRequest
    extends MasterNodeReadRequest<ListStoresActionRequest> {
        public ActionRequestValidationException validate() {
            return null;
        }

        public ListStoresActionRequest() {
        }

        public ListStoresActionRequest(StreamInput in) throws IOException {
            super(in);
        }
    }
}

