/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.rest;

import com.o19s.es.ltr.action.ListStoresAction;
import com.o19s.es.ltr.feature.store.index.IndexFeatureStore;
import com.o19s.es.ltr.rest.FeatureStoreBaseRestHandler;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ltr.settings.LTRSettings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestBuilderListener;
import org.opensearch.rest.action.RestToXContentListener;

public class RestStoreManager
extends FeatureStoreBaseRestHandler {
    public String getName() {
        return "Manage the LtR store";
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.PUT, "/_ltr/{store}"), new RestHandler.Route(RestRequest.Method.PUT, "/_ltr"), new RestHandler.Route(RestRequest.Method.POST, "/_ltr/{store}"), new RestHandler.Route(RestRequest.Method.POST, "/_ltr"), new RestHandler.Route(RestRequest.Method.DELETE, "/_ltr/{store}"), new RestHandler.Route(RestRequest.Method.DELETE, "/_ltr"), new RestHandler.Route(RestRequest.Method.GET, "/_ltr"), new RestHandler.Route(RestRequest.Method.GET, "/_ltr/{store}")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!LTRSettings.isLTRPluginEnabled()) {
            throw new IllegalStateException("LTR plugin is disabled. To enable, update ltr.plugin.enabled to true");
        }
        String indexName = this.indexName(request);
        if (request.method() == RestRequest.Method.PUT) {
            if (request.hasParam("store")) {
                IndexFeatureStore.validateFeatureStoreName(request.param("store"));
            }
            return this.createIndex(client, indexName);
        }
        if (request.method() == RestRequest.Method.POST) {
            if (request.hasParam("store")) {
                IndexFeatureStore.validateFeatureStoreName(request.param("store"));
            }
            throw new IllegalArgumentException("Updating a feature store is not yet supported.");
        }
        if (request.method() == RestRequest.Method.DELETE) {
            return this.deleteIndex(client, indexName);
        }
        assert (request.method() == RestRequest.Method.GET);
        if (request.hasParam("store")) {
            return this.getStore(client, indexName);
        }
        return this.listStores(client);
    }

    BaseRestHandler.RestChannelConsumer listStores(NodeClient client) {
        return channel -> {
            try (ThreadContext.StoredContext threadContext = client.threadPool().getThreadContext().stashContext();){
                RestToXContentListener listStoresListener = new RestToXContentListener(channel);
                ActionListener wrappedListener = ActionListener.runBefore((ActionListener)listStoresListener, () -> threadContext.restore());
                new ListStoresAction.ListStoresActionBuilder((OpenSearchClient)client).execute(wrappedListener);
            }
            catch (Exception e) {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
            }
        };
    }

    BaseRestHandler.RestChannelConsumer getStore(NodeClient client, String indexName) {
        return channel -> {
            try (ThreadContext.StoredContext threadContext = client.threadPool().getThreadContext().stashContext();){
                RestBuilderListener<IndicesExistsResponse> existsListener = new RestBuilderListener<IndicesExistsResponse>(channel){

                    public RestResponse buildResponse(IndicesExistsResponse indicesExistsResponse, XContentBuilder builder) throws Exception {
                        builder.startObject().field("exists", indicesExistsResponse.isExists()).endObject().close();
                        return new BytesRestResponse(indicesExistsResponse.isExists() ? RestStatus.OK : RestStatus.NOT_FOUND, builder);
                    }
                };
                ActionListener wrappedListener = ActionListener.runBefore((ActionListener)existsListener, () -> threadContext.restore());
                client.admin().indices().prepareExists(new String[]{indexName}).execute(wrappedListener);
            }
            catch (Exception e) {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
            }
        };
    }

    BaseRestHandler.RestChannelConsumer createIndex(NodeClient client, String indexName) {
        return channel -> client.admin().indices().create(IndexFeatureStore.buildIndexRequest(indexName), (ActionListener)new RestToXContentListener(channel));
    }

    BaseRestHandler.RestChannelConsumer deleteIndex(NodeClient client, String indexName) {
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(indexName);
        return channel -> {
            try (ThreadContext.StoredContext threadContext = client.threadPool().getThreadContext().stashContext();){
                ActionListener wrappedListener = ActionListener.runBefore((ActionListener)new RestToXContentListener(channel), () -> threadContext.restore());
                client.admin().indices().delete(deleteIndexRequest, wrappedListener);
            }
            catch (Exception e) {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
            }
        };
    }
}

