/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.model.monitor;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.alerting.action.DocLevelMonitorFanOutRequest;
import org.opensearch.commons.alerting.action.DocLevelMonitorFanOutResponse;
import org.opensearch.commons.alerting.model.InputRunResults;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.MonitorRunResult;
import org.opensearch.commons.alerting.model.remote.monitors.RemoteDocLevelMonitorInput;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.securityanalytics.threatIntel.iocscan.dto.IocScanContext;
import org.opensearch.securityanalytics.threatIntel.iocscan.service.SaIoCScanService;
import org.opensearch.securityanalytics.threatIntel.model.monitor.ThreatIntelInput;
import org.opensearch.securityanalytics.threatIntel.service.SATIFSourceConfigService;
import org.opensearch.securityanalytics.threatIntel.util.ThreatIntelMonitorUtils;
import org.opensearch.securityanalytics.util.IndexUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportThreatIntelMonitorFanOutAction
extends HandledTransportAction<DocLevelMonitorFanOutRequest, DocLevelMonitorFanOutResponse> {
    private static final Logger log = LogManager.getLogger(TransportThreatIntelMonitorFanOutAction.class);
    private final ClusterService clusterService;
    private final Settings settings;
    private final SATIFSourceConfigService saTifSourceConfigService;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final SaIoCScanService saIoCScanService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportThreatIntelMonitorFanOutAction(TransportService transportService, Client client, NamedXContentRegistry xContentRegistry, ClusterService clusterService, Settings settings, ActionFilters actionFilters, SATIFSourceConfigService saTifSourceConfigService, SaIoCScanService saIoCScanService, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/opensearch/securityanalytics/threatintel/monitors/fanout", transportService, actionFilters, DocLevelMonitorFanOutRequest::new);
        this.clusterService = clusterService;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.settings = settings;
        this.saTifSourceConfigService = saTifSourceConfigService;
        this.saIoCScanService = saIoCScanService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    protected void doExecute(Task task, DocLevelMonitorFanOutRequest request, ActionListener<DocLevelMonitorFanOutResponse> actionListener) {
        try {
            Monitor monitor = request.getMonitor();
            MonitorRunResult monitorResult = new MonitorRunResult(monitor.getName(), Instant.now(), Instant.now(), null, new InputRunResults(Collections.emptyList(), null, null), Collections.emptyMap());
            this.saTifSourceConfigService.getIocTypeToIndices((ActionListener<Map<String, List<String>>>)ActionListener.wrap(iocTypeToIndicesMap -> this.onGetIocTypeToIndices((Map<String, List<String>>)iocTypeToIndicesMap, request, actionListener), e -> {
                log.error(() -> new ParameterizedMessage("Unexpected Failure in threat intel monitor {} fan out action while fetching threat intel ioc indices", (Object)request.getMonitor().getId()), (Throwable)e);
                actionListener.onResponse((Object)new DocLevelMonitorFanOutResponse(this.clusterService.localNode().getId(), request.getExecutionId(), request.getMonitor().getId(), request.getMonitorMetadata().getLastRunContext(), new InputRunResults(Collections.emptyList(), null, null), Collections.emptyMap(), new AlertingException("Fan action of threat intel monitor failed", RestStatus.INTERNAL_SERVER_ERROR, e)));
            }));
        }
        catch (Exception ex) {
            log.error(() -> new ParameterizedMessage("Unexpected Failure in threat intel monitor {} fan out action", (Object)request.getMonitor().getId()), (Throwable)ex);
            actionListener.onFailure(ex);
        }
    }

    private void onGetIocTypeToIndices(Map<String, List<String>> iocTypeToIndicesMap, DocLevelMonitorFanOutRequest request, ActionListener<DocLevelMonitorFanOutResponse> actionListener) throws IOException {
        RemoteDocLevelMonitorInput remoteDocLevelMonitorInput = (RemoteDocLevelMonitorInput)request.getMonitor().getInputs().get(0);
        List indices = remoteDocLevelMonitorInput.getDocLevelMonitorInput().getIndices();
        ThreatIntelInput threatIntelInput = ThreatIntelMonitorUtils.getThreatIntelInputFromBytesReference(remoteDocLevelMonitorInput.getInput(), this.xContentRegistry);
        ArrayList<String> fieldsToFetch = new ArrayList<String>();
        threatIntelInput.getPerIocTypeScanInputList().forEach(perIocTypeScanInput -> perIocTypeScanInput.getIndexToFieldsMap().values().forEach(fieldsToFetch::addAll));
        Map updatedLastRunContext = request.getMonitorMetadata().getLastRunContext();
        BiConsumer<ShardId, String> lastRunContextUpdateConsumer = (shardId, value) -> {
            String indexName = shardId.getIndexName();
            if (updatedLastRunContext.containsKey(indexName)) {
                HashMap<String, String> context = updatedLastRunContext.putIfAbsent(indexName, new HashMap());
                context.put(String.valueOf(shardId.getId()), (String)value);
            } else {
                log.error("monitor metadata for threat intel monitor {} expected to contain last run context for index {}", (Object)request.getMonitor().getId(), (Object)indexName);
            }
        };
        ActionListener searchHitsListener = ActionListener.wrap(hits -> {
            if (hits.isEmpty()) {
                actionListener.onResponse((Object)new DocLevelMonitorFanOutResponse(this.clusterService.localNode().getId(), request.getExecutionId(), request.getMonitor().getId(), updatedLastRunContext, new InputRunResults(Collections.emptyList(), null, null), Collections.emptyMap(), null));
                return;
            }
            BiConsumer<Object, Exception> resultConsumer = (r, e) -> {
                if (e == null) {
                    actionListener.onResponse((Object)new DocLevelMonitorFanOutResponse(this.clusterService.localNode().getId(), request.getExecutionId(), request.getMonitor().getId(), updatedLastRunContext, new InputRunResults(Collections.emptyList(), null, null), Collections.emptyMap(), null));
                } else {
                    actionListener.onFailure(e);
                }
            };
            Map<String, List<String>> concreteindexToMonitorInputIndicesMap = IndexUtils.getConcreteindexToMonitorInputIndicesMap(remoteDocLevelMonitorInput.getDocLevelMonitorInput().getIndices(), this.clusterService, this.indexNameExpressionResolver);
            this.saIoCScanService.scanIoCs(new IocScanContext(request.getMonitor(), request.getMonitorMetadata(), false, hits, threatIntelInput, indices, iocTypeToIndicesMap, concreteindexToMonitorInputIndicesMap), resultConsumer);
        }, e -> {
            log.error("unexpected error while trying to query shards and fetch docs before scanning for malicious IoC's", (Throwable)e);
            actionListener.onFailure(e);
        });
        this.fetchDataFromShards(request, fieldsToFetch, lastRunContextUpdateConsumer, (ActionListener<List<SearchHit>>)searchHitsListener);
    }

    private void fetchDataFromShards(DocLevelMonitorFanOutRequest request, List<String> fieldsToFetch, BiConsumer<ShardId, String> updateLastRunContext, ActionListener<List<SearchHit>> searchHitsListener) {
        if (request.getShardIds().isEmpty()) {
            return;
        }
        GroupedActionListener searchHitsFromAllShardsListener = new GroupedActionListener(ActionListener.wrap(searchHitsOrExceptionCollection -> {
            ArrayList<SearchHit> hits = new ArrayList<SearchHit>();
            for (SearchHitsOrException searchHitsOrException : searchHitsOrExceptionCollection) {
                if (searchHitsOrException.exception != null) continue;
                hits.addAll(searchHitsOrException.hits);
            }
            searchHitsListener.onResponse(hits);
        }, e -> {
            log.error("unexpected failure while fetch documents for threat intel monitor " + request.getMonitor().getId(), (Throwable)e);
            searchHitsListener.onResponse(Collections.emptyList());
        }), request.getShardIds().size());
        for (ShardId shardId : request.getShardIds()) {
            String shard = "" + shardId.getId();
            Map lastRunContext = request.getMonitorMetadata().getLastRunContext();
            if (!lastRunContext.containsKey(shardId.getIndexName()) || !(lastRunContext.get(shardId.getIndexName()) instanceof Map)) continue;
            HashMap shardLastSeenMapForIndex = (HashMap)lastRunContext.get(shardId.getIndexName());
            Long prevSeqNo = shardLastSeenMapForIndex.get(shard) != null ? Long.valueOf(Long.parseLong(shardLastSeenMapForIndex.get(shard).toString())) : null;
            long fromSeqNo = prevSeqNo != null ? prevSeqNo : -1L;
            long toSeqNo = Long.MAX_VALUE;
            this.fetchLatestDocsFromShard(shardId, fromSeqNo, toSeqNo, new ArrayList<SearchHit>(), request.getMonitor(), shardLastSeenMapForIndex, updateLastRunContext, fieldsToFetch, (GroupedActionListener<SearchHitsOrException>)searchHitsFromAllShardsListener);
        }
    }

    private void fetchLatestDocsFromShard(ShardId shardId, long fromSeqNo, long toSeqNo, List<SearchHit> searchHitsSoFar, Monitor monitor, Map<String, Object> shardLastSeenMapForIndex, BiConsumer<ShardId, String> updateLastRunContext, List<String> fieldsToFetch, GroupedActionListener<SearchHitsOrException> listener) {
        String shard = "" + shardId.getId();
        try {
            Long prevSeqNo;
            if (toSeqNo <= fromSeqNo || toSeqNo < 0L) {
                listener.onResponse((Object)new SearchHitsOrException(searchHitsSoFar, null));
                return;
            }
            Long l = prevSeqNo = shardLastSeenMapForIndex.get(shard) != null ? Long.valueOf(Long.parseLong(shardLastSeenMapForIndex.get(shard).toString())) : null;
            if (toSeqNo > fromSeqNo) {
                this.searchShard(shardId.getIndexName(), shard, fromSeqNo, toSeqNo, Collections.emptyList(), fieldsToFetch, (ActionListener<SearchHits>)ActionListener.wrap(hits -> {
                    if (hits.getHits().length == 0) {
                        if (toSeqNo == Long.MAX_VALUE) {
                            updateLastRunContext.accept(shardId, prevSeqNo != null ? prevSeqNo.toString() : "-1");
                        }
                        listener.onResponse((Object)new SearchHitsOrException(searchHitsSoFar, null));
                        return;
                    }
                    searchHitsSoFar.addAll(Arrays.asList(hits.getHits()));
                    if (toSeqNo == Long.MAX_VALUE) {
                        updateLastRunContext.accept(shardId, String.valueOf(hits.getHits()[0].getSeqNo()));
                    }
                    long leastSeqNoFromHits = hits.getHits()[hits.getHits().length - 1].getSeqNo();
                    long updatedToSeqNo = leastSeqNoFromHits - 1L;
                    this.fetchLatestDocsFromShard(shardId, fromSeqNo, updatedToSeqNo, searchHitsSoFar, monitor, shardLastSeenMapForIndex, updateLastRunContext, fieldsToFetch, listener);
                }, e -> {
                    if (e.getMessage().contains("all shards failed") && e.getCause().getMessage().contains("No mapping found for [_seq_no] in order to sort on")) {
                        listener.onResponse((Object)new SearchHitsOrException(Collections.emptyList(), null));
                        return;
                    }
                    log.error(() -> new ParameterizedMessage("Threat intel Monitor {}: Failed to search shard {} in index {}", new Object[]{monitor.getId(), shard, shardId.getIndexName()}), (Throwable)e);
                    listener.onResponse((Object)new SearchHitsOrException(searchHitsSoFar, (Exception)e));
                }));
            }
        }
        catch (Exception e2) {
            log.error(() -> new ParameterizedMessage("threat intel Monitor {}: Failed to run fetch data from shard [{}] of index [{}]", new Object[]{monitor.getId(), shardId, shardId.getIndexName()}), (Throwable)e2);
            listener.onResponse((Object)new SearchHitsOrException(searchHitsSoFar, e2));
        }
    }

    public void searchShard(String index, String shard, Long prevSeqNo, long maxSeqNo, List<String> docIds, List<String> fieldsToFetch, ActionListener<SearchHits> listener) {
        if (prevSeqNo != null && prevSeqNo.equals(maxSeqNo) && maxSeqNo != 0L) {
            log.debug("Sequence number unchanged.");
            listener.onResponse((Object)SearchHits.empty());
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"_seq_no").gt((Object)prevSeqNo).lte((Object)maxSeqNo));
        if (docIds != null && !docIds.isEmpty()) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"_id", docIds));
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().version(Boolean.valueOf(true)).sort("_seq_no", SortOrder.DESC).seqNoAndPrimaryTerm(Boolean.valueOf(true)).query((QueryBuilder)boolQueryBuilder).size(10000);
        if (!fieldsToFetch.isEmpty()) {
            searchSourceBuilder.fetchSource(false);
            for (String field : fieldsToFetch) {
                searchSourceBuilder.fetchField(field);
            }
        }
        SearchRequest request = new SearchRequest().indices(new String[]{index}).preference("_shards:" + shard).source(searchSourceBuilder);
        this.client.search(request, ActionListener.wrap(response -> {
            if (response.status() != RestStatus.OK) {
                log.error("Fetching docs from shard failed");
                throw new IOException("Failed to search shard: [" + shard + "] in index [" + index + "]. Response status is " + String.valueOf(response.status()));
            }
            listener.onResponse((Object)response.getHits());
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public static class SearchHitsOrException {
        private final List<SearchHit> hits;
        private final Exception exception;

        public SearchHitsOrException(List<SearchHit> hits, Exception exception) {
            assert (hits == null || hits.isEmpty() || exception == null);
            this.hits = hits;
            this.exception = exception;
        }

        public List<SearchHit> getHits() {
            return this.hits;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

