/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.parsing;

import ciir.umass.edu.utilities.RankLibError;

public class ModelLineProducer {
    private StringBuilder model = new StringBuilder();

    public StringBuilder getModel() {
        return this.model;
    }

    private boolean readUntil(char[] fullTextChar, int beginOfLineCursor, int endOfLineCursor, StringBuilder model) {
        boolean ens = true;
        if (fullTextChar[beginOfLineCursor] != '#') {
            for (int j = beginOfLineCursor; j <= endOfLineCursor; ++j) {
                model.append(fullTextChar[j]);
            }
        }
        if (endOfLineCursor > 3) {
            ens = fullTextChar[endOfLineCursor - 9] == '/' && fullTextChar[endOfLineCursor - 2] == 'l' && fullTextChar[endOfLineCursor - 1] == 'e' && fullTextChar[endOfLineCursor] == '>';
        }
        return ens;
    }

    public void parse(String fullText, LineConsumer modelConsumer) {
        char CARRIAGE_RETURN = '\r';
        char LINE_FEED = '\n';
        try {
            String content = "";
            char[] fullTextChar = fullText.toCharArray();
            int beginOfLineCursor = 0;
            for (int i = 0; i < fullTextChar.length; ++i) {
                char charNum = fullTextChar[i];
                if (charNum != CARRIAGE_RETURN && charNum != LINE_FEED) continue;
                if (fullTextChar[beginOfLineCursor] != '#') {
                    int eolCursor;
                    for (eolCursor = i; eolCursor > beginOfLineCursor && fullTextChar[eolCursor] <= ' '; --eolCursor) {
                    }
                    boolean ens = this.readUntil(fullTextChar, beginOfLineCursor, eolCursor, this.model);
                    modelConsumer.nextLine(this.model, ens);
                }
                while (charNum <= ' ' & i < fullTextChar.length) {
                    charNum = fullTextChar[i];
                    beginOfLineCursor = i++;
                }
            }
            boolean ens = this.readUntil(fullTextChar, beginOfLineCursor, fullTextChar.length - 1, this.model);
            modelConsumer.nextLine(this.model, ens);
        }
        catch (Exception ex) {
            throw RankLibError.create("Error in model loading ", ex);
        }
    }

    public static interface LineConsumer {
        public void nextLine(StringBuilder var1, boolean var2);
    }
}

