/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.deciders;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.commons.stats.ServiceMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.decisionmaker.actions.Action;
import org.opensearch.performanceanalyzer.decisionmaker.actions.ModifyCacheMaxSizeAction;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.Decision;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.HeapBasedDecider;
import org.opensearch.performanceanalyzer.grpc.ResourceEnum;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotClusterSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaRuntimeMetrics;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.store.rca.HighHeapUsageClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.BaseClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.FieldDataCacheClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.ShardRequestCacheClusterRca;

public class CacheHealthDecider
extends HeapBasedDecider {
    private static final Logger LOG = LogManager.getLogger(CacheHealthDecider.class);
    public static final String NAME = "cacheHealthDecider";
    private final FieldDataCacheClusterRca fieldDataCacheClusterRca;
    private final ShardRequestCacheClusterRca shardRequestCacheClusterRca;
    private final ImmutableMap<ResourceEnum, BaseClusterRca> cacheTypeBaseClusterRcaMap;
    List<ResourceEnum> modifyCacheActionPriorityList = new ArrayList<ResourceEnum>();
    private int counter = 0;

    public CacheHealthDecider(long evalIntervalSeconds, int decisionFrequency, FieldDataCacheClusterRca fieldDataCacheClusterRca, ShardRequestCacheClusterRca shardRequestCacheClusterRca, HighHeapUsageClusterRca highHeapUsageClusterRca) {
        super(evalIntervalSeconds, decisionFrequency, highHeapUsageClusterRca);
        this.configureModifyCacheActionPriority();
        this.fieldDataCacheClusterRca = fieldDataCacheClusterRca;
        this.shardRequestCacheClusterRca = shardRequestCacheClusterRca;
        this.cacheTypeBaseClusterRcaMap = ImmutableMap.builder().put((Object)ResourceEnum.SHARD_REQUEST_CACHE, (Object)shardRequestCacheClusterRca).put((Object)ResourceEnum.FIELD_DATA_CACHE, (Object)fieldDataCacheClusterRca).build();
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Decision operate() {
        HashSet<InstanceDetails.Id> impactedNodes = new HashSet<InstanceDetails.Id>();
        Decision decision = new Decision(System.currentTimeMillis(), NAME);
        ++this.counter;
        if (this.counter < this.decisionFrequency) {
            return decision;
        }
        this.counter = 0;
        for (ResourceEnum cacheType : this.modifyCacheActionPriorityList) {
            this.getActionsFromRca((BaseClusterRca)this.cacheTypeBaseClusterRcaMap.get((Object)cacheType), impactedNodes).forEach(decision::addAction);
        }
        return decision;
    }

    private <R extends BaseClusterRca> List<Action> getActionsFromRca(R cacheClusterRca, Set<InstanceDetails.Id> impactedNodes) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (!cacheClusterRca.getFlowUnits().isEmpty()) {
            ResourceFlowUnit flowUnit = (ResourceFlowUnit)cacheClusterRca.getFlowUnits().get(0);
            if (!flowUnit.hasResourceSummary()) {
                return actions;
            }
            List<HotNodeSummary> clusterSummary = ((HotClusterSummary)flowUnit.getSummary()).getHotNodeSummaryList();
            for (HotNodeSummary hotNodeSummary : clusterSummary) {
                if (impactedNodes.contains(hotNodeSummary.getNodeID())) continue;
                NodeKey nodeKey = new NodeKey(hotNodeSummary.getNodeID(), hotNodeSummary.getHostAddress());
                for (HotResourceSummary resource : hotNodeSummary.getHotResourceSummaryList()) {
                    Action action = this.computeBestAction(nodeKey, resource.getResource().getResourceEnum());
                    if (action == null) continue;
                    actions.add(action);
                    impactedNodes.add(hotNodeSummary.getNodeID());
                }
            }
        }
        return actions;
    }

    private void configureModifyCacheActionPriority() {
        this.modifyCacheActionPriorityList.add(ResourceEnum.SHARD_REQUEST_CACHE);
        this.modifyCacheActionPriorityList.add(ResourceEnum.FIELD_DATA_CACHE);
    }

    private Action computeBestAction(NodeKey nodeKey, ResourceEnum cacheType) {
        Action action = null;
        if (this.canUseMoreHeap(nodeKey)) {
            action = this.getAction("ModifyCacheMaxSize", nodeKey, cacheType, true);
        } else {
            ServiceMetrics.RCA_RUNTIME_METRICS_AGGREGATOR.updateStat((MeasurementSet)RcaRuntimeMetrics.NO_INCREASE_ACTION_SUGGESTED, "cacheHealthDecider:" + String.valueOf(nodeKey.getHostAddress()), (Number)1);
        }
        return action;
    }

    private Action getAction(String actionName, NodeKey nodeKey, ResourceEnum cacheType, boolean increase) {
        if ("ModifyCacheMaxSize".equals(actionName)) {
            return this.configureCacheMaxSize(nodeKey, cacheType, increase);
        }
        return null;
    }

    private ModifyCacheMaxSizeAction configureCacheMaxSize(NodeKey nodeKey, ResourceEnum cacheType, boolean increase) {
        ModifyCacheMaxSizeAction action = ModifyCacheMaxSizeAction.newBuilder(nodeKey, cacheType, this.getAppContext(), this.rcaConf).increase(increase).build();
        if (action.isActionable()) {
            return action;
        }
        return null;
    }
}

