/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.InnerHitContextBuilder;
import org.opensearch.index.query.MatchNoneQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilderVisitor;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;

public class ConstantScoreQueryBuilder
extends AbstractQueryBuilder<ConstantScoreQueryBuilder> {
    public static final String NAME = "constant_score";
    private static final ParseField INNER_QUERY_FIELD = new ParseField("filter", new String[0]);
    private final QueryBuilder filterBuilder;

    public ConstantScoreQueryBuilder(QueryBuilder filterBuilder) {
        if (filterBuilder == null) {
            throw new IllegalArgumentException("inner clause [filter] cannot be null.");
        }
        this.filterBuilder = filterBuilder;
    }

    public ConstantScoreQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.filterBuilder = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.filterBuilder);
    }

    public QueryBuilder innerQuery() {
        return this.filterBuilder;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(INNER_QUERY_FIELD.getPreferredName());
        this.filterBuilder.toXContent(builder, params);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static ConstantScoreQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        QueryBuilder query = null;
        boolean queryFound = false;
        String queryName = null;
        float boost = 1.0f;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (INNER_QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    query = ConstantScoreQueryBuilder.parseInnerQueryBuilder(parser);
                    queryFound = true;
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[constant_score] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token.isValue()) {
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryName = parser.text();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    boost = parser.floatValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[constant_score] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + String.valueOf(token) + "]", new Object[0]);
        }
        if (!queryFound) {
            throw new ParsingException(parser.getTokenLocation(), "[constant_score] requires a 'filter' element", new Object[0]);
        }
        ConstantScoreQueryBuilder constantScoreBuilder = new ConstantScoreQueryBuilder(query);
        constantScoreBuilder.boost(boost);
        constantScoreBuilder.queryName(queryName);
        return constantScoreBuilder;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query innerFilter = this.filterBuilder.toQuery(context);
        return new ConstantScoreQuery(innerFilter);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.filterBuilder);
    }

    @Override
    protected boolean doEquals(ConstantScoreQueryBuilder other) {
        return Objects.equals(this.filterBuilder, other.filterBuilder);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryBuilder rewrite = this.filterBuilder.rewrite(queryRewriteContext);
        if (rewrite instanceof MatchNoneQueryBuilder) {
            return rewrite;
        }
        if (rewrite != this.filterBuilder) {
            return new ConstantScoreQueryBuilder(rewrite);
        }
        return this;
    }

    @Override
    protected void extractInnerHitBuilders(Map<String, InnerHitContextBuilder> innerHits) {
        InnerHitContextBuilder.extractInnerHits(this.filterBuilder, innerHits);
    }

    @Override
    public void visit(QueryBuilderVisitor visitor) {
        visitor.accept(this);
        visitor.getChildVisitor(BooleanClause.Occur.FILTER).accept(this.filterBuilder);
    }
}

