"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = void 0;
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  chat: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    }),
    trace: _configSchema.schema.boolean({
      defaultValue: true
    }),
    feedback: _configSchema.schema.boolean({
      defaultValue: true
    }),
    allowRenameConversation: _configSchema.schema.boolean({
      defaultValue: true
    }),
    deleteConversation: _configSchema.schema.boolean({
      defaultValue: true
    }),
    regenerateMessage: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  incontextInsight: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  next: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  text2viz: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  alertInsight: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  smartAnomalyDetector: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  branding: _configSchema.schema.object({
    label: _configSchema.schema.maybe(_configSchema.schema.string()),
    logo: _configSchema.schema.maybe(_configSchema.schema.object({
      gradient: _configSchema.schema.maybe(_configSchema.schema.string()),
      gray: _configSchema.schema.maybe(_configSchema.schema.string())
    }))
  })
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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