/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import org.netbeans.beaninfo.editors.DataObjectPanel;
import org.netbeans.beaninfo.editors.FileEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.NbBundle;

public class DataObjectListView
extends DataObjectPanel
implements PropertyChangeListener {
    static final int DEFAULT_INSET = 10;
    private JFileChooser chooser;
    File rootFile;
    Node filteredRootNode;
    private boolean initialized = false;

    public DataObjectListView(PropertyEditorSupport propertyEditorSupport, PropertyEnv propertyEnv) {
        super(propertyEditorSupport, propertyEnv);
    }

    public void addNotify() {
        this.completeInitialization();
        super.addNotify();
    }

    private void completeInitialization() {
        NodeAcceptor nodeAcceptor;
        DataObject[] dataObjectArray;
        if (this.initialized) {
            return;
        }
        if (this.insets != null) {
            this.setBorder(new EmptyBorder(this.insets));
        } else {
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
        }
        this.setLayout(new BorderLayout(0, 2));
        this.filteredRootNode = this.rootNode;
        if (this.filteredRootNode == null) {
            if (this.dataFilter != null) {
                if (this.folderFilter != null) {
                    dataObjectArray = new DataFilter(){

                        public boolean acceptDataObject(DataObject dataObject) {
                            if (DataObjectListView.this.folderFilter.acceptDataObject(dataObject)) {
                                return true;
                            }
                            return DataObjectListView.this.dataFilter.acceptDataObject(dataObject);
                        }
                    };
                    this.filteredRootNode = RepositoryNodeFactory.getDefault().repository((DataFilter)dataObjectArray);
                } else {
                    this.filteredRootNode = RepositoryNodeFactory.getDefault().repository(this.dataFilter);
                }
            } else {
                this.filteredRootNode = this.folderFilter != null ? RepositoryNodeFactory.getDefault().repository(this.folderFilter) : RepositoryNodeFactory.getDefault().repository(DataFilter.ALL);
            }
        }
        if (this.nodeFilter != null) {
            dataObjectArray = new DataObjectPanel.FilteredChildren(this.filteredRootNode, this.nodeFilter, this.dataFilter);
            nodeAcceptor = new FilterNode(this.filteredRootNode, (Children)dataObjectArray);
            this.filteredRootNode = nodeAcceptor;
        }
        if (this.rootObject != null && (dataObjectArray = this.findNodeForObj(this.filteredRootNode, this.rootObject)) != null) {
            nodeAcceptor = this.nodeFilter;
            if (nodeAcceptor == null) {
                nodeAcceptor = new NodeAcceptor(){

                    public boolean acceptNodes(Node[] nodeArray) {
                        return false;
                    }
                };
            }
            DataObjectPanel.FilteredChildren filteredChildren = new DataObjectPanel.FilteredChildren((Node)dataObjectArray, nodeAcceptor, this.dataFilter);
            FilterNode filterNode = new FilterNode((Node)dataObjectArray, (Children)filteredChildren);
            this.filteredRootNode = filterNode;
        }
        this.rootFile = new NodeFile(DataObjectListView.getFileName(this.filteredRootNode), this.filteredRootNode);
        this.chooser = new NodeFileChooser(this.rootFile, new NodeFileSystemView());
        FileEditor.hackFileChooser(this.chooser);
        if (this.description != null) {
            this.setDescription(this.description);
        } else {
            this.setDescription(NbBundle.getMessage(DataObjectListView.class, (String)"ACSD_DataObjectPanel"));
        }
        this.chooser.setControlButtonsAreShown(false);
        this.chooser.setMultiSelectionEnabled(this.multiSelection);
        this.chooser.setFileSelectionMode(this.selectionMode);
        this.chooser.addPropertyChangeListener(this);
        if (this.dObj != null) {
            dataObjectArray = DataObjectListView.findPathTo(this.filteredRootNode, this.dObj);
            this.chooser.setCurrentDirectory(new NodeFile((String)dataObjectArray, this.dObj.getNodeDelegate()));
        }
        this.add((Component)this.chooser, "Center");
        if (this.multiSelection) {
            dataObjectArray = this.getDataObjects();
            if (this.dataFilter != null && dataObjectArray != null) {
                boolean bl = false;
                for (int i = 0; i < dataObjectArray.length; ++i) {
                    if (!this.dataFilter.acceptDataObject(dataObjectArray[i])) continue;
                    bl = true;
                    break;
                }
                this.setOkButtonEnabled(bl);
            } else {
                this.setOkButtonEnabled(dataObjectArray != null);
            }
        } else if (this.dataFilter != null && this.getDataObject() != null) {
            this.setOkButtonEnabled(this.dataFilter.acceptDataObject(this.getDataObject()));
        } else {
            this.setOkButtonEnabled(this.getDataObject() != null);
        }
        this.initialized = true;
    }

    private static String findPathTo(Node node, DataObject dataObject) {
        Node[] nodeArray;
        DataObject dataObject2;
        Stack<DataObject> stack = new Stack<DataObject>();
        for (dataObject2 = dataObject; dataObject2 != null; dataObject2 = dataObject2.getFolder()) {
            stack.push(dataObject2);
        }
        Children children = node.getChildren();
        Node node2 = null;
        while (node2 == null && !stack.isEmpty()) {
            dataObject2 = (DataObject)stack.pop();
            node2 = children.findChild(dataObject2.getNodeDelegate().getName());
            if (node2 != null) continue;
            nodeArray = children.getNodes(true);
            for (int i = 0; i < nodeArray.length && node2 == null; ++i) {
                DataObject dataObject3 = (DataObject)nodeArray[i].getCookie(DataObject.class);
                if (dataObject3 == null || dataObject3 != dataObject2) continue;
                node2 = nodeArray[i];
            }
        }
        nodeArray = new StringBuilder(DataObjectListView.getFileName(node));
        if (node2 != null) {
            nodeArray.append(File.separator).append(DataObjectListView.getFileName(node2));
            while (!stack.isEmpty()) {
                Node node3 = ((DataObject)stack.pop()).getNodeDelegate();
                nodeArray.append(File.separator).append(DataObjectListView.getFileName(node3));
            }
        }
        return nodeArray.toString();
    }

    static String getFileName(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject != null) {
            FileObject fileObject = dataObject.getPrimaryFile();
            if (fileObject.isRoot()) {
                return node.getDisplayName();
            }
            return fileObject.getNameExt();
        }
        return node.getDisplayName();
    }

    public void setDescription(String string) {
        this.description = string;
        this.getAccessibleContext().setAccessibleDescription(string);
        if (this.chooser != null) {
            this.chooser.getAccessibleContext().setAccessibleDescription(string);
        }
    }

    private Node findNode(String string) {
        String string2;
        Node node = this.filteredRootNode;
        String string3 = string;
        int n = string3.indexOf(File.separatorChar);
        if (n != -1) {
            string2 = string3.substring(0, n);
            string3 = string3.substring(n + 1);
        } else {
            string2 = string3;
        }
        string2 = string2.replace('#', File.separatorChar);
        block0: while (n != -1) {
            Node[] nodeArray = node.getChildren().getNodes(true);
            n = string3.indexOf(File.separatorChar);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string3 = string3.substring(n + 1);
            } else {
                string2 = string3;
            }
            string2 = string2.replace('#', File.separatorChar);
            for (int i = 0; i < nodeArray.length; ++i) {
                if (!string2.equals(DataObjectListView.getFileName(nodeArray[i]))) continue;
                node = nodeArray[i];
                continue block0;
            }
        }
        if (!string2.equals(DataObjectListView.getFileName(node))) {
            return null;
        }
        return node;
    }

    private Node createNode(String string) {
        String string2;
        Object object = this.filteredRootNode;
        Node node = null;
        String string3 = string;
        int n = string3.indexOf(File.separatorChar);
        if (n != -1) {
            string2 = string3.substring(0, n);
            string3 = string3.substring(n + 1);
        } else {
            string2 = string3;
        }
        string2 = string2.replace('#', File.separatorChar);
        block0: while (n != -1) {
            Node[] nodeArray = object.getChildren().getNodes(true);
            node = object;
            n = string3.indexOf(File.separatorChar);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string3 = string3.substring(n + 1);
            } else {
                string2 = string3;
            }
            string2 = string2.replace('#', File.separatorChar);
            for (int i = 0; i < nodeArray.length; ++i) {
                if (!string2.equals(DataObjectListView.getFileName(nodeArray[i]))) continue;
                object = nodeArray[i];
                continue block0;
            }
        }
        if (!string2.equals(DataObjectListView.getFileName(object))) {
            object = new FakeNode(Children.LEAF);
            object.setDisplayName(string2.replace('#', File.separatorChar));
        }
        return object;
    }

    public DataObject getDataObject() {
        Node node;
        File file;
        DataObject dataObject = null;
        if (!this.multiSelection && (file = this.chooser.getSelectedFile()) instanceof NodeFile && (node = ((NodeFile)file).getNode()) != null) {
            dataObject = (DataObject)node.getCookie(DataObject.class);
        }
        return dataObject;
    }

    public Node getNode() {
        File file;
        Node node = null;
        if (!this.multiSelection && (file = this.chooser.getSelectedFile()) instanceof NodeFile) {
            node = ((NodeFile)file).getNode();
        }
        return node;
    }

    public DataObject[] getDataObjects() {
        DataObject[] dataObjectArray = null;
        if (this.multiSelection) {
            File[] fileArray = this.chooser.getSelectedFiles();
            dataObjectArray = new DataObject[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                Node node;
                if (!(fileArray[i] instanceof NodeFile) || (node = ((NodeFile)fileArray[i]).getNode()) == null) continue;
                dataObjectArray[i] = (DataObject)node.getCookie(DataObject.class);
            }
        }
        return dataObjectArray;
    }

    public Node[] getNodes() {
        Node[] nodeArray = null;
        if (this.multiSelection) {
            File[] fileArray = this.chooser.getSelectedFiles();
            nodeArray = new Node[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                if (!(fileArray[i] instanceof NodeFile)) continue;
                nodeArray[i] = ((NodeFile)fileArray[i]).getNode();
            }
        }
        return nodeArray;
    }

    public Object getPropertyValue() throws IllegalStateException {
        if (this.multiSelection) {
            return this.getDataObjects();
        }
        return this.getDataObject();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("SelectedFilesChangedProperty".equals(propertyChangeEvent.getPropertyName()) || "SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
            File[] fileArray = this.chooser.getSelectedFiles();
            if (fileArray == null) {
                return;
            }
            if (fileArray.length == 0 && this.chooser.getSelectedFile() != null) {
                fileArray = new File[]{this.chooser.getSelectedFile()};
            }
            Node[] nodeArray = new Node[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                nodeArray[i] = fileArray[i] instanceof NodeFile ? ((NodeFile)fileArray[i]).getNode() : this.findNode(fileArray[i].getPath());
            }
            ArrayList<DataObject> arrayList = new ArrayList<DataObject>(fileArray.length);
            for (int i = 0; i < nodeArray.length; ++i) {
                DataObject dataObject;
                if (nodeArray[i] == null || (dataObject = (DataObject)nodeArray[i].getCookie(DataObject.class)) == null) continue;
                if (this.dataFilter != null) {
                    if (!this.dataFilter.acceptDataObject(dataObject)) continue;
                    arrayList.add(dataObject);
                    continue;
                }
                arrayList.add(dataObject);
            }
            DataObject[] dataObjectArray = arrayList.toArray(new DataObject[arrayList.size()]);
            boolean bl = false;
            bl = dataObjectArray.length > 0;
            if (this.multiSelection) {
                this.myEditor.setValue(dataObjectArray);
            } else if (dataObjectArray.length > 0) {
                this.myEditor.setValue(dataObjectArray[0]);
            } else {
                this.myEditor.setValue(null);
            }
            this.setOkButtonEnabled(bl);
        }
    }

    public class NodeFileChooser
    extends JFileChooser {
        NodeFileChooser(File file, FileSystemView fileSystemView) {
            super(file, fileSystemView);
        }

        protected void setup(FileSystemView fileSystemView) {
            this.setFileView(new NodeFileView());
            super.setup(fileSystemView);
        }

        public void setCurrentDirectory(File file) {
            if (file != null && !(file instanceof NodeFile)) {
                Node node = DataObjectListView.this.findNode(file.getPath());
                file = new NodeFile(file.getPath(), node);
            }
            super.setCurrentDirectory(file);
        }
    }

    private class NodeFileSystemView
    extends FileSystemView {
        private final String newFolderString = UIManager.getString("FileChooser.other.newFolder");

        NodeFileSystemView() {
        }

        public boolean isRoot(File file) {
            return DataObjectListView.this.rootFile.equals(file);
        }

        public File createNewFolder(File file) throws IOException {
            String string = file.getPath() + File.separator + this.newFolderString;
            Node node = DataObjectListView.this.findNode(string);
            if (node != null) {
                return new NodeFile(string, node);
            }
            Node node2 = DataObjectListView.this.findNode(file.getPath());
            if (node2 == null) {
                return null;
            }
            DataObject dataObject = (DataObject)node2.getCookie(DataObject.class);
            if (dataObject != null) {
                if (!(dataObject instanceof DataFolder)) {
                    return null;
                }
            } else {
                return null;
            }
            DataFolder.create((DataFolder)((DataFolder)dataObject), (String)this.newFolderString);
            node = DataObjectListView.this.createNode(string);
            return new NodeFile(string, node);
        }

        public File createFileObject(File file, String string) {
            string = string.replace(File.separatorChar, '#');
            String string2 = file.getPath() + File.separator + string;
            Node node = DataObjectListView.this.findNode(string2);
            if (node == null) {
                node = DataObjectListView.this.createNode(string2);
            }
            return new NodeFile(string2, node);
        }

        public File createFileObject(String string) {
            Node node = DataObjectListView.this.findNode(string);
            if (node == null) {
                node = DataObjectListView.this.createNode(string);
            }
            return new NodeFile(string, node);
        }

        public boolean isHiddenFile(File file) {
            return false;
        }

        public File[] getRoots() {
            return new NodeFile[]{(NodeFile)DataObjectListView.this.rootFile};
        }

        public File getHomeDirectory() {
            return DataObjectListView.this.rootFile;
        }

        public File[] getFiles(File file, boolean bl) {
            if (file instanceof NodeFile) {
                return file.listFiles();
            }
            return super.getFiles(file, bl);
        }

        public File getParentDirectory(File file) {
            if (file != null) {
                File file2 = this.createFileObject(file.getPath());
                return file2.getParentFile();
            }
            return null;
        }

        public String getSystemDisplayName(File file) {
            return file.getName();
        }
    }

    private class NodeFileView
    extends FileView {
        NodeFileView() {
        }

        public String getName(File file) {
            if (file instanceof NodeFile) {
                return file.getName();
            }
            Node node = DataObjectListView.this.findNode(file.getPath());
            if (node != null) {
                return node.getDisplayName();
            }
            return null;
        }

        public Icon getIcon(File file) {
            if (file instanceof NodeFile) {
                return ((NodeFile)file).getIcon();
            }
            Node node = DataObjectListView.this.findNode(file.getPath());
            if (node != null) {
                return new ImageIcon(node.getIcon(1));
            }
            return null;
        }
    }

    private class NodeFile
    extends File {
        private Node n;

        NodeFile(String string, Node node) {
            super(string);
            this.n = node;
        }

        NodeFile(File file, String string, Node node) {
            super(file, string);
            this.n = node;
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return true;
        }

        public boolean renameTo(File file) {
            DataObject dataObject = (DataObject)this.n.getCookie(DataObject.class);
            if (dataObject != null) {
                try {
                    dataObject.rename(file.getName());
                }
                catch (IOException iOException) {
                    Logger.getLogger(DataObjectListView.class.getName()).log(Level.WARNING, null, iOException);
                    return false;
                }
                return true;
            }
            return false;
        }

        public File[] listFiles() {
            Node[] nodeArray = this.n.getChildren().getNodes(true);
            File[] fileArray = new NodeFile[nodeArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                String string = DataObjectListView.getFileName(nodeArray[i]);
                string = string.replace(File.separatorChar, '#');
                fileArray[i] = new NodeFile(this.getPath() + File.separator + string, nodeArray[i]);
            }
            return fileArray;
        }

        public String getName() {
            if (this.n != null) {
                return this.n.getDisplayName();
            }
            return super.getName();
        }

        public File getParentFile() {
            String string = this.getParent();
            if (string == null) {
                return null;
            }
            if (this.n == null) {
                return null;
            }
            Node node = DataObjectListView.this.findNode(string);
            if (node == null) {
                return null;
            }
            return new NodeFile(string, node);
        }

        public boolean exists() {
            Node node = DataObjectListView.this.findNode(this.getPath());
            if (node != null) {
                return !(node instanceof FakeNode);
            }
            return false;
        }

        public boolean isAbsolute() {
            String string = this.getPath();
            int n = string.indexOf(File.separatorChar);
            if (n != -1) {
                string = string.substring(0, n);
            }
            return (string = string.replace('#', File.separatorChar)).equals(DataObjectListView.getFileName(DataObjectListView.this.filteredRootNode));
        }

        public boolean isDirectory() {
            if (this.n == null) {
                return false;
            }
            DataObject dataObject = (DataObject)this.n.getCookie(DataObject.class);
            if (dataObject != null) {
                return dataObject instanceof DataFolder;
            }
            return true;
        }

        public boolean isFile() {
            if (this.n == null) {
                return true;
            }
            DataObject dataObject = (DataObject)this.n.getCookie(DataObject.class);
            if (dataObject != null) {
                return !(dataObject instanceof DataFolder);
            }
            return false;
        }

        public Icon getIcon() {
            return new ImageIcon(this.n.getIcon(1));
        }

        public String getAbsolutePath() {
            return this.getPath();
        }

        public File getAbsoluteFile() {
            return new NodeFile(this.getAbsolutePath(), this.n);
        }

        public String getCanonicalPath() throws IOException {
            return this.getPath();
        }

        public File getCanonicalFile() throws IOException {
            return new NodeFile(this.getCanonicalPath(), this.n);
        }

        public Node getNode() {
            return this.n;
        }
    }

    private static class FakeNode
    extends AbstractNode {
        public FakeNode(Children children) {
            super(children);
        }
    }
}

