/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.connection.AliasedConnection;
import de.rub.nds.tlsattacker.core.connection.InboundConnection;
import de.rub.nds.tlsattacker.core.connection.OutboundConnection;
import de.rub.nds.tlsattacker.core.constants.RunningModeType;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.action.GeneralAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorkflowTraceNormalizer {
    private static final Logger LOGGER = LogManager.getLogger();

    public void normalize(WorkflowTrace trace, Config config) {
        this.normalize(trace, config, config.getDefaultRunningMode());
    }

    public void normalize(WorkflowTrace trace, Config config, RunningModeType mode) {
        List<AliasedConnection> traceConnections = trace.getConnections();
        InboundConnection defaultInCon = config.getDefaultServerConnection().getCopy();
        OutboundConnection defaultOutCon = config.getDefaultClientConnection().getCopy();
        if (traceConnections == null) {
            traceConnections = new ArrayList<AliasedConnection>();
            trace.setConnections(traceConnections);
        }
        if (traceConnections.isEmpty()) {
            if (null == mode) {
                mode = RunningModeType.CLIENT;
            }
            switch (mode) {
                case CLIENT: {
                    traceConnections.add(defaultOutCon);
                    break;
                }
                case SERVER: {
                    traceConnections.add(defaultInCon);
                    break;
                }
                case MITM: {
                    traceConnections.add(defaultInCon);
                    traceConnections.add(defaultOutCon);
                    break;
                }
                default: {
                    throw new ConfigurationException("No connections defined in workflow trace and default configuration for this running mode (" + (Object)((Object)mode) + ") is not supported. Please define some connections in the workflow trace.\n");
                }
            }
        }
        if (traceConnections.size() == 1 && mode == RunningModeType.MITM) {
            if (traceConnections.get(0).getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
                traceConnections.add(defaultInCon);
            } else {
                traceConnections.add(defaultOutCon);
            }
        }
        block9: for (AliasedConnection traceCon : traceConnections) {
            ConnectionEndType localConEndType = traceCon.getLocalConnectionEndType();
            if (null == localConEndType) {
                throw new ConfigurationException("WorkflowTrace defines a connection with anempty localConnectionEndType. Don't know how to handle this!");
            }
            switch (traceCon.getLocalConnectionEndType()) {
                case CLIENT: {
                    traceCon.normalize(defaultOutCon);
                    continue block9;
                }
                case SERVER: {
                    traceCon.normalize(defaultInCon);
                    continue block9;
                }
            }
            throw new ConfigurationException("WorkflowTrace defines a connection with anunknown localConnectionEndType (" + localConEndType + "). Don't know how to handle this!");
        }
        boolean isSingleConnectionWorkflow = true;
        GeneralAction customDefaults = new GeneralAction(trace.getConnections().get(0).getAlias());
        if (trace.getConnections().size() > 1) {
            isSingleConnectionWorkflow = false;
        }
        for (TlsAction action : trace.getTlsActions()) {
            if (isSingleConnectionWorkflow) {
                action.normalize(customDefaults);
            } else {
                action.normalize();
            }
            action.setSingleConnectionWorkflow(isSingleConnectionWorkflow);
        }
        this.assertNormalizedWorkflowTrace(trace);
    }

    public Boolean isNormalized(WorkflowTrace trace) {
        try {
            this.assertNormalizedWorkflowTrace(trace);
        }
        catch (ConfigurationException e) {
            return false;
        }
        return true;
    }

    public void assertNormalizedWorkflowTrace(WorkflowTrace trace) {
        List<AliasedConnection> connections = trace.getConnections();
        if (connections == null || connections.isEmpty()) {
            throw new ConfigurationException("Workflow trace not well defined. Trace does not define any connections.");
        }
        ArrayList<String> knownAliases = new ArrayList<String>();
        for (AliasedConnection con : connections) {
            String conAlias = con.getAlias();
            if (conAlias == null || conAlias.isEmpty()) {
                throw new ConfigurationException("Workflow trace not well defined. Trace contains connections with empty alias");
            }
            if (knownAliases.contains(conAlias)) {
                throw new ConfigurationException("Workflow trace not well defined. Trace contains connections with the same alias");
            }
            knownAliases.add(conAlias);
        }
        for (TlsAction action : trace.getTlsActions()) {
            try {
                action.assertAliasesSetProperly();
            }
            catch (ConfigurationException e) {
                throw new ConfigurationException("Workflow trace not well defined. " + e.getLocalizedMessage());
            }
            if (knownAliases.containsAll(action.getAllAliases())) continue;
            throw new ConfigurationException("Workflow trace not well defined. Trace has action with reference to unknown connection alias, action: " + action.toCompactString() + ", known aliases: " + knownAliases);
        }
    }
}

