/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import de.rub.nds.tlsattacker.core.constants.CipherAlgorithm;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;

public enum BulkCipherAlgorithm {
    NULL,
    IDEA,
    DESede,
    DES40,
    DES,
    RC4,
    RC2,
    FORTEZZA,
    CAMELLIA,
    SEED,
    ARIA,
    CHACHA20_POLY1305,
    GOST28147,
    AES;


    public static BulkCipherAlgorithm getBulkCipherAlgorithm(CipherSuite cipherSuite) {
        String cipher = cipherSuite.toString().toUpperCase();
        if (cipher.contains("3DES_EDE")) {
            return DESede;
        }
        if (cipher.contains("AES")) {
            return AES;
        }
        if (cipher.contains("RC4")) {
            return RC4;
        }
        if (cipher.contains("RC2")) {
            return RC2;
        }
        if (cipher.contains("WITH_NULL")) {
            return NULL;
        }
        if (cipher.contains("IDEA")) {
            return IDEA;
        }
        if (cipher.contains("DES40")) {
            return DES40;
        }
        if (cipher.contains("DES")) {
            return DES;
        }
        if (cipher.contains("WITH_FORTEZZA")) {
            return FORTEZZA;
        }
        if (cipher.contains("CAMELLIA")) {
            return CAMELLIA;
        }
        if (cipher.contains("SEED")) {
            return SEED;
        }
        if (cipher.contains("ARIA")) {
            return ARIA;
        }
        if (cipher.contains("28147")) {
            return GOST28147;
        }
        if (cipher.contains("CHACHA20_POLY1305")) {
            return CHACHA20_POLY1305;
        }
        throw new UnsupportedOperationException("The cipher algorithm from " + (Object)((Object)cipherSuite) + " is not supported yet.");
    }

    public static BulkCipherAlgorithm getBulkCipherAlgorithm(CipherAlgorithm cipherAlgorithm) {
        String cipher = cipherAlgorithm.toString().toUpperCase();
        if (cipher.contains("DES_EDE")) {
            return DESede;
        }
        if (cipher.contains("AES")) {
            return AES;
        }
        if (cipher.contains("RC4")) {
            return RC4;
        }
        if (cipher.contains("RC2")) {
            return RC2;
        }
        if (cipher.contains("NULL")) {
            return NULL;
        }
        if (cipher.contains("IDEA")) {
            return IDEA;
        }
        if (cipher.contains("DES40")) {
            return DES40;
        }
        if (cipher.contains("DES")) {
            return DES;
        }
        if (cipher.contains("FORTEZZA")) {
            return FORTEZZA;
        }
        if (cipher.contains("CAMELLIA")) {
            return CAMELLIA;
        }
        if (cipher.contains("SEED")) {
            return SEED;
        }
        if (cipher.contains("ARIA")) {
            return ARIA;
        }
        if (cipher.contains("CHACHA20_POLY1305")) {
            return CHACHA20_POLY1305;
        }
        throw new UnsupportedOperationException("The cipher algorithm from " + cipherAlgorithm.name() + " is not supported yet.");
    }

    public String getJavaName() {
        if (this == DES40) {
            return "DES";
        }
        return this.toString();
    }
}

