import { Struct } from '../struct';
/**
 * Creates a NIB (Network Information Base) struct.
 *
 * *Definition from Z-Stack 3.0.2 `nwk.h`*
 *
 * @param data Data to initialize structure with.
 */
export declare const nib: (data?: Buffer | Buffer[]) => import("../struct").BuiltStruct<Struct & Record<"SequenceNum", number> & Record<"PassiveAckTimeout", number> & Record<"MaxBroadcastRetries", number> & Record<"MaxChildren", number> & Record<"MaxDepth", number> & Record<"MaxRouters", number> & Record<"dummyNeighborTable", number> & Record<"BroadcastDeliveryTime", number> & Record<"ReportConstantCost", number> & Record<"RouteDiscRetries", number> & Record<"dummyRoutingTable", number> & Record<"SecureAllFrames", number> & Record<"SecurityLevel", number> & Record<"SymLink", number> & Record<"CapabilityFlags", number> & Record<"TransactionPersistenceTime", number> & Record<"nwkProtocolVersion", number> & Record<"RouteDiscoveryTime", number> & Record<"RouteExpiryTime", number> & Record<"nwkDevAddress", number> & Record<"nwkLogicalChannel", number> & Record<"nwkCoordAddress", number> & Record<"nwkCoordExtAddress", Buffer<ArrayBufferLike>> & Record<"nwkPanId", number> & Record<"nwkState", number> & Record<"channelList", number> & Record<"beaconOrder", number> & Record<"superFrameOrder", number> & Record<"scanDuration", number> & Record<"battLifeExt", number> & Record<"allocatedRouterAddresses", number> & Record<"allocatedEndDeviceAddresses", number> & Record<"nodeDepth", number> & Record<"extendedPANID", Buffer<ArrayBufferLike>> & Record<"nwkKeyLoaded", number> & Record<"spare1", import("../struct").BuiltStruct<Struct & Record<"keySeqNum", number> & Record<"key", Buffer<ArrayBufferLike>>>> & Record<"spare2", import("../struct").BuiltStruct<Struct & Record<"keySeqNum", number> & Record<"key", Buffer<ArrayBufferLike>>>> & Record<"spare3", number> & Record<"spare4", number> & Record<"nwkLinkStatusPeriod", number> & Record<"nwkRouterAgeLimit", number> & Record<"nwkUseMultiCast", number> & Record<"nwkIsConcentrator", number> & Record<"nwkConcentratorDiscoveryTime", number> & Record<"nwkConcentratorRadius", number> & Record<"nwkAllFresh", number> & Record<"nwkManagerAddr", number> & Record<"nwkTotalTransmissions", number> & Record<"nwkUpdateId", number>>;
//# sourceMappingURL=nib.d.ts.map